<script>
    var SiteUser = function() {

        const searchUrl = "{$GLOBAL_URL}/public/search.php";
        const feedbackUrl = "{$GLOBAL_URL}/public/feedback.php";

        var notification = $('.notification'), i = 60, authForm = $('#auth'), registerForm = $('#register'),
	        recoveryForm = $("#recovery"), recoveryConfirmForm = $("#recovery_confirm");

        // $( document ).ready(function() {
        //     $('#checkbox_agree').click(function() {
        //         $("#checkbox_agree").toggle(this.checked);
        //         if($("#checkbox_agree").is(':checked')) {
        //             $(".agree").removeClass('agree_error');
        //         }
        //     });
        // });

        var _register = function () {
            registerForm.validate({
                ignore: ':hidden',
                rules: {
                    "user[loginName]": { required: true, minlength: 5, maxlength: 17 },
                    "user[email]": { required: true, email: true },
                    "user[password]": { required: true, minlength: 3 },

                },
                messages: {
                    "user[loginName]": { required: " Введите, пожалуйста login",  minlength: "Error min", maxlength: 'Error max'  },
                    "user[email]": { required: " Введите, пожалуйста email",  email: "Укажите корректный email" },
                    "user[password]": { required: " Введите, пожалуйста пароль",  minlength: "Слишком коротко!" }
                },
                submitHandler: function () {
                    $.post(registerForm.attr('action'), registerForm.serialize(), function(response) {
                        console.log('response => ', response);
                        if (response.status === 200) {
	                        setTimeout(function () {
		                        window.location.reload();
	                        }, 2400);
                        }
                        notification.fadeIn().html(response.message).css('color', response.color);
                    });
                },
                errorPlacement: function(error, element) {
                    var placement = element.data('error');
                    if (placement) {
                        $(placement).append(error);
                        $(element).css('border-color', '#ec0000');
                    } else {
                        error.insertAfter(element);
                    }
                },
                highlight: function (element) {
                    $(element).css('border-color', '#ec0000');
                    $(element).addClass('error');
                },
                unhighlight: function (element) {
                    $(element).removeClass('error');
                    $(element).css('border-color', '#bac2ca');
                }
            });
        }

        var _authenticate = function () {

            authForm.validate({
                ignore: ':hidden',
                rules: {
                    "user[loginName]": { required: true, minlength: 5, maxlength: 30 },
                    "user[password]": { required: true, minlength: 3 },

                },
                messages: {
                    "user[loginName]": { required: " Введите, пожалуйста номер телефона",  minlength: "Error min", maxlength: 'Error max'  },
                    "user[password]": { required: " Введите, пожалуйста пароль",  minlength: "Слишком коротко!" }
                },
                submitHandler: function () {
                    $.post(authForm.attr('action'), authForm.serialize(), function(response) {
                        console.log('response => ', response);
                        if (response.status === 200) {
	                        setTimeout(function () {
                                window.location.href = '/user/';
		                        // window.location.reload();
	                        }, 400);
                        }
                        notification.fadeIn().html(response.message).css('color', response.color);
                    });
                },
                errorPlacement: function(error, element) {
                    var placement = element.data('error');
                    if (placement) {
                        $(placement).append(error);
                        $(element).css('border-color', '#ec0000');
                    } else {
                        error.insertAfter(element);
                    }
                },
                highlight: function (element) {
                    $(element).css('border-color', '#ec0000');
                    $(element).addClass('error');
                },
                unhighlight: function (element) {
                    $(element).removeClass('error');
                    $(element).css('border-color', '#bac2ca');
                }
            });
        }

        {* Восстановление пароля *}
        var _recoveryForm = function() {

	        recoveryForm.validate({
		        ignore: ':hidden',
		        rules: {
		            "user[email]": { required: true, minlength: 5 }
		        },
		        messages: {
		            "user[email]": { required: " Введите, пожалуйста email", minlength: "Слишком коротко!" } },
		        submitHandler: function () {
			        $.post(recoveryForm.attr('action'), recoveryForm.serialize(), function (response) {
				        if (response.status === 200) {
					        if (response.sms === true) {
						        onTimer();
						        setTimeout(function () {
							        notification.text('');
						        }, 2500);
					        } else if (response.confirm) {
						        setTimeout(function () {
							        window.location.href = '/user/';
						        }, 400);
					        }
				        }
                        notification.fadeIn().text(response.message).css('color', response.color);
                    });
		        },
		        errorPlacement: function(error, element) {
			        var placement = element.data('error');
			        if (placement) {
				        $(placement).append(error);
				        $(element).css('border-color', '#ec0000');
			        } else {
				        error.insertAfter(element);
			        }
		        },
		        highlight: function (element) {
			        $(element).css('border-color', '#ec0000');
			        $(element).addClass('error');
		        },
		        unhighlight: function (element) {
			        $(element).removeClass('error');
			        $(element).css('border-color', '#bac2ca');
		        }
	        });

            recoveryConfirmForm.validate({
                ignore: ':hidden',
                rules: { "user[newPassword]": { required: true, minlength: 5 } },
                messages: { "user[newPassword]": { required: " Введите, пожалуйста email", minlength: "Слишком коротко!" } },
                submitHandler: function () {
                    $.post(recoveryConfirmForm.attr('action'), recoveryConfirmForm.serialize(), function (response) {
                        console.log(response)
                        if (response.status === 200) {
                            if (response.sms === true) {
                                onTimer();
                                setTimeout(function () {
                                    notification.text('');
                                }, 2500);
                            } else if (response.confirm) {
                                setTimeout(function () {
                                    window.location.href = '/user/';
                                }, 400);
                            }
                        }
                        notification.fadeIn().text(response.message).css('color', response.color);
                    });
                },
                errorPlacement: function(error, element) {
                    var placement = element.data('error');
                    if (placement) {
                        $(placement).append(error);
                        $(element).css('border-color', '#ec0000');
                    } else {
                        error.insertAfter(element);
                    }
                },
                highlight: function (element) {
                    $(element).css('border-color', '#ec0000');
                    $(element).addClass('error');
                },
                unhighlight: function (element) {
                    $(element).removeClass('error');
                    $(element).css('border-color', '#bac2ca');
                }
            });

        };

        {* таймер *}
        var onTimer =  function() {
            document.getElementById('confirm-timer').innerHTML = i;
            i--;
            if (i < 0) {
                window.location.reload();
            }
            else {
                setTimeout(onTimer, 1000);
            }
        }

        {* Выход *}
        var _logOutForm = function() {
            $('#logout').click(function() {
                $.post(userUrl, { action: "logout" }, function (response) {
                    console.log(response);
                    if (response.status === 200) {
                        setTimeout(function () {
                            window.location.href = "/";
                        }, 200);
                    }
                });
            });

        };
        {* поиск *}
        var _searchForm = function () {

            $("input#search_input").bind('input', function() {
	            var query = $('#search_input').val();
	            if (query.length > 1) {
	                $.post(searchUrl, { action: 'search', query : query }, function(response) {
	                    console.log(response);
	                    $('ul#search_list').empty();
	                    $.each(response, function( index, value ) {
	                        console.log(value );
	                        $('ul#search_list').append('<li style="padding: 2px 10px;"><a style="font-size: 12px;" href="' + value.url + '">' + value.name + '</a></li>');
	                    });
	                });
                } else {
	            	$('ul#search_list').replaceWith('<ul id="search_list" style="position: absolute; width: 100%;top: 50px;background: #fff;"></ul>');
	            }
            });
        }
        {* форма обратной связи *}
        var _feedbackForm = function () {

            var mainForm = $('#main_form'), mainFormButton = $('#main_form_button');
            mainForm.validate({
                ignore: ':hidden',
                rules: {
                    "feedback[firstName]": { required: true },
                    "feedback[lastName]" : { required: true },
                    "feedback[phone]" : { required: true },
                    "feedback[message]" : { required: true },
                    // "feedback[personal]" : { required: true }
                },
                messages: {
                    "feedback[firstName]": { required: " Введите, пожалуйста имя и фамилию" },
                    "feedback[lastName]" : { required: " Введите, пожалуйста имя и фамилию" },
                    "feedback[phone]" : { required: " Введите, пожалуйста номер телефона" },
                    "feedback[message]" : { required: " Введите, пожалуйста сообщение" },
                    // "feedback[personal]" : { required: " Необходимо согласится на обработку персональных данных" }
                },
                submitHandler: function () {
                    var IsChecked = $('input[name="agree"]:checked').length > 0;
                    console.log(IsChecked)

                    if (IsChecked) {
                        console.log("true")
	                    // отловить checkbox и сделать проверку
	                    mainFormButton.attr('disabled', true);
	                    $.post(feedbackUrl, mainForm.serialize(), function (response) {
	                        console.log(response)
	                        notification.fadeIn().text(response.message).css('color', response.color);

	                        if (response.status === 200) {
	                            mainForm.fadeOut();
	                        } else {
	                            mainFormButton.attr('disabled', false);
	                        }
	                    });
                    } else {
                        console.log("false")
                        $(".agree").addClass('agree_error');

                    }
                },
                errorPlacement: function(error, element) {
                    var placement = element.data('error');

                    if (placement) {
                        $(placement).append(error);
                        $(element).css('border-color', '#ec0000').css('color', '#ec0000');
                    } else if (placement == 'personal') {

	                } else {
                        error.insertAfter(element);
                    }
                },
                highlight: function (element) {
                    $(element).css('border-color', '#ec0000').css('color', '#ec0000');
                    $(element).addClass('error');
                },
                unhighlight: function (element) {
                    $(element).removeClass('error');
                    $(element).css('border-color', '#bac2ca').css('color', '#7e868e');
                }
            });

        }

        return {
            init: function() {
                _register();
                _authenticate();
                _recoveryForm();
                _logOutForm();
                _searchForm();
                _feedbackForm();
            }
        }
    }();

    // Initialize module
    // ------------------------------
    document.addEventListener('DOMContentLoaded', function() {
        SiteUser.init();
    });

</script>