import { addSelectorOnes, removeSelectorOnes } from './common.js'
import { forAjax } from './forAjax.js'

function _examinationHeandler() {
    const validBtnArr = document.querySelectorAll('.valid-btn_js')

    for (let index = 0; index < validBtnArr.length; index++) {
        const btn = validBtnArr[index]

        let form = btn.closest('.form_js'),
            InputArr = form.querySelectorAll('.valid-field_js')

        for (let index = 0; index < InputArr.length; index++) {
            const input = InputArr[index]

            let inputWrap = input.parentElement

            input.addEventListener('input', (e) => {
                if (input.value == '') {
                    addSelectorOnes(inputWrap, 'input-empty')
                    _removeElement(inputWrap.querySelector('.text-empty'))
                    _creatElem(input, inputWrap)
                } else {
                    removeSelectorOnes(inputWrap, 'input-empty')
                    _removeElement(inputWrap.querySelector('.text-empty'))
                }
            })

            input.addEventListener('blur', (e) => {
                if (input.classList.contains('valid-mail_js') && !input.value.includes('@') && input.value.length > 0) {
                    _removeElement(inputWrap.querySelector('.text-empty'))
                    _creatElemMail(input, inputWrap)
                    addSelectorOnes(inputWrap, 'input-empty')
                }
            })
        }
    }
}

function _validInput(element) {
    return element.value.trim() != ''
}

function _validInputPhone(element) {
    return element.value.includes('@')
}

function _removeElement(elem) {
    if (elem) {
        elem.remove()
    }
}

function _creatElem(attr, elemInsert) {
    let inputText = attr.getAttribute('data-empty'),
        dangerTaxt = document.createElement('div')

    dangerTaxt.classList.add('text-empty')
    dangerTaxt.textContent = inputText

    Object.assign(dangerTaxt.style, {
        transition: '0s all ease',
        opacity: '0',
        transform: 'translateY(20px)',
    })

    setTimeout(() => {
        Object.assign(dangerTaxt.style, {
            transition: '0.3s all ease',
            opacity: '1',
            transform: 'translateY(0)',
        })
    }, 0)

    elemInsert.insertAdjacentElement('beforeend', dangerTaxt)
}

function _creatElemMail(attr, elemInsert) {
    let inputText = attr.getAttribute('data-mail'),
        dangerTaxt = document.createElement('div')

    dangerTaxt.classList.add('text-empty')
    dangerTaxt.textContent = inputText

    Object.assign(dangerTaxt.style, {
        transition: '0s all ease',
        opacity: '0',
        transform: 'translateY(20px)',
    })

    setTimeout(() => {
        Object.assign(dangerTaxt.style, {
            transition: '0.3s all ease',
            opacity: '1',
            transform: 'translateY(0)',
        })
    }, 0)

    elemInsert.insertAdjacentElement('beforeend', dangerTaxt)
}

function _creatElemFile(attr, elemInsert) {
    let inputText = attr.getAttribute('data-file'),
        dangerTaxt = document.createElement('div')

    dangerTaxt.classList.add('text-empty')
    dangerTaxt.textContent = inputText

    Object.assign(dangerTaxt.style, {
        transition: '0s all ease',
        opacity: '0',
        transform: 'translateY(20px)',
    })

    setTimeout(() => {
        Object.assign(dangerTaxt.style, {
            transition: '0.3s all ease',
            opacity: '1',
            transform: 'translateY(0)',
        })
    }, 0)

    elemInsert.insertAdjacentElement('beforeend', dangerTaxt)
}

function _sizeFule(element) {
    return element.files[0].size < 1000000
}

//
function formHeandler() {
    _examinationHeandler()

    document.addEventListener('click', (e) => {
        let target = e.target.closest('.valid-btn_js')

        if (target) {
            let form = target.closest('.form_js'),
                inputArr = form.querySelectorAll('.valid-field_js'),
                inputHidden = form.querySelector('.input-hidden_js'),
                inputMailArr = form.querySelectorAll('.valid-mail_js'),
                inputFileArr = form.querySelectorAll('.valid-file_js'),
                inputBtn = form.querySelector('.valid-btn_js')

            for (let index = 0; index < inputArr.length; index++) {
                const input = inputArr[index]
                let inputWrap = input.parentElement

                _removeElement(inputWrap.querySelector('.text-empty'))

                if (input.value == '') {
                    addSelectorOnes(inputWrap, 'input-empty')
                    _creatElem(input, inputWrap)
                } else if (input.classList.contains('valid-mail_js') && !input.value.includes('@')) {
                    addSelectorOnes(inputWrap, 'input-empty')
                    _creatElemMail(input, inputWrap)
                } else if (input.classList.contains('valid-file_js') && input.files[0].size > 1000000) {
                    addSelectorOnes(inputWrap, 'input-empty')
                    _creatElemFile(input, inputWrap)
                } else if (input.value != '' || Array.from(inputMailArr).every(_validInputPhone)) {
                    removeSelectorOnes(inputWrap, 'input-empty')
                }
            }

            if (Array.from(inputArr).every(_validInput) && Array.from(inputMailArr).every(_validInputPhone) && Array.from(inputFileArr).every(_sizeFule) && inputHidden.value == 'NOSPAM') {
                e.preventDefault()
                console.log(1)
                inputBtn.setAttribute('data-valid', 'valid')
            } else {
                e.preventDefault()
                console.log(2)
                inputBtn.removeAttribute('data-valid')
            }
        }
    })

    forAjax()
}

export const formValidate = () => {
    formHeandler()
}
