import { formValidate } from './formValidate.js'
import { removeSelectorInArr } from './common.js'

function selectHeandler() {
    function _careatList() {
        const selectArr = document.querySelectorAll('.select_js')

        for (let index = 0; index < selectArr.length; index++) {
            const select = selectArr[index]

            let trueSelect = select.querySelector('select'),
                trueOptionArr = trueSelect.querySelectorAll('option'),
                fakeSelectListWrap = select.querySelector('.select-list-wrap_js'),
                createList = document.createElement('ul')

            let trueOptionNullArr = Array.from(trueOptionArr)
                .filter((trueOption) => trueOption.getAttribute('hidden') === null)
                .map((x) => x.textContent)

            let trueOptionValueArr = Array.from(trueOptionArr)
                .filter((trueOption) => trueOption.getAttribute('hidden') === null)
                .map((x) => x.value)

            for (let index = 0; index < trueOptionNullArr.length; index++) {
                const trueOptionText = trueOptionNullArr[index]
                const trueOptionValue = trueOptionValueArr[index]

                let createItem = document.createElement('li')
                createItem.classList.add('select-btn_js')
                createItem.textContent = trueOptionText

                if (trueOptionValue) {
                    createItem.setAttribute('data-value', trueOptionValue)
                }

                createList.insertAdjacentElement('beforeend', createItem)
            }

            fakeSelectListWrap.insertAdjacentElement('beforeend', createList)
        }
    }

    _careatList()

    let selectArr = document.querySelectorAll('.select_js'),
        selectDropArr = document.querySelectorAll('.select-list-wrap_js'),
        selectInputArr = document.querySelectorAll('.select-field_js')

    for (let index = 0; index < selectArr.length; index++) {
        const select = selectArr[index]

        let selectWord = select.querySelector('.select-field-word_js'),
            selectDrop = select.querySelector('.select-list-wrap_js'),
            selectInput = select.querySelector('.select-field_js'),
            trueSelect = select.querySelector('select'),
            selectBtn = select.querySelectorAll('.select-btn_js'),
            trueOptionArr = trueSelect.querySelectorAll('option')

        let trueOptionNotHiddenArr = Array.from(trueOptionArr)
            .filter((trueOption) => !trueOption.hidden)
            .map((x) => x)

        selectInput.addEventListener('click', (e) => {
            if (selectInput.classList.contains('active')) {
                removeSelectorInArr([selectInputArr, selectDropArr], 'active')
            } else {
                removeSelectorInArr([selectInputArr, selectDropArr], 'active')

                selectInput.classList.toggle('active')
                selectDrop.classList.toggle('active')
            }
        })

        for (let index = 0; index < selectBtn.length; index++) {
            const btn = selectBtn[index]
            const trueOption = trueOptionArr[index]
            const trueOptionNotHidden = trueOptionNotHiddenArr[index]

            if (trueOptionNotHidden.selected && !trueOption.selected) {
                btn.classList.add('active')
                selectWord.textContent = trueOptionNotHidden.textContent
            }

            if (!trueOptionNotHidden.selected && trueOption.selected) {
                selectWord.textContent = trueOption.textContent
            }

            // if (trueOption.selected) {
            //     if (!trueOption.hidden) {
            //         btn.classList.add('active')
            //         selectWord.textContent = trueOption.textContent
            //     }

            //     selectWord.textContent = trueOption.textContent
            // }

            btn.addEventListener('click', (e) => {
                removeSelectorInArr([selectInputArr, selectDropArr, selectBtn], 'active')

                btn.classList.add('active')
                selectWord.textContent = btn.textContent
                trueSelect.value = trueOptionNotHidden.value

                if (select.classList.contains('select-as-link_js')) {
                    window.location.href = `${btn.getAttribute('data-value')}`
                }
            })
        }
    }

    function _eventCancelDrop(ev) {
        let target = ev.target.closest('.select-field_js'),
            targetListWrap = ev.target.closest('.select-list-wrap_js')

        if (!target && !targetListWrap) {
            removeSelectorInArr([selectInputArr, selectDropArr], 'active')
        }
    }

    document.addEventListener('click', (e) => _eventCancelDrop(e))
    document.addEventListener('keydown', (e) => _eventCancelDrop(e))
}

function phoneMask() {
    ;[].forEach.call(document.querySelectorAll('.phone_js'), function (input) {
        let keyCode

        function mask(event) {
            event.keyCode && (keyCode = event.keyCode)
            let pos = this.selectionStart
            if (pos < 3) event.preventDefault()
            let matrix = '+998 (__) ___-__-__',
                i = 0,
                def = matrix.replace(/\D/g, ''),
                val = this.value.replace(/\D/g, ''),
                newValue = matrix.replace(/[_\d]/g, function (a) {
                    return i < val.length ? val.charAt(i++) || def.charAt(i) : a
                })
            i = newValue.indexOf('_')
            if (i != -1) {
                i < 5 && (i = 3)
                newValue = newValue.slice(0, i)
            }
            let reg = matrix
                .substr(0, this.value.length)
                .replace(/_+/g, function (a) {
                    return '\\d{1,' + a.length + '}'
                })
                .replace(/[+()]/g, '\\$&')
            reg = new RegExp('^' + reg + '$')
            if (!reg.test(this.value) || this.value.length < 5 || (keyCode > 47 && keyCode < 58)) this.value = newValue
            if (event.type == 'blur' && this.value.length < 5) this.value = ''
        }

        input.addEventListener('input', mask, false)
        input.addEventListener('focus', mask, false)
        input.addEventListener('blur', mask, false)
        input.addEventListener('keydown', mask, false)
    })
}

//
export const form = () => {
    selectHeandler()
    phoneMask()
    formValidate()
}
