import { elementsHendler } from '../interactive/element.js'
import { slider } from '../interactive/slider.js'
import { modal } from '../interactive/modal.js'
import { map } from './map.js'

export const addSelectorArr = (arrNode, selector) => {
    Array.from(arrNode).forEach((element) => {
        element.classList.add(selector)
    })
}

export const removeSelectorInArr = (arrNode, selector) => {
    arrNode.forEach((arr) => {
        Array.from(arr).forEach((element) => {
            element.classList.remove(selector)
        })
    })
}

export const common = () => {
    function _fullHeight() {
        function setHeight() {
            var vh = window.innerHeight * 0.01
            document.documentElement.style.setProperty('--vh', `${vh}px`)
        }

        setHeight()
        window.addEventListener('resize', setHeight)
    }

    _fullHeight()

    slider()
    modal()
    elementsHendler()

    map()
}
