<?php

include "../includes/visitor.inc.php";

ini_set('precision', 100);

use Mnv\Models\Telegram\TelegramConfig;
use Mnv\Modules\Telegram\Models\Categories;
use Mnv\Modules\Telegram\Telegram;
use Mnv\Modules\Telegram\TelegramUser;

use Mnv\Modules\Telegram\Commands\Commands;

use Mnv\Modules\Telegram\Pages\Start;
use Mnv\Modules\Telegram\Pages\Contacts;
use Mnv\Modules\Telegram\Pages\Articles;
use Mnv\Modules\Telegram\Pages\ObjectPage;

use Mnv\Modules\Telegram\Models\AddingObject;

use Mnv\Modules\Telegram\Controllers\CategoryController;
use Mnv\Modules\Telegram\Controllers\CategoryAddingController;

$bot = new Telegram(TelegramConfig::init()->get('botApiKey'));

$chatID = !is_null($bot->Callback_ChatID()) ? $bot->Callback_ChatID() : $bot->ChatID();
$text   = $bot->Text();
$data   = $bot->getData();

$callbackData   = $bot->Callback_Data();
$MessageID      = $bot->MessageID();
$callbackMessage = $bot->Callback_Message();
$message = !empty($callbackMessage) ? $callbackMessage : $data['message'];

try {
    $user = new TelegramUser($message);
    $lang = $user->getLanguage();
    Commands::lang($lang);

//    sendMessage(json_encode($data,JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
    //sendMessage(json_encode($text,JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
    //sendMessage(json_encode($chatID,JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
    //
//    sendMessage(json_encode($callbackData,JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
    //sendMessage(json_encode($callbackMessage,JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));

    $bot->setMyCommands([
        "commands" => json_encode([
            ["command" => '/start', "description" => Commands::getMessageText('start_bot')],
//            ["command" => '/myobjects', "description" => 'Мои объекты'],
        ]),
        'language_code' => $lang
    ]);
//$bot->deleteMyCommands([ ]);

//sendMessage($text);


    if (!is_null($callbackData)) {

        // оправить локацию
        if (isContains($callbackData, '/map_')) {
            $coordinates = str_replace('/map_', '', $callbackData);
            $coordinates = explode(", ", $coordinates);
            $bot->sendLocation(['chat_id' => $chatID, 'latitude' => $coordinates[0], 'longitude' => $coordinates[1]]);
        }
        // после выбора района открыть категории
        if (isContains($callbackData, '/dist_')) {
            $districtName = str_replace('/dist_', '', $callbackData);
            $user->setDistrict($districtName);
            CategoryController::init()->execute($bot, $chatID);
        }

        // категории
        if (isContains($callbackData, '/AddingObject')) {
            CategoryAddingController::init()->execute($bot, $chatID);
        }

        // категории
        if (isContains($callbackData, '/Category')) {
            CategoryController::init()->execute($bot, $chatID);
        }
        // объекты
        if (isContains($callbackData, '/Articles')) {
            Articles::init()->execute($bot, $user, $chatID);
        }

        // возврат на главную
        if (isContains($callbackData, '/back_to_main')) {
//            Start::mainRestart($bot, $user, $chatID, $MessageID);
            Start::main($bot, $user, $chatID,  $MessageID, 3, '🏠');
        }
        if (isContains($callbackData, '/back_to_district')) {
            Contacts::districts($bot, $chatID, $MessageID, true);
        }
    }

// обнуляем номер страницы
    if ($text == '/start') {
        Start::welcome($bot, $user, $chatID);
    } else if ($text == '/myobjects') {
        $user->setPage(1000);

    }

    $page = $user->getPage();

//    sendMessage($page);
    switch ($page) {

        case 1000: // Стартовая страница и выбор языка
            $bot->sendMessage([
                'chat_id'       => $chatID,
                'text'          => Commands::getMessageText('page_development'),
                'parse_mode'    => "HTML"
            ]);
            break;

        case 0: // Стартовая страница и выбор языка
            switch ($text) {
                case Commands::getMessageText('uz'):
                    $user->setLanguage('uz');
                    $lang = $user->getLanguage();
                    Commands::lang($lang);
                    Start::showSetContract($bot, $user, $chatID);
                    break;
                case Commands::getMessageText('ru'):
                    $user->setLanguage('ru');
                    $lang = $user->getLanguage();
                    Commands::lang($lang);
                    Start::showSetContract($bot, $user,  $chatID);
                    break;
                default:

                    break;
            }
            break;

        case 1: // Страница добавление номера телефона
//            $phone = null;
//            if (!empty($text)) {
//                preg_match('/^[0-9]{2}-? ?[0-9]{3}-? ?[0-9]{2}-? ?[0-9]{2}$/', $text, $match);
//                $phone = $match[0];
//            }
//            if ($phone = $bot->getContactPhoneNumber() || $phone) {
//                $user->setPhoneNumber($phone);
//            }
            $phone = $user->getPhoneNumber();
            if (!$phone) {
                $phone = $bot->getContactPhoneNumber();
                if ($phone) {
                    $user->setPhoneNumber($phone);
                } else {
                    $bot->sendMessage([
                        'chat_id'   => $chatID,
                        'text'      => $phone . ' ' . Commands::getMessageText('error_phone')
                    ]);
                }
            } else if (isset($text)) {
                preg_match('/^[0-9]{2}-? ?[0-9]{3}-? ?[0-9]{2}-? ?[0-9]{2}$/', $text, $match);
                $user->setPhoneNumber($match[0]);
            }

            Start::general($bot, $user, $chatID, 2, null);
            break;

        case 2: // Страница выбора - поиска / Связаться с нами / Добавить объект
            switch ($text) {
                case Commands::getMessageText('search'): // страница поиска объектов page 3
                    Start::main($bot, $user, $chatID, $MessageID, 3, null);
                    break;
                case Commands::getMessageText('feedback'): // Страница 📝 Связаться с нами
                    Contacts::feedback($user, $bot, $chatID, 7);
                    break;
                case Commands::getMessageText('support'): // Страница 📝 Связаться с нами
                    Contacts::getSectionText($bot, $chatID, 145);
                    break;
                case Commands::getMessageText('leave_review'): // Страница ✍️ Оставить отзыв
                    Contacts::leaveReview($user, $bot, $chatID, 8);
                    break;
                case Commands::getMessageText('rules'): // Страница правила
                    Contacts::getSectionText($bot, $chatID, 150);
                    break;
                case Commands::getMessageText('add_object'): // Страница 📋 Добавить объект
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'startPage', null,  10);
                    break;

                case Commands::getMessageText('setting_btn'):
                    Contacts::settings($bot, $user, $chatID, 30);
                    break;
                default:
//                Start::general($user, $bot, $chatID,2);
                    $bot->sendMessage([
                        'chat_id'       => $chatID,
                        'text'          => "Бессмысленные действия )))",
                        'parse_mode'    => "HTML"
                    ]);
                    break;
            }
            break;

        case 3: // Страница выбора локации
            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    Start::general($bot, $user, $chatID, 2, null);
                    break;
                case Commands::getMessageText('search_category'):
                    $user->setDistrict('');
                    $user->setLatitude('');
                    $user->setLongitude('');
                    CategoryController::init()->execute($bot, $chatID);
                    break;
                case Commands::getMessageText('search_district'):
                    $user->setLatitude('');
                    $user->setLongitude('');
                    Contacts::districts($bot, $chatID, $MessageID);
                    break;
                case Commands::getMessageText('search_name'):
                    Start::searchYandex($bot, $user, $chatID);
                    break;
                default:
                    if (!empty($text)) {
                        if (isContains($text, '/card_')) {
                            $articleId = preg_replace('/[^0-9]/', '', $text);
                            Articles::init()->object($articleId, $bot, $chatID, $MessageID);
                        }
                    } else if (isset($data['message']['location']['latitude']) && isset($data['message']['location']['longitude'])) {
                        Contacts::setLocation($user, $data);
                        CategoryController::init()->execute($bot, $chatID);
                    }
                    break;
            }
            break;

        case 4: // Страница поиск через yandex
            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    Start::main($bot, $user, $chatID, $MessageID, 3, '🏠');
                    break;
                default:
                    $articleYandex = Articles::init();
                    $articleYandex->searchYandex($bot, $user, $text, $chatID);
                    break;
            }
            break;

        /** Страницы (Связаться / Оставить отзыв / Добавить объект / Страница районов ) */
        case 7: // Страница 📝 Связаться с нами // не подключена
            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    Start::general($bot, $user, $chatID, 2, null);
                    break;
                default:
                    $bot->sendMessage([
                        'chat_id'       => $chatID,
                        'text'          => Commands::getMessageText('select_other_menu_items'),
                        'parse_mode'    => "HTML"
                    ]);
                    break;
            }
            break;
        case 8: // Страница ✍️ Оставить отзыв
            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    Start::general($bot, $user, $chatID, 2, null);
                    break;
                default:
                    if (!empty($text)) {
                        if ($user->addReview($text)) {
                            Start::general($bot, $user, $chatID, 2, "Спасибо за отзыв");
                        } else {
                            $bot->sendMessage([
                                'chat_id'       => $chatID,
                                'text'          => Commands::getMessageText('error_review'),
                                'parse_mode'    => "HTML"
                            ]);
                        }
                    }
                    break;
            }
            break;


        /** страница добавление объекта */
        case 10: // Страница 📋 Добавить объект
            $object = new AddingObject($chatID);

            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    Start::general($bot, $user, $chatID, 2, null);
                    break;
                case Commands::getMessageText('cancel_btn'):
                    $object->deleteObject($chatID, $object->object_id);
                    Start::general($bot, $user, $chatID, 2, null);

                    break;
                default:
                    if (!empty($text)) {
                        if ($object->addObject($chatID, $text)) {
                            ObjectPage::init()->executePage($bot, $user, $chatID,  'categoryPage', null,  11);
                        } else {
                            $bot->sendMessage([
                                'chat_id'       => $chatID,
                                'text'          => Commands::getMessageText('error_add_object'),
                                'parse_mode'    => "HTML"
                            ]);
                        }
                    }
                    break;
            }
            break;
        case 11: // Страница добавление категории
            $object = new AddingObject($chatID);

            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'startPage', null,  10);
                    break;
                case Commands::getMessageText('cancel_btn'):
                    $object->deleteObject($chatID, $object->object_id);
                    Start::general($bot, $user, $chatID, 2, null);

                    break;
                default:
                    if (!empty($text)) {
                        if (($categoryId = array_search($text, Categories::getCategoriesList())) !== false) {
                            if ($object->updateObject($chatID, $object->object_id, array('step_id' => 1, 'category_id' => $categoryId))) {
                                ObjectPage::init()->executePage($bot, $user, $chatID,  'subCategoryPage', $categoryId,  12);
                            }
                        } else {
                            $bot->sendMessage([
                                'chat_id'       => $chatID,
                                'text'          => Commands::getMessageText('select_category_list'),
                                'parse_mode'    => "HTML"
                            ]);
//                            sendMessage('Выберите категорию из списка');
                        }
                    }
                    break;
            }
            break;
        case 12: // Страница добавление под категории
            $object = new AddingObject($chatID);

            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'categoryPage', null,  11);
                    break;
                case Commands::getMessageText('cancel_btn'):
                    $object->deleteObject($chatID, $object->object_id);
                    Start::general($bot, $user, $chatID, 2, null);

                    break;
                default:
                    if (!empty($text)) {
                        $category_id = $object->getCategoryObject($chatID, $object->object_id);
                        if (($categoryId = array_search($text, Categories::getCategoriesList($category_id))) !== false) {
                            if ($object->updateObject($chatID, $object->object_id, array('step_id' => 2, 'category_id' => $categoryId))) {
                                ObjectPage::init()->executePage($bot, $user, $chatID,  'contentPage', null,  13);
                            }
                        } else {
                            $bot->sendMessage([
                                'chat_id'       => $chatID,
                                'text'          => Commands::getMessageText('select_category_list'),
                                'parse_mode'    => "HTML"
                            ]);
//                            sendMessage('Выберите категорию из списка');
                        }
                    }
                    break;
            }
            break;
        case 13:// Step 2 - добавление описания к объекту
            $object = new AddingObject($chatID);

            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    $sectionId = $object->getCategoryObject($chatID, $object->object_id);
                    // получить parentId по sectionId
                    $parentId = Categories::getParentId($sectionId);
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'subCategoryPage', $parentId,  12);
                    break;
                case Commands::getMessageText('cancel_btn'):
                    $object->deleteObject($chatID, $object->object_id);
                    Start::general($bot, $user, $chatID, 2, null);
                    break;
                case Commands::getMessageText('skip_btn'):
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'regionPage', null,  14);
                    break;
                default:
                    if (!empty($text)) {
                        if ($object->updateObject($chatID, $object->object_id, array('step_id' => 3, 'content' => $text))) {
                            ObjectPage::init()->executePage($bot, $user, $chatID,  'regionPage', null,  14);
                        }
                    }
                    break;
            }
            break;
        case 14: // Страница добавление города или области
            $object = new AddingObject($chatID);

            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'contentPage', null,  13);
                    break;
                case Commands::getMessageText('cancel_btn'):
                    $object->deleteObject($chatID, $object->object_id);
                    Start::general($bot, $user, $chatID, 2, null);

                    break;
                default:
                    if (!empty($text)) {
                        if (($regionId = array_search($text, Categories::getRegionList())) !== false) {
                            if ($object->updateObject($chatID, $object->object_id, array('step_id' => 4, 'region_id' => $regionId))) {
                                ObjectPage::init()->executePage($bot, $user, $chatID,  'areaPage', $regionId,  15);
                            }
                        } else {
                            $bot->sendMessage([
                                'chat_id'       => $chatID,
                                'text'          => Commands::getMessageText('select_city_list'),
                                'parse_mode'    => "HTML"
                            ]);
                        }
                    }
                    break;
            }
            break;
        case 15: // Страница добавление района или города у областей
            $object = new AddingObject($chatID);

            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'regionPage', null,  14);
                    break;
                case Commands::getMessageText('cancel_btn'):
                    $object->deleteObject($chatID, $object->object_id);
                    Start::general($bot, $user, $chatID, 2, null);
                    break;
                default:
                    if (!empty($text)) {
                        $regionId = $object->getRegionObject($chatID, $object->object_id);
                        if (($areaId = array_search($text, Categories::getAreaList($regionId))) !== false) {
                            if ($object->updateObject($chatID, $object->object_id, array('step_id' => 5, 'area_id' => $areaId))) {
                                ObjectPage::init()->executePage($bot, $user, $chatID,  'streetPage', null,  16);
                            }
                        } else {
                            $bot->sendMessage([
                                'chat_id'       => $chatID,
                                'text'          => Commands::getMessageText('select_district_list'),
                                'parse_mode'    => "HTML"
                            ]);
//                            sendMessage('Выберите город из списка');
                        }
                    }
                    break;
            }
            break;
        case 16: // Страница добавление адреса
            $object = new AddingObject($chatID);
            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    $regionId = $object->getRegionObject($chatID, $object->object_id);
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'areaPage', $regionId,  15);
                    break;
                case Commands::getMessageText('cancel_btn'):
                    $object->deleteObject($chatID, $object->object_id);
                    Start::general($bot, $user, $chatID, 2, null);

                    break;
                default:
                    if (!empty($text)) {
                        if ($object->updateObject($chatID, $object->object_id, array('step_id' => 6, 'address' => $text))) {
                            ObjectPage::init()->executePage($bot, $user, $chatID,  'coordinatesPage', null,  17);
                        }
                    }
                    break;
            }
            break;
        case 17: // Страница добавление координат
            $object = new AddingObject($chatID);

            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'streetPage', null,  16);
                    break;
                case Commands::getMessageText('cancel_btn'):
                    $object->deleteObject($chatID, $object->object_id);
                    Start::general($bot, $user, $chatID, 2, null);

                    break;
                default:
                    if (!empty($text)) {
                        if ($object->updateObject($chatID, $object->object_id, array('step_id' => 9, 'coordinates' => $text))) {
                            ObjectPage::init()->executePage($bot, $user, $chatID,  'phonePage', null,  18);
                        }
                    }
                    else if (isset($data['message']['location']['latitude']) && isset($data['message']['location']['longitude'])) {
                        $latitude = number_format((float)$data['message']['location']['latitude'], 10, '.', '');
                        $longitude = number_format((float)$data['message']['location']['longitude'], 10, '.', '');
                        if ($object->updateObject($chatID, $object->object_id, array('coordinates' => "$latitude, $longitude"))) {
                            ObjectPage::init()->executePage($bot, $user, $chatID,  'phonePage', null,  18);
                        }
                    }
                    break;
            }
            break;
        case 18: // Страница добавление номера телефона
            $object = new AddingObject($chatID);

            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'coordinatesPage', null,  17);
                    break;
                case Commands::getMessageText('cancel_btn'):
                    $object->deleteObject($chatID, $object->object_id);
                    Start::general($bot, $user, $chatID, 2, null);

                    break;
                default:
                    if (!empty($text)) {
                        if ($object->updateObject($chatID, $object->object_id, array('phone' => $text))) {
                            ObjectPage::init()->executePage($bot, $user, $chatID,  'openingHoursStartPage', null,  19);
                        }
                    } else if (isset($data['message']['contact']['phone_number'])) {
                        $phone = $bot->getContactPhoneNumber();
                        if ($phone) {
                            if ($object->updateObject($chatID, $object->object_id, array('phone' => $phone))) {
                                ObjectPage::init()->executePage($bot, $user, $chatID,  'openingHoursStartPage', null,  19);
                            }
                        } else {
                            $bot->sendMessage([
                                'chat_id'   => $chatID,
                                'text'      => $phone . ' ' . Commands::getMessageText('error_phone')
                            ]);
                        }

                    }
                    break;
            }
            break;
        case 19: // Step 3 - добавление start working hours
            $object = new AddingObject($chatID);

            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'phonePage', null,  18);
                    break;
                case Commands::getMessageText('cancel_btn'):
                    $object->deleteObject($chatID, $object->object_id);
                    Start::general($bot, $user, $chatID, 2, null);

                    break;
                default:
                    if (!empty($text)) {
                        if ($text == "24/7") {
                            if ($object->updateObject($chatID, $object->object_id, array('workingHours' => $text, 'workingDays' => 'Круглосуточно'))) {
                                ObjectPage::init()->executePage($bot, $user, $chatID,  'addPhotoPage', null,  22);
                            }
                        } else {
                            if ($object->updateObject($chatID, $object->object_id, array('workingHours' => $text))) {
                                ObjectPage::init()->executePage($bot, $user, $chatID,  'openingHoursEndPage', null,  20);
                            }
                        }
                    }
                    break;
            }
            break;
        case 20: // Step 3 - добавление end working hours
            $object = new AddingObject($chatID);

            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'openingHoursStartPage', null,  19);
                    break;
                case Commands::getMessageText('cancel_btn'):
                    $object->deleteObject($chatID, $object->object_id);
                    Start::general($bot, $user, $chatID, 2, null);

                    break;
                default:
                    if (!empty($text)) {
                        $working = $object->getParamValueObject($chatID, $object->object_id, 'workingHours');
                        $working = $working . ' - ' . $text;
                        if ($object->updateObject($chatID, $object->object_id, array('workingHours' => $working))) {
                            ObjectPage::init()->executePage($bot, $user, $chatID,  'workingDaysWeekPage', null,  21);
                        }
                    }
                    break;
            }
            break;
        case 21: // Step 3 - добавление дни недели
            $object = new AddingObject($chatID);

            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'openingHoursEndPage', null,  20);
                    break;
                case Commands::getMessageText('cancel_btn'):
                    $object->deleteObject($chatID, $object->object_id);
                    Start::general($bot, $user, $chatID, 2, null);

                    break;
                case Commands::getMessageText('confirm_btn'):
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'addPhotoPage', null,  22);
                    break;
                default:

                    $text = str_replace('✔ ', '', $text);
                    $weekdayList = Categories::getWeekdayList();

                    if ((array_search($text, $weekdayList) !== false)) {
                        $dayId = array_search($text, $weekdayList);

                        $workingDays = $object->getParamValueObject($chatID, $object->object_id, 'workingDays');
                        $workingDays = json_decode($workingDays, true);
                        if (isset($workingDays[$dayId])) {
                            unset($workingDays[$dayId]);
                        } else {
                            $workingDays[$dayId] = $text;
                        }
                        if (!empty($workingDays)) ksort($workingDays);

                        if ($object->updateObject($chatID, $object->object_id, array('workingDays' => json_encode($workingDays, JSON_UNESCAPED_UNICODE)))) {

                            foreach ($weekdayList as $key => $workingDay) {
                                $dayId = null;
                                if (!empty($workingDays)) {
                                    $dayId = (array_search($workingDay, $workingDays) !== false) ? array_search($workingDay, $workingDays) : null;
                                }
                                $extra = ($dayId === $key) ? '✔ ' : '';
                                $option[]   = [$bot->buildKeyboardButton($extra . $workingDay)];
                            }
                            $option[] = [$bot->buildKeyboardButton(Commands::getMessageText('confirm_btn'))];
                            $option[] = [$bot->buildKeyboardButton(Commands::getMessageText('cancel_btn')), $bot->buildKeyboardButton(Commands::getMessageText('back_btn'))];
                            $keyboard = $bot->buildKeyBoard($option,  false,  true);
                            $bot->sendMessage([
                                'chat_id'       => $chatID,
                                'reply_markup'  => $keyboard,
                                'text'          => $text
                            ]);
                        }
                    } else {
                        $bot->sendMessage([
                            'chat_id'       => $chatID,
                            'text'          => 'Выберите день недели из списка',
                            'parse_mode'    => "HTML"
                        ]);
                    }
                    break;
            }
            break;
        case 22: // Страница добавление фото к объекту
            $object = new AddingObject($chatID);

            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'workingDaysWeekPage', null,  21);
                    break;
                case Commands::getMessageText('cancel_btn'):
                    $object->deleteObject($chatID, $object->object_id);
                    Start::general($bot, $user, $chatID, 2, null);

                    break;
                case Commands::getMessageText('confirm_btn'):
                    $image = $object->getObjectImages($chatID, $object->object_id);
                    if ($object->updateObject($chatID, $object->object_id, array('step_id' => 8, 'images' => UPLOAD_URL . '/telegram/' .$image))) {
                        ObjectPage::init()->executePage($bot, $user, $chatID,  'confirmObject', null,  23);
                    }
                    break;
                default:
                    if (!empty($data['message'])) {
                        if (!$data['message']['photo']) {
                            $bot->sendMessage([
                                'chat_id'       => $chatID,
                                'text'          => Commands::getMessageText('send_photo_object'),
                                'parse_mode'    => "HTML"
                            ]);
                        } else {

                            $basePath = UPLOAD_ROOT . 'telegram/';
                            $photo = end($data['message']['photo']);
                            $result = $bot->getFile($photo['file_id']);
                            $filePath = $result['result']['file_path'];

                            $extension = pathinfo($filePath, PATHINFO_EXTENSION);
                            $filePathRenamed = $basePath . generateRandomString() . '.' . $extension;
//                            rename($filePath, $filePathRenamed);

                            $bot->downloadFile($filePath, $filePathRenamed);
                            $filePathRenamed = str_replace($basePath, '', $filePathRenamed);

                            if (!$object->isObjectImage($chatID, $object->object_id)) {
                                $object->addObjectImage($chatID, $object->object_id, $filePathRenamed);
                                $text = Commands::getMessageText('photo_successfully_uploaded_object');
                            } else {
                                $object->addObjectImage($chatID, $object->object_id, $filePathRenamed);
                                $text = Commands::getMessageText('photo_successfully_updated_object');
                            }

                            $option = [
                                [$bot->buildKeyboardButton(Commands::getMessageText('confirm_btn'))],
                                [$bot->buildKeyboardButton(Commands::getMessageText('cancel_btn'))],
                            ];
                            $keyboard = $bot->buildKeyBoard($option,  false,  true);

                            $bot->sendMessage([
                                'chat_id'       => $chatID,
                                'reply_markup'  => $keyboard,
                                'text'          => $text,
                                'parse_mode'    => "HTML"
                            ]);

                        }
                    }

                    break;
            }
            break;
        case 23: // страница Предварительный просмотр объекта
            $object = new AddingObject($chatID);

            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'addPhotoPage', null,  22);
                    break;
                case Commands::getMessageText('cancel_btn'):
                    $object->deleteObject($chatID, $object->object_id);
                    Start::general($bot, $user, $chatID, 2, null);
                    break;
                case Commands::getMessageText('confirm_save_btn'):
                    if ($object->updateObject($chatID, $object->object_id, array('step_id' => 0, 'isAdded' => 2))) {

                        Start::general($bot, $user, $chatID, 2, Commands::getMessageText('object_added_successfully'));

//                        ObjectPage::init()->executePage($bot, $user, $chatID,  'successObject', null,  2);
                    }
                    break;
                case Commands::getMessageText('preview_object'):
                    ObjectPage::init()->executePage($bot, $user, $chatID,  'confirmObject', null,  23);
                    break;
                case Commands::getMessageText('view_location_object'):
                    if ($coordinates = $object->getLocationObject($chatID, $object->object_id)) {
                        $bot->sendLocation([
                            'chat_id'   => $chatID,
                            'latitude'  => $coordinates[0],
                            'longitude' => $coordinates[1]
                        ]);
                    }
                    break;
                default: break;
            }
            break;

        /** END */



        /** Настройки */
        case 30: // Страница настройки / настройки успешное изменение
            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    Start::general($bot,$user, $chatID, 2, null);
                    break;
                case Commands::getMessageText('change_lang'):
                    Contacts::changeLanguage($bot, $user, $chatID, 31);
                    break;
                case Commands::getMessageText('change_phone'):
                    Contacts::ChangeContract($bot, $user, $chatID, 32);
                    break;
                default:
                    $bot->sendMessage([
                        'chat_id'       => $chatID,
                        'text'          => Commands::getMessageText('notification'),
                        'parse_mode'    => "HTML"
                    ]);
                    break;
            }
            break;
        case 31: // Страница изменение языка
            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    Contacts::settings($bot, $user, $chatID, 30);
                    break;
                case Commands::getMessageText('uz'):
                    $user->setLanguage('uz');
                    Commands::lang($user->getLanguage());
                    Contacts::settingChangeLanguage($bot, $user, $chatID, 30);
                    break;
                case Commands::getMessageText('ru'):
                    $user->setLanguage('ru');
                    Commands::lang($user->getLanguage());
                    Contacts::settingChangeLanguage($bot, $user, $chatID, 30);
                    break;
                default:
                    $bot->sendMessage([
                        'chat_id'       => $chatID,
                        'text'          => Commands::getMessageText('notification'),
                        'parse_mode'    => "HTML"
                    ]);
                    break;
            }
            break;
        case 32: // Страница изменение номера телефона
            switch ($text) {
                case Commands::getMessageText('back_btn'):
                    Contacts::settings($bot, $user, $chatID, 30);
                    break;
                default:

                    $phone = $bot->getContactPhoneNumber();
                    if ($phone) {
                        $user->setPhoneNumber($phone);
                    } else {
                        $user->setPhoneNumber($text);
                    }
                    Contacts::settingChangeLanguage($bot, $user, $chatID,30);
                    break;
            }
            break;


        default:
            $bot->sendMessage([
                'chat_id'       => $chatID,
                'text'          => Commands::getMessageText('notification'),
                'parse_mode'    => "HTML"
            ]);
            break;

    }

} catch (Exception $e) {
    $bot->sendMessage([
        'chat_id'       => $chatID,
        'text'          => json_encode($e->getMessage(),JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT),
        'parse_mode'    => "HTML"
    ]);
}




function sendMessage($text)
{
    global $bot, $chatID;
    $bot->sendMessage(['chat_id' => $chatID, 'text' => $text]);
}

function isContains($string, $needle): bool
{
    return strpos($string, $needle) !== false;
}

function generateRandomString($length = 10)
{
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}
