<?php
	include '../includes/overall.inc.php';

use Mnv\Core\Config;
use Mnv\Core\DB;
use Mnv\Core\Feedback;
use Mnv\Core\Locale\I18N;

global $smarty;
	
	$feedbackClass = new Feedback(Config::getValue('mail_transport'));

    $error    = '';
    $response  = null;

    $rewrite   = getRequestVar('rewrite');
    $subcribe   = getRequestVar('subcribe', '', true);

    $subcribe['subject']   = 'Подписка на рассылку';

    if ($rewrite != Config::getValue('rewrite')) {
        header("HTTP/1.0 301 Moved Permanently");
        header("Location: " . SITE_URL);

        /* saving visit */
        writeErrorVisit(301);
        exit;
    }

    /* checking whether message is empty */
    $subcribe['phone'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($subcribe['phone']));
    if (empty($subcribe['phone'])) $feedbackClass->errors = 'phone';

    $arrayMessage = array_filter([
        'Дата отправки сообщения' => adjustTime(gmdate('d-m-Y H:i'), false, 'd-m-Y H:i'),
        'Контакт'       => $subcribe['phone']
    ]);

    $htmlBody = '';
    foreach($arrayMessage as $key => $value) {
        $htmlBody .= "<b>".$key.":</b> ".$value."<br/>";
    }

    if (empty($feedbackClass->errors)) {
        /* отправка по smtp */
        if (empty($feedbackClass->errors) && $feedbackClass->send(Config::getValue('email'), Config::getValue('company_name'), null, null, $subcribe['subject'], $htmlBody, null)) {

            $existingSignup = DB::init()->connect()->table('subscribe')->count('*')->where('email', '=', $subcribe['phone'])->getValue();
            $data_exists = $existingSignup > 0;

            if (!$data_exists) {
                $q = DB::init()->connect()->table('subscribe')->insert(['email' => $subcribe['phone'], 'addedOn'=> date('Y-m-d H:i:s')]);
                if ($q) {
                    $response = array('status' => 200, 'color' => 'green',
                        'message' => I18N::locale("Вы успешно подписаны", "Siz muvaffaqiyatli imzolangan","You have been successfully subscribed"));
                } else {
                    $response = array('status' => 400, 'color' => 'red',
                        'message' => I18N::locale("Произошла ошибка. Пожалуйста, попробуйте еще раз", "Xatolik yuz berdi. Iltimos, yana urinib ko'ring","An error has occurred. Please try again"));
                }
            } else {
                $response = array('status' => 400, 'color' => 'red',
                    'message' => I18N::locale("Этот номер телефона уже подписан", "Ushbu telefon raqami allaqachon imzolangan","This phone number has already been signed"));
            }
        } else {
                $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
        }
    }



    return response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
  

