<?php
	include '../includes/visitor.inc.php';

use Mnv\Core\DB;
use Mnv\Core\Config;
use Mnv\Core\Feedback;
use Mnv\Core\Locale\I18N;

global $smarty, $visitorId, $visitorIp;
	
	$feedbackClass = new Feedback(Config::getValue('mail_transport'));

    $success = null;
    $errors    = null;
    $response  = null;

    $rewrite   = getRequestVar('rewrite');
    $sectionId = (int) getRequestVar('sectionId');
    $comment   = getRequestVar('review', '', true);

    $subcribe['subject']   = 'Оставлен отзыв';

    if ($rewrite != Config::getValue('rewrite')) {
        header("HTTP/1.0 301 Moved Permanently");
        header("Location: " . SITE_URL);

        /* saving visit */
        writeErrorVisit(301);
        exit;
    }

    if ($article = DB::init()->connect()->table('articles')->select('articleId, commentsEnabled')->where('articleId', $comment['articleId'])->get()) {

        /* commenting procedures */
        if($article->commentsEnabled == 1){
            $article->commentsEnabled = 1;
        } elseif($article->commentsEnabled == -1){
            $article->commentsEnabled = 0;
        } elseif($article->commentsEnabled == 0){
            $article->commentsEnabled = 0;
            if($SECTIONS[$sectionId]->commentsEnabled == 1){
                $article->commentsEnabled = 1;
            } elseif($SECTIONS[$sectionId]->commentsEnabled != -1 && Config::getValue('comments_enabled') == 1){
                $article->commentsEnabled = 1;
            }
        }

        $visitId = writeVisit(3);
        $visitorId = DB::init()->connect()->table('stats_visits')->select('visitorId')->where('visitId',  $visitId)->getValue();
        $comment['visitorId'] = $visitorId;
        if (!empty($comment) && $article->commentsEnabled) {

            if (empty($comment['authorName'])) $errors['authorName'] = true;

            /** removing HTML tags from comment */
            $comment['content'] = Config::getValue('comments_strip_html') ? stripHtml($comment['content']) : $comment['content'];

            /** trim */
            $comment['content'] = trim($comment['content']);
            $comment['authorName'] = trim($comment['authorName']);

            if (empty($comment['content'])) $errors['content'] = true;

            if (DB::init()->connect()->table('comments')->where('authorName', '=', $comment['authorName'])->where('content', '=', $comment['content'])->get()) {

                $response = array('status' => 200, 'color' => 'green', 'success' => $success, 'errors' => $errors,
                    'message' => I18N::locale("Ваше сообщение успешно отправлено", "Sizning xabaringiz muvaffaqiyatli yuborildi", "Your message has been sent successfully")
                );

                $errors['duplicate_comment'] = true;
//        $success['duplicate_comment'] = true;
                $response = array('status' => 200, 'color' => 'green',
                    'message' => I18N::locale(
                        "Дублирование отзыва: Вы уже это говорили!",
                        "Sizning xabaringiz muvaffaqiyatli yuborildi",
                        "Your message has been sent successfully")
                );
            }

            if (empty($errors)) {
//			$comment['commentId']   = '';
                $comment['articleId'] = $comment['articleId'];
                $comment['visitorId'] = $visitorId;
                $comment['authorIp'] = $visitorIp;
                $comment['answerId'] = (isset($comment['answerId']) && !empty($comment['answerId'])) ? $comment['answerId'] : 0;
                $comment['addedOn'] = gmdate('Y-m-d H:i:s');
                $comment['modifiedBy'] = 0;
                $comment['rating']      = !empty($comment['rating']) ? $comment['rating'] : '0.0';
                $comment['modifiedOn'] = gmdate('Y-m-d H:i:s');
                $comment['status'] = 'approved';

//            	print_r($comment);
                /* apply SPAM filters to the comment */
                if (!empty(Config::getValue('comments_spam_words'))) {
                    $spamWords = preg_split('/[\r\n]+/', Config::getValue('comments_spam_words'));
                    $spamWords = array_map('preg_quote', $spamWords);
                    $regex = '/' . implode('|', $spamWords) . '/i';
                    if (preg_match($regex, $comment['content']) || preg_match($regex, $comment['authorIp']) || preg_match($regex, $comment['authorName'])) {
                        $comment['status'] = 'spam';
                    }
                }

                /* apply HOLD filters to the comment */
                if (($comment['status'] != 'spam') && !Config::getValue('comments_must_be_approved') && !empty(Config::getValue('comments_hold_words'))) {
                    $holdWords = preg_split('/[\r\n]+/', Config::getValue('comments_hold_words'));
                    $holdWords = array_map('preg_quote', $holdWords);
                    $regex = '/' . implode('|', $holdWords) . '/i';
                    if (preg_match($regex, $comment['content']) || preg_match($regex, $comment['authorIp']) || preg_match($regex, $comment['authorName'])) {
                        $comment['status'] = 'pending';
                    }
                }

                /* check if all comments must be approved manually */
                if ($comment['status'] != 'spam' && Config::getValue('comments_must_be_approved')) $comment['status'] = 'pending';

                /** mark comment as SPAM if commenter had a SPAM comment previously */
                if ($comment['status'] != 'spam' && Config::getValue('comments_blacklist_enabled')) {
                    DB::init()->connect()->where('authorEmail', '=', $comment['authorEmail']);
                    DB::init()->connect()->where('authorName', '=', $comment['authorName']);
                    if (DB::init()->connect()->table('comments')->select('status')->orderBy('addedOn DESC')->getValue() == 'spam') $comment['status'] = 'spam';
                }

                /** avoid moderation if commenter has a previously approved comment */
                if ($comment['status'] != 'spam' && Config::getValue('comments_whitelist_enabled')) {
                    DB::init()->connect()->where('authorName', '=', $comment['authorName']);
                    if (DB::init()->connect()->table('comments')->select('status')->orderBy('addedOn DESC')->getValue() == 'approved') $comment['status'] = 'approved';
                }

                /* email confirmation */
                if (Config::getValue('comments_email_confirmation_required') == 1) {
                    DB::init()->connect()->where('authorName', '=', $comment['authorName']);
                    DB::init()->connect()->in('status', ['pending', 'approved']);
                    if (!DB::init()->connect()->table('comments')->select('commentId')->limit(1)->getValue()) $comment['status'] = 'unconfirmed';

                } elseif (Config::getValue('comments_email_confirmation_required') == 2) {
                    $comment['status'] = 'unconfirmed';
                }


                $comment['commentId'] = DB::init()->connect()->table('comments')->insert($comment);

                if ($comment['status'] == 'approved') {
//            $success['duplicate_comment'] = true;
                    $response = array('status' => 200, 'color' => 'green',
                        'message' => I18N::locale(
                            "Дублирование отзыва: Вы уже это говорили!",
                            "Sizning xabaringiz muvaffaqiyatli yuborildi",
                            "Your message has been sent successfully")
                    );

                } elseif ($comment['status'] == 'unconfirmed') {
                    $smarty->assign('commentId', $comment['commentId']);
                    $smarty->assign('commentCode', substr(md5($comment['authorName'] . $comment['addedOn'] . AP_SERIAL . SITE_ROOT . 'AbBra-cAda8Ra'), 0, 12));

                    $response = array('status' => 200, 'color' => 'green',
                        'message' => I18N::locale(
                            "На Ваш email выслано письмо с инструкцией для подтверждения Вашего email",
                            "Sizning xabaringiz muvaffaqiyatli yuborildi",
                            "Your message has been sent successfully")
                    );
                } else {
                    $response = array('status' => 200, 'color' => 'green',
                        'message' => I18N::locale(
                            "Ваш комментарий был успешно сохранен. Он будет опубликован после проверки модератором.",
                            "Sizning xabaringiz muvaffaqiyatli yuborildi",
                            "Your message has been sent successfully")
                    );
                }

                /** delete unconfirmed comments */
                DB::init()->connect()->table('comments')->where('status', '=', 'unconfirmed')->where('addedOn', '<', gmdate('Y-m-d H:i:s', time() - 86400 * 3))->delete();
                /** delete spam comments */
                DB::init()->connect()->table('comments')->where('status', '=', 'spam')->where('addedOn', '<', gmdate('Y-m-d H:i:s', time() - 86400 * 3))->delete();

            }

        } else {
            $response = array('status' => 200, 'color' => 'green', 'success' => '', 'errors' => '',
                'message' => I18N::locale("Все поля обязательны для заполнения  ", "Sizning xabaringiz muvaffaqiyatli yuborildi", "Your message has been sent successfully")
            );
        }
    }

    return response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();


//function uploadsImage($files, $articleId)
//{
//    global DB::init()->connect();
//
//    $fileManager = new FileManager();
//
//    if (isset($_FILES) && !empty($_FILES)) {
//        $folder_root = GLOBAL_ROOT . '/uploads/comment/';
////            $folder_url  = SITE_URL .'/uploads/';
//
//        $realPath = realpath($folder_root . $articleId) . DIRECTORY_SEPARATOR;
//        if (strpos($realPath, $folder_root) === false) {
//            $realPath = $folder_root . $articleId;
//            $path = str_replace($folder_root . $articleId, $place['articleId'], $realPath);
//        }
//        $path = str_replace($folder_root, '/', $realPath);
//        if (!file_exists($realPath)) mkdir($realPath, 0755, true);
//
//        $newFiles = assembleFile($_FILES);
//        if ($res = $fileManager->upload_place_files("/objects/$place[articleId]/", $newFiles, $userId)) {
//            if (count($res) > 1) {
//                foreach ($res as $id) {
//                    DB::init()->connect()->table('article_images')->replace(['articleId' => $place['articleId'], 'fileId' => $id, 'type' => 'gallery', 'orderBy' => 0]);
//                }
//            } else {
//                DB::init()->connect()->table('article_images')->replace(['articleId' => $place['articleId'], 'fileId' => $id, 'type' => 'general', 'orderBy' => 0]);
//            }
//            $response = array('code' => true, 'message' => "Успешная загрузка", 'fileId' => $res);
//        } else {
//            $response = array('code' => false, 'error' => "Ошибка загрузки");
//        }
//    }
//}

/**
 * @param $file
 * @return array
 */
function assembleFile($file)
{
    if (!empty($file["images"])) {
        $newFiles = array();
        $file_names = $file['images']['name'];
        for ($i = 0; $i < count($file_names); $i++) {
            $newFiles[$i]['name']       = $file['images']['name'][$i];
            $newFiles[$i]['type']       = $file['images']['type'][$i];
            $newFiles[$i]['tmp_name']   = $file['images']['tmp_name'][$i];
            $newFiles[$i]['error']      = $file['images']['error'][$i];
            $newFiles[$i]['size']       = $file['images']['size'][$i];
        }
        return $newFiles;
    }
    return null;
}