<?php
require_once "../includes/visitor.inc.php";


use Mnv\Core\Config;
use Mnv\Core\Feedback;
use Mnv\Core\Locale\I18N;
use Mnv\Core\Utilities\Cookie\Session;

use Mnv\Modules\Shop\Order;
use Mnv\Modules\Shop\Basket;

use Mnv\Modules\Payment\PaymentFactory;

global $smarty;
$result = null;


$feedbackClass = new Feedback(Config::getValue('mail_transport'));
$feedbackClass->getCaptchaEnabled(Config::getValue('feedback_captcha_enabled'));
$feedbackClass->getAllowCaptcha(Config::getValue('allow_recaptcha'));
$feedbackClass->telegram(Config::getValue('telegram_send'));

$htmlBody = '';
$error    = '';
$clientEmail = '';

$rewrite        = getRequestVar('rewrite');
$order          = getRequestVar('order', '', true);
$action         = getRequestVar('action');


if ($rewrite != Config::getValue('rewrite')) {
    header("HTTP/1.0 301 Moved Permanently");
    header("Location: " . SITE_URL);

    /* saving visit */
    writeErrorVisit(301);
    exit;
}

$orderClass = new Order();

/* checking whether message is empty */

    $order['fullName'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($order['fullName']));
    $order['contact'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($order['contact']));
    $order['city'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($order['city']));
    $order['street'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($order['street']));
    $order['houseNumber'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($order['houseNumber']));

    if (empty($order['fullName']))      $orderClass->errors[] = 'fullName';
    if (empty($order['contact']))       {
        $orderClass->errors[] = 'contact';
    } else {
        if ($order['contact'] = $feedbackClass->validationEmail($order['contact'])) $clientEmail = $order['contact'];
    }
    if (empty($order['city']))          $orderClass->errors[] = 'city';
    if (empty($order['street']))        $orderClass->errors[] = 'street';
    if (empty($order['houseNumber']))   $orderClass->errors[] = 'houseNumber';



 if ($action === 'order' && empty($orderClass->errors)) {

    if (!empty($order['payment_method'])) {
        $cart = new Basket();
        $cart->getBasket();
        if (!empty($cart->basket)) {
            if ($orderClass->insertOrder($order, $cart->basket)) {
                $orderClass->response['note'][] = "Оплата за продукцию интернет магазина " . Config::getValue('website_name');

//                $payment = PaymentFactory::paymentMethod($order['payment_method'], $orderClass->orderId, $cart->basket->amount, null, $order['fullName'], null, null, $orderClass->response['note'], 'ru', true);
//                $orderClass->response = array('status' => 200, 'color' => 'green', 'form' => $payment,
//                    'message' => I18N::locale("Вы будете перенаправлены на платежную систему для оплаты", "To'lov uchun to'lov tizimiga yo'naltirilasiz", "You will be redirected to the payment system for payment")
//                );
//                print_r($cart->basket);

                $orderClass->getOrder($orderClass->orderId);

                $arrayMessage = array_filter([
                    'Дата отправки сообщения' => adjustTime(gmdate('d-m-Y H:i'), false, 'd-m-Y H:i'),
                    'Ф.И.О.'        => $orderClass->order->client->fullName,
                    'Контакт'       => $orderClass->order->client->contact,
                    'Адрес'         => $orderClass->order->client->address,
                    'Сообщение'     => $orderClass->order->message,
                    'Кол-во'        => $orderClass->order->quantity,
                    'Общая сумма'   => number_format($orderClass->order->amount, "0", ".", " ") . ' сум',
                    'Список товаров'     => '========================================='

                ]);

                $txt = "<b> Заказ № " . $orderClass->orderId . "</b>%0A";
                foreach($arrayMessage as $key => $value) {
                    $txt .= "<b>".$key.":</b> ".$value."%0A";
                }
                foreach ($orderClass->order->products as $productId => $product) {
                    $txt .= "№ " . ($productId + 1) ." %0A";
                    $txt .= "<b>ID товара</b>: " . $product->articleId ." %0A";
                    $txt .= "<b>Наименование</b>: ".$product->title."%0A";
                    $txt .= "<b>Цена</b>: " . number_format($product->price, "0", ".", " ") ."сум %0A";
                    $txt .= "<b>Кол-во</b>: ".$product->quantity."%0A";
                    $txt .= "<b>Цена за кол-во</b>: " . number_format($product->amount, "0", ".", " ") ."сум %0A";
                }

                $feedbackClass->sendTelegram($txt);

                $orderClass->getOrder($orderClass->orderId);
                $smarty->assign('order', $orderClass->order);
                $htmlBody = $smarty->fetch('mail/order.tpl');

                if ($feedbackClass->send(Config::getValue('email'), Config::getValue('company_name'), $clientEmail, $order['fullName'], 'Заказ № ' . $orderClass->orderId, $htmlBody)) {
                    if (Session::has('token')) Session::delete('token');
                    if (Session::has('basket')) Session::delete('basket');

                    $contact = !empty($clientEmail) ? $feedbackClass->maskEmail($clientEmail) : $feedbackClass->maskPhone($order['contact']);
                    $orderClass->response = array('status' => 200, 'color' => 'green',
                        'message' => I18N::locale(
                            "Ваш заявка принята, наш менеджер свяжется с Вами по указанному контакту $contact",
                            "Sizning arizangiz qabul qilinadi, menejeringiz siz bilan $contact bilan bog'lanish uchun sizga murojaat qiladi",
                            "Your application has been accepted, our manager will contact you at the specified contact $contact"
                        ));
                } else {
                    $orderClass->response = array('status' => 400, 'color' => 'red',
                        'message' => I18N::locale("Ошибка при при отправке заказа", "Buyurtmani yuborishda xatolik yuz berdi", "Error when sending an order"));
                }
//                print_r($orderClass->order);
//                if (!empty($payment)) {
//                    if (Session::has('token')) Session::delete('token');
//                    if (Session::has('basket')) Session::delete('basket');
//                }

            } else {
                $orderClass->response = array('status' => 400, 'color' => 'red',
                    'message' => I18N::locale("Ошибка обновление данных при оформление", "Yuborilgan ma'lumotlar bo'sh bo'lmasligi kerak", "The data sent should not be empty"));
            }
        } else {
            $orderClass->response = array('status' => 400, 'color' => 'red',
                'message' => I18N::locale("Пустая корзина", "Yuborilgan ma'lumotlar bo'sh bo'lmasligi kerak", "The data sent should not be empty"));
        }
    } else {

        $orderClass->response = array('status' => 400, 'color' => 'red', 'errors' => array('payment'),
            'message' => I18N::locale("Выберите способ оплаты", "To'lov usulini tanlang", "Choose a payment method")
        );
    }
} else {
     $orderClass->response = array('status' => 400, 'color' => 'red', 'errors' => $orderClass->errors,
         'message' => I18N::locale("Необходимо заполнить все поля помеченные звездочкой", "To'lov usulini tanlang", "Choose a payment method")
     );
 }



return response()->json($orderClass->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();