<?php

require_once 'PaycomException.php';

class Merchant
{
    public $config;

    public function __construct($config)
    {
        $this->config = $config;

        if ($this->config['keyFile']) {
            $this->config['key'] = trim(file_get_contents($this->config['keyFile']));
        }
    }
//"Array(
//    [Content-Type] => application/json; charset=UTF-8
//    [Content-Length] => 117
//    [Test-Operation] => Paycom
//    [Referer] => http://test.paycom.uz
//    [User-Agent] => Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:47.0) Gecko/20100101 Firefox/47.0
//    [Host] => profito.lifestyle.uz
//    [Connection] => close
//    [X-Https] => 1
//)
//{\"id\":4430,\"result\":null,\"error\":{\"code\":-32504,\"message\":\"Insufficient privilege to perform this method.\"}}"

    /**
     * @throws PaycomException
     */
    public function Authorize($request_id)
    {
        $headers = getallheaders();

//        $headers = apache_request_headers();
//        if (isset($headers['Authorization'])) {
//            echo 'you are auth';
//        } else {
//            echo 'there is no Authorization';
//        }

//        print_r($headers);

        if (!$headers || !isset($headers['Authorization'])
            || !preg_match('/^\s*Basic\s+(\S+)\s*$/i', $headers['Authorization'], $matches)
            || base64_decode($matches[1]) != $this->config['login'] . ":" . $this->config['key']) {
            throw new PaycomException($request_id, 'Insufficient privilege to perform this method.', PaycomException::ERROR_INSUFFICIENT_PRIVILEGE);
        }

        return true;
    }
}