<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

use Mnv\Core\DB;

function smarty_function_fetch_favorite($params, &$smarty){
	
	$assign        = fetch_getParam('assign', $params, 'favorites');
    $fields     = fetch_getParam('fields', $params, 'sectionId, parentId, name, alias, url, summary, content');

	$limit         = (int) fetch_getParam('limit', $params, 100);
    $favoriteKeys  = fetch_getParam('favorites', $params);
    $userId    = (int) fetch_getParam('userId', $params);
	
	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_favorite_sections: "assign" must not be empty');
		return;
	}

	if (!empty($userId) && $userId > 0) {
        $favoriteKeys = DB::init()->connect()->table('users')->select('favorites')->where('userId','=', $userId)->getValue();
        $favoriteKeys = explode(',', $favoriteKeys);
	} else {
        $favoriteKeys = explode(',', $favoriteKeys);
	}

	if (!empty($favoriteKeys)) {
        if ($favorites = DB::init()->connect()->table('sections')->select($fields)->in('sectionId', $favoriteKeys)->limit($limit)->getAll()) {
            foreach ($favorites as $key => $section) {
                $section = prepareSection($section);
                $favorites[$key]->url  = $section->url;
                $favorites[$key]->id  = $section->sectionId;
                $favorites[$key]->image->lg  = isset($section->image->lg) ? $section->image->lg : THEME_URL.'/images/default.jpeg';
                $favorites[$key]->name = $section->name;
                $favorites[$key]->suppliers = DB::init()->connect()->table('articles')->like('sectionIds', "%$section->sectionId%")->count('*', 'count')->getValue();
            }

        } else {
            $favorites = null;
        }
        $smarty->assign($assign, $favorites);
        		
        return null;
	}

}
?>