<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

use Mnv\Core\DB;

function smarty_function_fetch_brands($params, &$smarty){
	global $gmNow;
	
	$assign        = fetch_getParam('assign', $params, 'brands');
	$fields        = fetch_getParam('fields', $params, 'brandId, publishedOn, name, fileName, url, summary, orderBy, fileId');
	$status        = fetch_getParam('status', $params, 'visible');
	$limit         = (int) fetch_getParam('limit', $params);
	$perPage       = (int) fetch_getParam('perPage', $params, $limit);
	
	$query         = fetch_getParam('query', $params, NULL);
	$match         = fetch_getParam('match', $params, 'any');
	$order         = fetch_getParam('order', $params, NULL);
	$orderBy       = fetch_getParam('orderBy', $params, $order);

    $sectionInfo  = fetch_getParam('sectionInfo', $params, false);
    $parentsInfo  = fetch_getParam('parentsInfo', $params, false);

	$page          = (int) fetch_getParam('page', $params);

    $letters       = (bool) fetch_getParam('letters', $params, false);
    $alphabet     = fetch_getParam('alphabet', $params, NULL);
    $group        = fetch_getParam('group', $params, 'en');
	
	$image        = (bool) fetch_getParam('image', $params, false);
	
	
	$assignPagination = fetch_getParam('assignPagination', $params);
	$path             = fetch_getParam('path', $params);
	$seFriendly       = (boolean) fetch_getParam('seFriendly', $params);
	$pnFirst          = (int) fetch_getParam('pnFirst', $params, 0);
	$pnBefore         = (int) fetch_getParam('pnBefore', $params, 4);
	$pnAfter          = (int) fetch_getParam('pnAfter', $params, 4);
	$pnLast           = (int) fetch_getParam('pnLast', $params, 0);
	
	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_brands: "assign" must not be empty');
		return;
	}
	
	if(empty($path)) $path = array();

	/* conditions */
    DB::init()->connect()->where('publishedOn','<=', $gmNow);
	if(!empty($status)) DB::init()->connect()->where('status','=', $status);
	if(is_null($orderBy)) DB::init()->connect()->orderBy(is_null($query) ? 'name ASC' : 'name');
    if(!is_null($query) && is_array($path)) $path[] = "query = " . urlencode($query);

    if (!empty($group)) {
        if ($group == 'ru') {
            DB::init()->connect()->where('name','REGEXP', '[а-яА-Я]');
        } elseif($group == 'en') {
            DB::init()->connect()->where('name','REGEXP', '[a-zA-Z]');
        } elseif($group == 'num') {
            DB::init()->connect()->where('name','REGEXP', '[0-9]');
        }
    }
    if (!empty($alphabet)) DB::init()->connect()->where('name','REGEXP', "^$alphabet"); //$where[] =  "name REGEXP '^($alphabet)'";
    /* query conditions */
	fetch_brands_addQueryConditions($query, $match, $fields, $orderBy);

	if ($page < 1) $page = 1;
	if ($perPage < 1) $perPage = 10;

	$brands = DB::init()->connect()->table('brands')->select($fields)->pagination($perPage, $page)->getAll();
	if ($image == true) $brands = prepareBrands($brands, $sectionInfo, $parentsInfo, $image);

	if ($letters == true) $brands = prepareLettersBrands($brands);

	$smarty->assign($assign, $brands);
	
	if(!empty($assignPagination)){
		/* page numbering */
		$total = DB::init()->connect()->table('brands')->count('*','count')->getValue();;
		if (is_array($path)) {
			$path = SITE_URL.'/'.basename($_SERVER['PHP_SELF']).'?'.(!empty($path) ? implode('&', $path).'&' : '');
			$seFriendly = false;
		}
		$pagination = getPageNums($total, $page, $perPage, $pnFirst, $pnBefore, $pnAfter, $pnLast, $path, $seFriendly);
		$smarty->assign($assignPagination, $pagination);
	}
	
	return null;
}
?>