<?php

use Mnv\Core\Config;
use Mnv\Core\Design;

ini_set( 'memory_limit', '256M' );
// ini_set('upload_max_filesize', '32M');
// ini_set('max_input_time', 360000);
// ini_set('max_execution_time', 360000);

    const LS_VERSION    = '8.0.05';
    const LS_SERIAL     = '+998 (90) 345-11-33';
    const PRODUCT_NAME  = 'LS PANEL (https://www.life-style.uz/)';

    define('GLOBAL_ROOT', realpath(dirname(__FILE__).'/../'));
    define('SITE_TRUE_URL', $_SERVER['HTTP_HOST']);
    define('IS_HTTPS', !empty($_SERVER['HTTPS']));
    define('REQUESTED_FILE', substr(strrchr($_SERVER['REQUEST_URI'], '/'), 1));

    const UPLOAD_ROOT   = GLOBAL_ROOT . '/uploads/';

	/* загрузить все языки */
	$LANGUAGES = include GLOBAL_ROOT . '/includes/global-languages.inc.php';

	/* определить язык */
	if (isset($_GET['SITE_LANG']) && isset($LANGUAGES[$_GET['SITE_LANG']])) {
		define('SITE_LANG', $_GET['SITE_LANG']);
		define('SITE_LANG_PATH', '/'.SITE_LANG);
		define('SITE_LANG_PREFIX', SITE_LANG.'_');
		define('SITE_LANG_POSTFIX', '-'.SITE_LANG);
		define('SITE_ROOT', GLOBAL_ROOT.SITE_LANG_PATH);
	} else {
		define('SITE_LANG', '');
		define('SITE_LANG_PATH', '');
		define('SITE_LANG_PREFIX', '');
		define('SITE_LANG_POSTFIX', '');
		define('SITE_ROOT', GLOBAL_ROOT);
	}

    /* определить https:// */
    if (IS_HTTPS) {
        define('GLOBAL_URL', 'https://'.SITE_TRUE_URL);
		define('GLOBAL_URI', ''); 
		define('SITE_URL',   'https://'.SITE_TRUE_URL.SITE_LANG_PATH);
        define('UPLOAD_URL', 'https://'.SITE_TRUE_URL.SITE_LANG_PATH. '/uploads');
    } else {
		define('GLOBAL_URL', 'http://'.SITE_TRUE_URL);
		define('GLOBAL_URI', '');
		define('SITE_URL',   'http://'.SITE_TRUE_URL.SITE_LANG_PATH);
        define('UPLOAD_URL', 'http://'.SITE_TRUE_URL.SITE_LANG_PATH. '/uploads');
    }

    const SITE_URI = '/' . SITE_LANG_PATH;

    if (SITE_LANG != '' && $LANGUAGES[SITE_LANG]->isDefault == 1) {
	    redirect(GLOBAL_URL);
		die('Moving to '.GLOBAL_URL);
	}

	$gmNow = gmdate('Y-m-d H:i:s');
	/* типы визитов */
	$allVisitTypes[1]['name'] = 'Home';
	$allVisitTypes[2]['name'] = 'Section';
	$allVisitTypes[3]['name'] = 'Article';
	$allVisitTypes[4]['name'] = 'Search';
	$allVisitTypes[5]['name'] = 'AdClick';
	$allVisitTypes[6]['name'] = 'Error';
	$allVisitTypes[7]['name'] = 'RSS';
	$allVisitTypes[8]['name'] = 'Sitemap';

	/* Сценарий начала времени */
	list($usec, $sec) = explode(' ', microtime());
	$scriptStartTime = ((float)$usec + (float)$sec);

    // включить отчет об ошибках
    \error_reporting(\E_ALL);
    \ini_set('display_errors', 'stdout');

    // включить утверждения
    \ini_set('assert.active', 1);
    @\ini_set('zend.assertions', 1);
    \ini_set('assert.exception', 1);

    \header('Content-type: text/html; charset=utf-8');

    $php_value = phpversion();
    if (version_compare($php_value, '7.1.0') == -1) {
        echo 'Currently installed PHP version (' . $php_value . ') is not supported. Minimal required PHP version is 7.1.0.';
        die();
    }

    /* Autoloader */
    require_once GLOBAL_ROOT . '/vendor/autoload.php';

    /* подключение компонентов */
    $databaseConfig = require_once GLOBAL_ROOT . '/includes/config.inc.php';
	require_once GLOBAL_ROOT . '/includes/functions.inc.php';

    /* Установить префикс таблиц DB */
    define('TBL_PREFIX', $databaseConfig['prefix']);

    /* Вся таблица DB */
    require_once GLOBAL_ROOT . '/includes/db.table.inc.php';

    /* инициализации */
    /* Получение настроек */
    $config     = Config::init()->config();
    /* Получение настроек карты */
    $maps       = \Mnv\Core\Maps::init()->get();
    /* инициализации Smarty  */
    $smarty     = Design::init()->design();
    /* инициализации BBCode  */
    $bbcode     = new \Mnv\Core\Utilities\BBCode\BBCode();

    /* установка кода языка (ru, uz, en) */
    \Mnv\Core\Locale\I18N::set(Config::getValue('website_language'));

    /* определение пути до темы */
    define('THEME_URL', (empty($THEME_URL) || IS_HTTPS) ? GLOBAL_URL . '/themes/' . Config::getValue('theme') : $THEME_URL);
    define('THEME_ROOT', (empty($THEME_ROOT) || IS_HTTPS) ? GLOBAL_ROOT.'/themes/'. Config::getValue('theme') : $THEME_ROOT);
    const ASSETS_URL   = GLOBAL_URL . '/themes/assets';
    const ASSETS_ROOT  = GLOBAL_ROOT . '/themes/assets';

    /* проверка запрещенных IP-адресов */
    if (!empty(Config::getValue('check_banned_ips')) && (Config::getValue('check_banned_ips') == 1)) {
        $result = \Mnv\Core\Helpers::init()->dieIfBanned(\Mnv\Core\UserInfo::get_ip());
        if ($result) {
            $smarty->assign('IS_BANNED_USER', $result);
        }
    }

    /* назначение основных переменных */
    $smarty->assign('config',           $config);
    $smarty->assign('maps',             $maps);
    $smarty->assign('SITE_URL',   SITE_URL);
    $smarty->assign('SITE_URI',   SITE_URI);
    $smarty->assign('SITE_LANG',  SITE_LANG);
    $smarty->assign('THEME_URL',  THEME_URL);
    $smarty->assign('ASSETS_URL', ASSETS_URL);
    $smarty->assign('GLOBAL_URL', GLOBAL_URL);
    $smarty->assign('GLOBAL_URI', GLOBAL_URI);
    $smarty->assign('UPLOAD_URL', UPLOAD_URL);
    $smarty->assign('IS_HTTPS',   IS_HTTPS);
    $smarty->assign('LANG', siteLanguage(Config::getValue('website_language')));

    $smarty->assignByRef('LANGUAGES', $LANGUAGES);
//    $smarty->assignByRef('TREE', $TREE);
    $smarty->assignByRef('SECTIONS', $SECTIONS);
    $smarty->assignByRef('CURRENCIES', $CURRENCIES);
	$smarty->defaultModifiers(array('escape'));

    //* registering resource "rss". rss:<b>{$var}</b>
//	$smarty->registerResource('rss', array('rss_get_template', 'rss_get_timestamp', 'rss_get_secure', 'rss_get_trusted'));
//    $smarty->registerBlock('nocache', 'smarty_block_nocache', false);
    /* загрузка системных настроек, сериализация */
    if (file_exists(SITE_ROOT . '/includes/serializations.inc.php')) {
        include SITE_ROOT . '/includes/serializations.inc.php';
    }

    /* Заголовок кодировка */
    header('Content-Type: text/html; charset=' . Config::getValue('charset')); # кодировка
    /* Заголовок название адмики и серия */
    header('X-Powered-By: ' . PRODUCT_NAME . ' - ' . LS_SERIAL); # Имя продукта
    /* сжатия GZIP */
    @ob_start('ob_gzhandler'); # сжатия GZIP

    if (Config::getValue('allow_recaptcha') == 1) define('PRIVATE_REY', Config::getValue('recaptcha_private_key'));

    const ERRORSLOG         = GLOBAL_ROOT . "/temp/log/";
    const SYSERRLOG         = GLOBAL_ROOT . "/temp/log/syserrors.log";


require_once 'overall.pub.inc.php';




