<?php

namespace Mnv\Modules\User;


use Mnv\Core\DB;
use Mnv\Core\Config;
use Mnv\Core\Feedback;
use Mnv\Core\Locale\I18N;
use Mnv\Core\Files\FileManager;
use Mnv\Core\Managers\Errors\AuthError;
use Mnv\Core\Managers\Exceptions\NotLoggedInException;
use Mnv\Core\Managers\Exceptions\InvalidPasswordException;
use Mnv\Core\Managers\Exceptions\TooManyRequestsException;


use Mnv\Modules\Payment\Click\Form\ClickGenerationForm;
use Mnv\Modules\Payment\Payme\Form\PayMeGenerationForm;
use Mnv\Modules\Payment\Apelsin\Form\ApelsinGenerationForm;

use PHPMailer\PHPMailer\PHPMailer;


class User
{

    public $response;
    public $htmlMail = false;
    public $errors = false;

    public function __construct() { }

    public function changeUser($user)
    {
        global $userAuth;

        if (!empty($user)) {
            try {
                $userAuth->changeUserInfo($user);
                $this->response =  array(
                    'status'=> 200, 'color'=> 'green',
                    'message'=> I18N::locale("Ваши данные успешно изменены", "Password has been changed", "Password has been changed")
                );
            }  catch (NotLoggedInException $e) {
                $this->response =  array(
                    'status'=> 403, 'color'=> 'red',
                    'message'=> I18N::locale("Not logged in", "Not logged in", "Not logged in")
                );
            } catch (TooManyRequestsException $e) {
                $this->response =  [
                    'status'=> 403, 'color'=> 'red',
                    'message'=> I18N::locale("Слишком много запросов!", "Too many requests!", "Too many requests!")
                ];
            }
        } else {
            $this->response =  array(
                'status'=> 403, 'color'=> 'red',
                'message'=> I18N::locale("Отправленные данные пусты!", "Yuborilgan ma'lumotlar bo'sh!", "Sent data is empty!")
            );
        }
    }

    public function changePassword($user)
    {
        global $userAuth;

        if (!empty($user) && !empty($user['oldPassword']) && !empty($user['newPassword'])) {
            try {
                $userAuth->changePassword($user['oldPassword'], $user['newPassword']);
                $this->response =  array('status'=> 200, 'color'=> 'green',
                    'message'=> I18N::locale("Пароль успешно изменен", "Parol muvaffaqiyatli almashtirildi", "Password changed successfully")
                );
            }
            catch (NotLoggedInException $e) {
                $this->response =  array('status'=> 403, 'color'=> 'red',
                    'message'=> I18N::locale("Для того чтоб менять пароль необходимо авторизоваться", "Parolni o'zgartirish uchun siz tizimga kirishingiz kerak.", "In order to change the password, you must log in.")
                );
            }
            catch (InvalidPasswordException $e) {
                $this->response =  array('status'=> 403, 'color'=> 'red',
                    'message'=> I18N::locale("Неверный старый пароль", "Noto'g'ri eski parol", "Invalid old password")
                );
            }
            catch (TooManyRequestsException $e) {
                $this->response =  array('status'=> 403, 'color'=> 'red',
                    'message'=> I18N::locale("Слишком много запросов!", "Too many requests!", "Too many requests!")
                );
            } catch (AuthError $e) {
            }
        } else {
            $this->response =  array('status'=> 403, 'color'=> 'red',
                'message'=> I18N::locale("Отправленные данные пусты!", "Yuborilgan ma'lumotlar bo'sh!", "Sent data is empty!")
            );
        }
    }

    /** TODO: доработать */
    public function changePhoto($file)
    {
        global $userAuth;

        $fileManager = new FileManager(UPLOAD_ROOT . 'users/');
        $folder_root = GLOBAL_ROOT .'/uploads/';

        $realPath = realpath($folder_root . $userAuth->id()).DIRECTORY_SEPARATOR;
        if (strpos($realPath, $folder_root) === false) {
            $realPath = $folder_root.$userAuth->id();
            $path = str_replace($folder_root.$userAuth->id(), $userAuth->id(), $realPath);
        }
        $path = str_replace($folder_root, '/', $realPath);

        if (!file_exists($realPath)) {
            mkdir($realPath, 0755, true);
        } else {
            $fileManager->delete_user_photo($folder_root, $userAuth->id());
        }


        if (isset($file) && !empty($file['file'])) {
            if($imageId = $fileManager->upload_user_photo("/users/" . $userAuth->id() . "/",  $file['file'], $userAuth->id())) {
                $userAuth->createUserPhoto($imageId);
                $this->response =  array(
                    'status'=> 200, 'color'=> 'green',
                    'message'=> I18N::locale("Изображение добавлено!", "Rasm qo'shildi!", "Image added!")
                );
            } else {
                $this->response =  array(
                    'status'=> 403, 'color'=> 'red',
                    'message'=> I18N::locale("Изображение не добавлено попробуйте снова!", "Yuborilgan ma'lumotlar bo'sh!", "Sent data is empty!")
                );
            }
        }
    }


    public function paymentAccount($user)
    {

        $feedback = new Feedback('smtp');
        $feedback->getCaptchaEnabled(Config::getValue('feedback_captcha_enabled'));
        $feedback->getAllowCaptcha(Config::getValue('allow_recaptcha'));
        $feedback->telegram(Config::getValue('telegram_send'));
        if (!empty($user)) {
            if ($userObj = DB::init()->connect()->table('shop_orders')->select('id, packageId, userId, amount, userName, userFirstName, userLastName, userPhone, userEmail')->where('id', '=', $user['order_id'])->get()) {
                if ($userObj->userId == $user['userId']) {
                    if(DB::init()->connect()->table('shop_orders')->where('id', '=', $user['order_id'])->update(['payMethod' => $user['payment_method']])) {

                        $package = DB::init()->connect()->table('sections')->select('fileName')->where('sectionId', '=', $userObj->packageId)->get();

                        // TODO: платежные системы
                        $this->response['note'][] = 'Оплата за участие';
                        $this->response['status'] = 200;
                        $this->response['color'] = 'green';

                        if ($user['payment_method'] == 'payme') {
                            $payme = new PayMeGenerationForm();
                            $this->response['form'] = $payme->form($userObj->id, (int)$userObj->amount, $this->response['note']);
                        } else if ($user['payment_method'] == 'click') {
                            $click = new ClickGenerationForm();
                            $this->response['form'] = $click->form($userObj->id, $userObj->amount, $this->response['note'], $userObj->userPhone, $userObj->userEmail);
                        } else if ($user['payment_method'] == 'apelsin') {
                            $apelsin = new ApelsinGenerationForm();
                            $this->response['form'] = $apelsin->form($userObj->id, (int)$userObj->amount, $userObj->userId);
                        }
                        if ($getUser = DB::init()->connect()->table('users')->select('userId, fullName, phone, email, code')->where('userId', '=', $userObj->userId)
                            ->where('accessLevel', '=',8192)->get() ) {

                            $htmlBody = "<p> $getUser->fullName <br/> Поздравляем Вас с успешной регистрацией на сайте ". SITE_URL .
                                "<br/> Рады видеть Вас в сообществе. <br/>" .
                                "<br/> <b>Ваш логин</b>: " . $getUser->email . " <br/>" .
                                "<br/> <b>Ваш пароль</b>: " . $getUser->code . " <br/>" .
                                "<br/> Если возникнут какие-то вопросы, обращайтесь к нам по номеру " .Config::getValue('phone') . "или по почте " .Config::getValue('email') . ". <br>" .
                                "<br/> Команда Ishu.</p>";

                            // todo: отпарвку на почту
                            if (empty($feedback->errors) && $feedback->send($getUser->email, 'Регистрация на сайте', $htmlBody)) {
                                $this->response['answer'] = array('code' => 1, 'message' => $userObj->userName);
                            } else {
                                $this->response['answer'] = array('code' => 0, 'message' => $feedback->errors);
                            }
                        }
                    }
                }
            } else {
                $this->response = array('status' => 403, 'color'=> 'red',
                    'message'=> I18N::locale("Нет такого пользователя", "Yuborilgan ma'lumotlar bo'sh!", "Sent data is empty!")
                );
            }
        }
    }


    public function logout()
    {
        global $userAuth;

        $userAuth->logOutUser();
        if (!$userAuth->isLoggedIn()) {
            $this->response = array(
                'status' => 200, 'color' => 'green',
                'message' => I18N::locale("До встречи!", "Ko'rishguncha!", "See you!")
            );
        }
    }

    /**
     * Отправка письма PHPMailer (smtp)
     *
     * @param $to
     * @param $companyName
     * @param $subject
     * @param $htmlBody
     * @param false $is_html
     * @return bool|string
     * @throws \Exception
     */
    public function sendToEmail($to, $companyName, $subject, $htmlBody, $is_html = false)
    {
        $mail = new PHPMailer();
        $mail->CharSet    = Config::getValue('charset');
        $mail->SMTPDebug  = 0;
        $mail->setFrom(Config::getValue('smtp_user'), $companyName);

        if (Config::getValue('mail_transport')) {
            $mail->isSMTP();
            $mail->SMTPAuth   = true;
            $mail->Timeout  = 10;
            $mail->Host       = Config::getValue('smtp_server');
            $mail->Port       = Config::getValue('smtp_port');
            $mail->SMTPSecure = Config::getValue('smtp_secure');
            $mail->SMTPKeepAlive = true;
            $mail->Username   = Config::getValue('smtp_user');
            $mail->Password   = Config::getValue('smtp_pass');

        } else {
            $mail->From   = Config::getValue('smtp_user');
            $mail->Sender = Config::getValue('smtp_user');
        }

        $mail->XMailer = "LS CMS";

        if ( $is_html ) {
            $mail->isHTML();
            $this->htmlMail = true;
        }

        $mail->addReplyTo(Config::getValue('smtp_user'));
        $mail->addAddress($to, $companyName);


        $mail->Subject = $subject;
        if ($this->htmlMail) {
            $mail->msgHTML($htmlBody);
        } else {
            $mail->Body = $htmlBody;
        }

        if(!$mail->send()) {
            $this->errors = $mail->ErrorInfo;
            $mail->clearAllRecipients();
            $mail->clearAttachments();
            return false;
        } else {
            $mail->clearAllRecipients();
            $mail->clearAttachments();
            return true;
        }
    }

    /**
     * Скрыть несколько симоволов в email
     * @param $email
     * @param int $minLength
     * @param int $maxLength
     * @param string $mask
     * @return string
     */
    public function maskEmail($email, $minLength = 3, $maxLength = 10, $mask = "***") {
        $atPos = strrpos($email, "@");
        $name = substr($email, 0, $atPos);
        $len = strlen($name);
        $domain = substr($email, $atPos);

        if (($len / 2) < $maxLength) $maxLength = ($len / 2);

        $shortenedEmail = (($len > $minLength) ? substr($name, 0, $maxLength) : "");
        return  "{$shortenedEmail}{$mask}{$domain}";
    }



//    function addAttachment($mail, $path, $name = '', $encoding = 'base64', $type = '', $disposition = 'attachment') {
//        $mail->addAttachment($path, $name, $encoding, $type, $disposition );
//    }
}