<?php
namespace Mnv\Modules\Telegram\Yandex;

/**
 * Class Response
 * @package Mnv\Modules\Telegram\Yandex
 */
class Response
{
    /** @var array $_list */
    public array $_list = array();

    /** @var array $_data */
    public array $_data;

    /**
     * Response constructor.
     * @param array $data
     */
    public function __construct(array $data)
    {
        $this->_data = $data;
        if (isset($data['features'])) {
            foreach ($data['features'] as $entry) {
                $this->_list[] = new GeoObject($entry);
//                $this->_list[] = $data->getData();
            }
        }
    }

    /**
     * Исходные данные
     * @return array
     */
    public function getData(): array
    {
        return $this->_data;
    }

    /**
     * @return array[]
     */
    public function getList(): array
    {
        return $this->_list;
    }


    /**
     * @return null|GeoObject
     */
    public function getFirst(): ?GeoObject
    {
        $result = null;
        if (count($this->_list)) {
            $result = $this->_list[0];
        }

        return $result;
    }

    /**
     * Возвращает исходный запрос
     * @return string|null
     */
    public function getQuery(): ?string
    {
        $result = null;
        if (isset($this->_data['properties']['ResponseMetaData']['SearchRequest']['request'])) {
            $result = $this->_data['properties']['ResponseMetaData']['SearchRequest']['request'];
        }
        return $result;
    }

    /**
     * Кол-во найденных результатов
     * @return int
     */
    public function getFoundCount(): ?int
    {
        $result = null;
        if (isset($this->_data['properties']['ResponseMetaData']['SearchResponse']['found'])) {
            $result = (int)$this->_data['properties']['ResponseMetaData']['SearchResponse']['found'];
        }
        return $result;
    }

    /**
     * Широта в градусах. Имеет десятичное представление с точностью до семи знаков после запятой
     * @return float|null
     */
    public function getLatitude(): ?float
    {
        $result = null;
        if (isset($this->_data['properties']['ResponseMetaData']['SearchRequest']['boundedBy'][0][0])) {
            list(,$latitude) = explode(' ', $this->_data['properties']['ResponseMetaData']['SearchRequest']['boundedBy'][0][0]);
            $result = (float)$latitude;
        }
        return $result;
    }

    /**
     * Долгота в градусах. Имеет десятичное представление с точностью до семи знаков после запятой
     * @return float|null
     */
    public function getLongitude(): ?float
    {
        $result = null;
        if (isset($this->_data['properties']['ResponseMetaData']['SearchRequest']['boundedBy'][0][1])) {
            list($longitude,) = explode(' ', $this->_data['properties']['ResponseMetaData']['SearchRequest']['boundedBy'][0][1]);
            $result = (float)$longitude;
        }
        return $result;
    }
}