# Telegram Bot Inline Keyboard Pagination

## Usage

### Тестовые данные

```php
$items        = range(1, 100); // required. 
$command      = 'testCommand'; // optional. Default: pagination
$selectedPage = 10;            // optional. Default: 1
$labels       = [              // optional. Change button labels (showing defaults)
    'default'  => '%d',
    'first'    => '« %d',
    'previous' => '‹ %d',
    'current'  => '· %d ·',
    'next'     => '%d ›',
    'last'     => '%d »',
];

// optional. Change the callback_data format, adding placeholders for data (showing default)
$callbackDataFormat = 'command={COMMAND}&oldPage={OLD_PAGE}&newPage={NEW_PAGE}'
```

### как использовать

```php
// Определите встроенную разбивку клавиатуры на страницы.
$ikp = new InlineKeyboardPagination($items, $command);
$ikp->setMaxButtons(7, true); // Второй параметр, установленный так, чтобы всегда показывать 7 кнопок, если это возможно.
$ikp->setLabels($labels);
$ikp->setCallbackDataFormat($callbackDataFormat);

// Получите разбивку на страницы.
$pagination = $ikp->getPagination($selectedPage);

// or, in 2 steps.
$ikp->setSelectedPage($selectedPage);
$pagination = $ikp->getPagination();
```

Теперь `$pagination['keyboard']` - это, по сути, строка, содержащая разбивку на страницы.

```php
// Используйте это в своем запросе.
if (!empty($pagination['keyboard'])) {
    //$pagination['keyboard'][0]['callback_data']; // command=testCommand&oldPage=10&newPage=1
    //$pagination['keyboard'][1]['callback_data']; // command=testCommand&oldPage=10&newPage=7
    
    ...
    $data['reply_markup'] = [
        'inline_keyboard' => [
            $pagination['keyboard'],
        ],
    ];
    ...
}
```

Чтобы получить данные обратного вызова, вы можете использовать предоставленный вспомогательный метод (работает только при использовании формата данных обратного вызова по умолчанию):

```php
// e.g. Callback data.
$callback_data = 'command=testCommand&oldPage=10&newPage=1';

$params = InlineKeyboardPagination::getParametersFromCallbackData($callbackData);

//$params = [
//    'command' => 'testCommand',
//    'oldPage' => '10',
//    'newPage' => '1',
//];

// or, just use PHP directly if you like. (literally what the helper does!)
parse_str($callbackData, $params);
```
