<?php


namespace Mnv\Modules\Telegram\Pagination;

/**
 * Class Pagination
 * @package Mnv\Modules\Telegram\Pagination
 */
class Pagination
{

    /** @var null $instance */
    private static $instance = null;

    /** @return Pagination|null */
    public static function init(): ?Pagination
    {
        if ( self::$instance == null )
            self::$instance = new Pagination();

        return self::$instance;
    }
    /**
     * TelegramBotPagination constructor.
     */
    public static function generationPages(int $totalItems, int $currentPage, int $itemsPerPage = 10, int $firstSet = 5, int $beforeCurrent = 2, int $afterCurrent = 2, int $lastSet = 5)
    {

        $totalPages = ceil($totalItems / $itemsPerPage);
        if ($currentPage > $totalPages) return false;


        $pageNums['totalPages']     = $totalPages;
        $pageNums['totalItems']     = $totalItems;
        $pageNums['currentPage']    = $currentPage;
        $pageNums['startIteration'] = ($currentPage - 1) * $itemsPerPage + 1;
        $pageNums['endIteration']   = $currentPage * $itemsPerPage;
        if ($pageNums['endIteration'] > $totalItems) $pageNums['endIteration'] = $totalItems;

        /* первые X */
        if ($firstSet > 0) {
            for ($i=1; $i <= ($totalPages > $firstSet ? $firstSet : $totalPages); $i++)
                $pages[$i] = $i;
        }

        /* X справа, X слева */
        for ($i=($currentPage - $beforeCurrent); $i <= ($currentPage + $afterCurrent); $i++) {
            if ($i > 0 && $i <= $totalPages)
                $pages[$i] = $i;
        }

        /* последние X */
        if ($lastSet > 0) {
            for ($i=($totalPages - $lastSet + 1); $i <= $totalPages; $i++)  if($i > 0)
                $pages[$i] = $i;
        }

        /* расставляем точки */
        $i = 0;
        if (!empty($pages) && count($pages) > 1) {
            asort($pages);
            $prevPage = 0;
            foreach ($pages as $page) {
                if (($page - $prevPage) > 1 && $i > 0) {
                    array_splice($pages, $i, 0, '...');
                    $i++;
                }
                $prevPage = $page;
                $i++;
            }
            $pageNums['pages'] = $pages;
        }

        /* следующая страница */
        if(($currentPage + 1) <= $totalPages) $pageNums['nextPage'] = $currentPage + 1;
        /* предыдущая страница */
        if (($currentPage - 1) >= 1) $pageNums['previousPage'] = $currentPage - 1;
        /* первая страница */
        if ($currentPage != 1) $pageNums['firstPage'] = $currentPage - 1;
        /* последняя страница */
        if($currentPage != $totalPages) $pageNums['lastPage'] = $currentPage - 1;

        if (!empty($pageNums)) {
            return $pageNums;
        } else {
            return array();
        }
    }
}