<?php

namespace Mnv\Modules\Telegram\Pages;

use Mnv\Modules\Telegram\Helpers\GenerateInlineButtons;
use Mnv\Modules\Telegram\Models\Categories;
use Mnv\Modules\Telegram\Telegram;
use Mnv\Modules\Telegram\TelegramUser;
use Mnv\Modules\Telegram\Commands\Commands;

/**
 * Class Contacts
 * @package Mnv\Modules\Telegram\Pages
 */
class Contacts
{

    /**
     * Страница 📝 Связаться с нами / page 7
     *
     * @param TelegramUser $user
     * @param Telegram $telegram
     * @param int $chatID
     * @param int $setPage
     */
    public static function feedback(TelegramUser $user, Telegram $telegram, int $chatID, int $setPage = 7)
    {
        /** page */
        $user->setPage($setPage);

        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))],
        ];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        $content = array('chat_id' => $chatID, 'reply_markup' => $keyboard, 'text' => "Здесь будет возможность связаться с разработчиками бота \n\nСтраница в стадии разработки", 'parse_mode' => "HTML");
        $telegram->sendMessage($content);
    }

    /**
     * Страница поддержка / page 7
     *
     * @param TelegramUser $user
     * @param Telegram $telegram
     * @param int $chatID
     * @param int $setPage
     */
    public static function support(TelegramUser $user, Telegram $telegram, int $chatID, int $setPage = 7)
    {
        /** page */
        $user->setPage($setPage);

        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))],
        ];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        $content = array('chat_id' => $chatID, 'reply_markup' => $keyboard, 'text' => "Здесь будет возможность связаться с разработчиками бота \n\nСтраница в стадии разработки", 'parse_mode' => "HTML");
        $telegram->sendMessage($content);
    }

    /**
     * Страница ✍️ Оставить отзыв page 11
     *
     * @param TelegramUser $user
     * @param Telegram $telegram
     * @param int $chatID
     * @param int $setPage
     */
    public static function leaveReview(TelegramUser $user, Telegram $telegram, int $chatID, int $setPage = 8)
    {
        /** page */
        $user->setPage($setPage);

        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))],
        ];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        $content = array('chat_id' => $chatID, 'reply_markup' => $keyboard, 'text' => "Напишите ваш отзыв или пожелания.", 'parse_mode' => "HTML");
        $telegram->sendMessage($content);
    }


    /**
     * Правила / page 2
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param int $sectionId
     */
    public static function rules(Telegram $telegram, int $chatID, int $sectionId)
    {
        /** page */
        $text = Categories::getSectionContent($sectionId);
//        sendMessage(json_encode($text,JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
        $content = array_merge(['chat_id' => $chatID, 'parse_mode' => "HTML"], $text);
//        if (!is_null($text['photo'])) {
//            $telegram->sendPhoto($content);
//        } else {
            $telegram->sendMessage($content);
//        }
    }

    /**
     * Получить content раздела
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param int $sectionId
     */
    public static function getSectionText(Telegram $telegram, int $chatID, int $sectionId)
    {
        /** page */
        $text = Categories::getSectionContent($sectionId);
        $content = array_merge(['chat_id' => $chatID, 'parse_mode' => "HTML"], $text);
        $telegram->sendMessage($content);
    }

    /**
     * Страница настройки page 20
     *
     * @param TelegramUser $user
     * @param Telegram $telegram
     * @param int $chatID
     * @param int $setPage
     */
    public static function settings(Telegram $telegram, TelegramUser $user,  int $chatID, int $setPage = 30)
    {
        /** page */
        $user->setPage($setPage);

        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('change_lang'))],
            [$telegram->buildKeyboardButton(Commands::getMessageText('change_phone'))],
            [$telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))],
        ];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        $telegram->sendMessage([
            'chat_id'       => $chatID,
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('interests'),
            'parse_mode'    => "HTML"
        ]);
    }

    /**
     * Возврат на страницу настройки (только с ответом об успешном изменение (языка, номера телефона))
     *
     * @param TelegramUser $user
     * @param Telegram $telegram
     * @param int $chatID
     * @param int $setPage
     */
    public static function settingChangeLanguage(Telegram $telegram, TelegramUser $user, int $chatID, int $setPage = 30)
    {
        /** page */
        $user->setPage($setPage);

        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('change_lang'))],
            [$telegram->buildKeyboardButton(Commands::getMessageText('change_phone'))],
            [$telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))],
        ];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        $telegram->sendMessage([
            'chat_id'       => $chatID,
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('ready_made'),
            'parse_mode'    => "HTML"
        ]);
    }

    /**
     * Изменить язык page 21
     *
     * @param TelegramUser $user
     * @param Telegram $telegram
     * @param int $chatID
     * @param int $setPage
     */
    public static function changeLanguage(Telegram $telegram, TelegramUser $user, int $chatID, int $setPage = 31)
    {
        $user->setPage($setPage);

        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('ru')), $telegram->buildKeyboardButton(Commands::getMessageText('uz'))],
            [$telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))],
        ];
        $keyboard = $telegram->buildKeyBoard($option, false, true);
        $telegram->sendMessage([
            'chat_id'       => $chatID,
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('select_lang'),
            'parse_mode'    => "HTML"
        ]);
    }

    /**
     * Изменить номер телефона page 22
     *
     * @param TelegramUser $user
     * @param Telegram $telegram
     * @param int $chatID
     * @param int $setPage
     */
    public static function changeContract(Telegram $telegram, TelegramUser $user, int $chatID, int $setPage = 32)
    {
        $user->setPage($setPage);

        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('send_contact'), true, false)],
            [$telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))],
        ];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        $telegram->sendMessage([
            'chat_id'       => $chatID,
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('add_phone'),
            'parse_mode'    => "HTML"
        ]);
    }

    /**
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param int|null $MessageID
     * @param bool $isEditMessage
     */
    public static function districts(Telegram $telegram, int $chatID, ?int $MessageID, bool $isEditMessage = false)
    {
        $rows[]	= array_map(function($district) {
            return [
                'text' => $district,
                'callback_data' => "/dist_" . $district
            ];
        }, Categories::getDistrictsList());

        $keyboardButton = GenerateInlineButtons::prepareKeyboard(...$rows);
        $keyboardButton[] = [$telegram->buildInlineKeyboardButton(Commands::getMessageText('back_btn'), null, "/back_to_main")];

        $keyboard = $telegram->buildInlineKeyBoard($keyboardButton);
        if ($isEditMessage) {
            $telegram->editMessageText([
                'chat_id'       => $chatID,
                'message_id'    => $MessageID,
                'reply_markup'  => $keyboard,
                'text'          => Commands::getMessageText('choose_district'),
                'parse_mode'    => "HTML"]);
        } else {
            $telegram->sendMessage([
                'chat_id'       => $chatID,
                'reply_markup'  => $keyboard,
                'text'          => Commands::getMessageText('choose_district'),
                'parse_mode'    => "HTML"
            ]);
        }
    }

    /**
     * Запись координат пользователя в базу
     * @param TelegramUser $user
     * @param $data
     */
    public static function setLocation(TelegramUser $user, $data)
    {
        if (isset($data['message']['location']['latitude']) && isset($data['message']['location']['longitude'])) {
            $latitude = number_format((float)$data['message']['location']['latitude'], 10, '.', '');
            $longitude = number_format((float)$data['message']['location']['longitude'], 10, '.', '');
            $user->setLatitude($latitude);
            $user->setLongitude($longitude);
            $user->setDistrict('');
        }
    }

}