<?php

namespace Mnv\Modules\Telegram\Models;

use Mnv\Core\DB;
use Mnv\Core\Files\Image\ImageSizes;

class Categories
{

    public static function getSections(int $sectionId, string $usage, string $method, bool $isIcon = false): ?array
    {
        if (!$categories =  DB::init()->connect()->table('sections')->select('sectionId, icon, name')
            ->where('status', 'visible')->where('typeContent', 'categorys')
            ->where('parentId', $sectionId)->orderBy('sortOrder ASC')->getAll()) {
            return null;
        }

        $rows[]	= array_map(function($item) use ($usage, $method) {
//            $icon = !empty($item->icon) ? Emojify::getInstance()->toEmoji($item->icon) : '';
            return [
//                'text' => $icon . " " . $item->name,
                'text' => $item->name,
                'callback_data' => implode('::', [$usage, $method, $item->sectionId]),
            ];
        }, $categories);

        return $rows;
    }

    public static function getParentId($sectionId)
    {
        return DB::init()->connect()->table('sections')->select('parentId')->where('status', 'visible')
            ->where('sectionId', $sectionId)->where('typeContent', 'categorys')->orderBy('sortOrder ASC')->getValue();
    }

    public static function getCategories(int $sectionId): ?array
    {
        if (!$categories =  DB::init()->connect()->table('sections')->select('sectionId, icon, name')
            ->where('status', 'visible')->where('typeContent', 'categorys')
            ->where('parentId', $sectionId)->orderBy('sortOrder ASC')->getAll()) {
            return null;
        }
        return array_column($categories, 'name');
    }

    /** получение массива районов с id */
    public static function getCategoriesList(int $sectionId = 2): ?array
    {
        if (!$categories =  DB::init()->connect()->table('sections')->select('sectionId, name, alias')->where('status', 'visible')
            ->where('parentId', $sectionId)->where('typeContent', 'categorys')->orderBy('sortOrder ASC')->getAll()) {
            return null;
        }

        $newCategories = [];
        foreach ($categories as $category) $newCategories[$category->sectionId] = $category->name;

        return $newCategories;
    }


    /** получение списка регионов */
    public static function getSectionRegions(): ?array
    {
        if (!$regions =  DB::init()->connect()->table('sections')->select('sectionId, name, alias')
            ->where('status', 'visible')
            ->where('parentId', 168)->orderBy('sortOrder ASC')->getAll()) {
            return null;
        }
        return array_column($regions, 'name');
    }


    /** получение массива регионов с id */
    public static function getRegionList(): ?array
    {
        if (!$regions =  DB::init()->connect()->table('sections')->select('sectionId, name, alias')
            ->where('status', 'visible')
            ->where('parentId', 168)->orderBy('sortOrder ASC')->getAll()) {
            return null;
        }

        $newRegions = [];
        foreach ($regions as $region) $newRegions[$region->sectionId] = $region->name;

        return $newRegions;
    }

    /** получение списка районов */
    public static function getSectionArea($regionId): ?array
    {
        if (!$areas =  DB::init()->connect()->table('sections')->select('sectionId, name, alias')->where('status', 'visible')
            ->where('parentId', $regionId)->orderBy('sortOrder ASC')->getAll()) {
            return null;
        }
        return array_column($areas, 'name');
    }

    /** получение массива районов с id */
    public static function getAreaList($regionId): ?array
    {
        if (!$areas =  DB::init()->connect()->table('sections')->select('sectionId, name, alias')->where('status', 'visible')
            ->where('parentId', $regionId)->orderBy('sortOrder ASC')->indexKey('sectionId')->valueKey('name')->getAllIndexes()) {
            return null;
        }

//        $newAreas = [];
//        foreach ($areas as $area) $newAreas[$area->sectionId] = $area->name;

        return $areas;
    }

    /**
     * Получение районов Ташкента
     */
    public static function getDistrictsList(int $regionId = 169): ?array
    {
        if (!$areas =  DB::init()->connect()->table('sections')->select('sectionId, name, alias')->where('status', 'visible')
            ->where('parentId', $regionId)->orderBy('sortOrder ASC')->getAll()) {
            return null;
        }
        return array_column($areas, 'alias');

    }

    public static function getWeekdayList()
    {
        if (!$weekday=  DB::init()->connect()->table('sections')->select('sectionId, name, alias')->where('status', 'visible')
            ->where('parentId', 195)->orderBy('sortOrder ASC')->indexKey('sectionId')->valueKey('name')->getAllIndexes()) {
            return null;
        }

        return $weekday;
    }

    /**
     * Получение контента раздела
     * @param int $sectionId
     * @return array|string[]|null
     */
    public static function getSectionContent(int $sectionId): ?array
    {
        if (!$rules =  DB::init()->connect()->table('sections')->select('sectionId, name, content')->where('status', 'visible')->where('sectionId', $sectionId)->get()) {
            return null;
        }

        $images = self::getObjectFiles($rules->sectionId);
        $image = !empty($images->image) ? GLOBAL_URL . $images->image->original : null;
        $tags = array('</p>','<br />','<br>','<hr />','<hr>','</h1>','</h2>','</h3>','</h4>','</h5>','</h6>');
        $content = str_replace($tags,"\n",$rules->content);
        $content = html_entity_decode(strip_tags($content));
        if (!is_null($image)) {
            return [
                'text' => $content . "<a href= '$image'>&#8205;</a>",
            ];
        } else {
            return [
                'text' => $content,
            ];
        }
    }


    /**
     * Получение изображения
     *
     * @param $sectionId
     * @return \stdClass
     */
    private static function getObjectFiles($sectionId): \stdClass
    {
        $object =new \stdClass();
        $images = DB::init()->connect()->table('section_images')->where('sectionId', $sectionId)->orderBy('orderBy')->getAll();
        foreach ($images as $imageId => $image) {
            if ($file = DB::init()->connect()->table('files')->select('fileId, folder, path, fileName, size')->where('fileId', $image->fileId)->get()) {
                if ($image->type === 'general') {
                    $object->image = ImageSizes::init()->get($image, $file);
                } else if ($image->type === 'gallery') {
                    $object->gallery[$imageId] = ImageSizes::init()->get($image, $file);
                } else {
                    $object->docs[$imageId] = ImageSizes::init()->get($image, $file);
                }
            }
        }

        return $object;
    }


}