<?php

namespace Mnv\Modules\Telegram\Models;

use Mnv\Core\DB;

class AddingObject
{
    private string $_table_telegram_user_chat = 'telegram_user_chat';
    private string $_table_adding_object = 'telegram_user_adding_object';
    private string $_table_adding_object_images = 'telegram_user_adding_object_images';

    private ?int $userId;
    public int $object_id = 0;
    public int $step_id = 0;

    public function __construct(int $chatId)
    {
        if ($object = DB::init()->connect()->table($this->_table_adding_object)->join($this->_table_telegram_user_chat, 'id', '=', 'user_id')
            ->select('object_id, step_id')->where('isAdded', 1)->where('chat_id', $chatId)->get()) {
            $this->object_id = $object->object_id;
            $this->step_id = $object->step_id;
        }
    }

    /**
     * @param $chatId
     */
    private function isUserSet($chatId): void
    {
        $this->userId = DB::init()->connect()->table($this->_table_telegram_user_chat)->select('user_id')->where('chat_id', $chatId)->getValue();
    }

    /**
     * Создание новой записи
     *
     * @param int $chatId
     * @param string $text
     * @return bool
     */
    public function addObject(int $chatId, string $text): bool
    {
        $this->isUserSet($chatId);
        $data = [
            'id'        => $this->userId,
            'step_id'   => 0,
            'title'     => $text,
            'isAdded'   => 1,
            'creating'  => gmdate('Y-m-d H:i:s'),
        ];
        if (DB::init()->connect()->table($this->_table_adding_object)->insert($data)) {

            return true;
        }

        return false;
    }

    /**
     * Обновление записи
     *
     * @param int $objectId
     * @param int $chatId
     * @param array $param
     * @return bool
     */
    public function updateObject(int $chatId, int $objectId, array $param): bool
    {
        $this->isUserSet($chatId);
        if (DB::init()->connect()->table($this->_table_adding_object)->where('object_id', $objectId)->where('isAdded', 1)->where('id',  $this->userId)->update($param)) {
            if (isset($param['isAdded']) && $param['isAdded'] == 2) {
                $this->transferringObject($objectId, $this->userId);
            }
            return true;
        }

        return false;
    }

    public function getParamValueObject(int $chatId, int $objectId, string $param)
    {
        $this->isUserSet($chatId);
        return DB::init()->connect()->table($this->_table_adding_object)->select($param)->where('object_id', $objectId)->where('isAdded', 1)->where('id', $this->userId)->getValue();
    }

    /**
     * Перенос объекта в table `articles`
     * @param $objectId
     * @param $userId
     */
    private function transferringObject($objectId, $userId)
    {
       if ($object = DB::init()->connect()->table($this->_table_adding_object)->where('object_id', $objectId)->where('isAdded', 2)->where('id', $userId)->get()) {
           $object->region = DB::init()->connect()->table('sections')->select('name')->where('sectionId', $object->region_id)->getValue();
           $object->area = DB::init()->connect()->table('sections')->select('name')->where('sectionId', $object->area_id)->getValue();

           $workingDays = json_decode($object->workingDays, true);

           $data = [
               'title'          => $object->title,
               'sectionId'      => $object->category_id,
               'typeContent'    => 'categorys',
               'content'        => $object->content,
               'regionId'       => $object->region_id,
               'areaId'         => $object->area_id,
               'regionName'     => $object->region,
               'areaName'       => $object->area,
               'address'        => "$object->region, $object->area, $object->address",
               'phone'          => $object->phone,
               'workingHours'   => $object->workingHours . ' / ' . implode(", ", $workingDays),
               'coordinates'    => $object->coordinates,
               'imageUrl'       => $object->images,
               'publishedOn'    => gmdate('Y-m-d H:i:s'),
               'addedBy'        => $userId,
               'addedOn'        => gmdate('Y-m-d H:i:s'),
           ];

//           sendMessage($data);
           DB::init()->connect()->table('articles')->insert($data);
       }
    }

    /**
     * Обновление записи
     *
     * @param int $chatId
     * @param int $objectId
     * @return string|null
     */
    public function getObject(int $chatId, int $objectId): ?string
    {
        $this->isUserSet($chatId);
        if ($object = DB::init()->connect()->table($this->_table_adding_object)->where('object_id', $objectId)->where('id',  $this->userId)->get()) {
            $object->categoryName = DB::init()->connect()->table('sections')->select('name')->where('sectionId', $object->category_id)->getValue();
            $object->region = DB::init()->connect()->table('sections')->select('name')->where('sectionId', $object->region_id)->getValue();
            $object->area = DB::init()->connect()->table('sections')->select('name')->where('sectionId', $object->area_id)->getValue();

            $coordinates = explode(', ', $object->coordinates);
            $workingDays = json_decode($object->workingDays, true);
            $contentText = strip_tags($object->content);
            $contentText = trim(html_entity_decode($contentText));


            $weekdayList = Categories::getWeekdayList();
            $newWeekday = '';
            foreach ($weekdayList as $key => $item) {
                if (array_search($item, $workingDays) !== false) {
                    $newWeekday .= sprintf("%-'.26s", "$item") . $object->workingHours . "\n";
                } else {
                    $newWeekday .= sprintf("%-'.26s", $item). "Выходной \n";
                }
            }

            return " <b>Категория:</b> $object->categoryName \n" .
                "<b>Название:</b> $object->title \n" .
                "<b>Адрес:</b> $object->region, $object->area, $object->address \n" .
                "<b>Телефон️:</b>  $object->phone \n\n" .
                "<b>Режим работы: </b>\n$newWeekday \n\n" .
//                   "<b>Локация:</b> \nhttps://maps.yandex.ru/?ll=" .$coordinates[1] . "," .$coordinates[0] . "\n\n" .
                "<b>Описание:</b> \n$contentText" .
                "<a href='$object->images'>&#8205;</a>";
        }

        return null;
    }

    public function getLocationObject(int $chatId, int $objectId)
    {
        $this->isUserSet($chatId);
        if ($object = DB::init()->connect()->table($this->_table_adding_object)->select('coordinates')->where('object_id', $objectId)->where('id',  $this->userId)->get()) {
            $object->coordinates = explode(', ', $object->coordinates);
            return $object->coordinates;
        }

        return null;
    }

//    /**
//     * Отмена и удаление объекта
//     *
//     * @param int $chatId
//     * @param int|null $objectId
//     * @return bool
//     */
//    public function hasObject(int $chatId, ?int $objectId): bool
//    {
//        $this->isUserSet($chatId);
//        if (DB::init()->connect()->table($this->_table_adding_object)->where('object_id', $objectId)->where('isAdded', 1)->where('id',  $this->userId)->get()) {
//            return true;
//        }
//
//        return false;
//    }
    /**
     * Отмена и удаление объекта
     *
     * @param int $chatId
     * @param int $objectId
     * @return bool
     */
    public function deleteObject(int $chatId, int $objectId): bool
    {
        $this->isUserSet($chatId);
        if (DB::init()->connect()->table($this->_table_adding_object)->where('object_id', $objectId)->where('isAdded', 1)->where('id',  $this->userId)->get()) {
            DB::init()->connect()->table($this->_table_adding_object)->where('object_id', $objectId)->where('isAdded', 1)->where('id',  $this->userId)->delete();
            return true;
        }

        return false;
    }

    /**
     * Отмена и удаление объекта
     *
     * @param int $chatId
     * @param int $objectId
     */
    /**
     * @param int $chatId
     * @param int $objectId
     * @return mixed|string|null
     */
    public function getCategoryObject(int $chatId, int $objectId)
    {
        $this->isUserSet($chatId);
        if ($categoryId = DB::init()->connect()->table($this->_table_adding_object)->select('category_id')->where('object_id', $objectId)->where('isAdded', 1)->where('id',  $this->userId)->getValue()) {
            return $categoryId;
        }

        return null;
    }

    /**
     * Получение ID региона
     *
     * @param int $chatId
     * @param int $objectId
     * @return mixed|string|null
     */
    public function getRegionObject(int $chatId, int $objectId)
    {
        $this->isUserSet($chatId);
        if ($regionId = DB::init()->connect()->table($this->_table_adding_object)->select('region_id')->where('object_id', $objectId)->where('isAdded', 1)->where('id',  $this->userId)->getValue()) {
            return $regionId;
        }

        return null;
    }

    /**
     * Добавление изображений
     *
     * @param int $chatId
     * @param int $objectId
     * @return bool
     */
    public function isObjectImage(int $chatId,  int $objectId): bool
    {
        $this->isUserSet($chatId);
        if (DB::init()->connect()->table($this->_table_adding_object_images)->where('id',  $this->userId)->where('object_id', $objectId)->get()) {
            return true;
        }

        return false;

    }
    /**
     * Добавление изображений
     *
     * @param int $chatId
     * @param int $objectId
     * @param string $imageUrl
     * @return bool
     */
    public function addObjectImage(int $chatId, int $objectId, string $imageUrl): bool
    {
        $this->isUserSet($chatId);
        $isImage = DB::init()->connect()->table($this->_table_adding_object_images)->where('id',  $this->userId)->where('object_id', $objectId)->get();
        $data = [
            'id'        => $this->userId,
            'object_id' => $objectId,
            'imageUrl'  => $imageUrl,
        ];
        if ($isImage) {
            if (DB::init()->connect()->table($this->_table_adding_object_images)->where('id',  $this->userId)->where('object_id', $objectId)->update($data)) return true;
        } else {
            if (DB::init()->connect()->table($this->_table_adding_object_images)->insert($data)) return true;
        }

        return false;
    }

    /**
     * Получение изображений
     * @param int $chatId
     * @param int $objectId
     * @return string
     */
    public function getObjectImages(int $chatId,  int $objectId): string
    {
        $this->isUserSet($chatId);
        return DB::init()->connect()->table($this->_table_adding_object_images)->select('imageUrl')->where('id',  $this->userId)->where('object_id', $objectId)->getValue();

    }







}