<?php

namespace Mnv\Modules\Telegram\Helpers;

use Mnv\Modules\Telegram\Telegram;

/**
 * Class GenerateInlineButtons
 * @package Mnv\Modules\Telegram\Helpers
 */
class GenerateInlineButtons
{

    /**
     * Генерация `Inline Keyboard Button` разделов
     * return [
     *   'text' => print_r($vehicle->toArray(), true),
     *   'reply_markup' => new InlineKeyboard(...$this->prepareKeyboard($rows)),
     * ];
     * @param $rows
     * @return array
     */
    public static function prepareKeyboard($rows): array
    {
        $array = [];

        $i = 0;
        $odd = true;
        $count = count($rows);
        while ($i <= $count) {
            $hasOne = !empty($rows[$i]);
            $hasTwo = $hasOne && !empty($rows[$i + 1]);

            if ($count >= 20) {
                if ($odd && $hasTwo && !empty($rows[$i + 2])) {
                    $array[] = [$rows[$i], $rows[$i + 1], $rows[$i + 2]];
                    $odd = false;
                    $i += 3;
                } else if ($hasTwo) {
                    $array[] = [$rows[$i], $rows[$i + 1]];
                    $odd = true;
                    $i += 2;
                } else if ($hasOne) {
                    $array[] = [$rows[$i]];
                    ++$i;
                } else {
                    break;
                }
            } else if ($hasTwo) {
                $array[] = [$rows[$i], $rows[$i + 1]];
                $i += 2;
            } elseif ($hasOne) {
                $array[] = [$rows[$i]];
                ++$i;
            } else {
                break;
            }
        }

        return $array;
    }

    /**
     * Формирование кнопок
     *
     * @param Telegram $telegram
     * @param $buttons
     * @param null $backBtn
     */
    public static function buildKeyboard(Telegram $telegram, $buttons, $backBtn = null): array
    {
        $option = [];
        if (count($buttons) % 2 == 0) {
            for ($i = 0; $i < count($buttons); $i += 2) {
                $option[] = array($telegram->buildKeyboardButton($buttons[$i]), $telegram->buildKeyboardButton($buttons[$i + 1]));
            }
        } else {
            for ($i = 0; $i < count($buttons) - 1; $i += 2) {
                $option[] = array($telegram->buildKeyboardButton($buttons[$i]), $telegram->buildKeyboardButton($buttons[$i + 1]));
            }
            $option[] = array($telegram->buildKeyboardButton(end($buttons)));
        }

        if ($backBtn) {
            $option[] = [$telegram->buildKeyboardButton($backBtn)];
        }

        return $option;
//        return $telegram->buildKeyBoard($option,  false,  true);

//        if (empty($image)) {
//            $content = array('chat_id' => $this->chatId, 'reply_markup' => $keyboard, 'text' => $text, 'parse_mode' => "HTML");
//            $this->telegram->sendMessage($content);
//        } else {
//            $content = array('chat_id' => $this->chatId, 'reply_markup' => $keyboard, 'photo' => $image, 'caption' => $text, 'parse_mode' => 'HTML');
//            $this->telegram->sendPhoto($content);
//        }
    }

}