<?php


namespace Mnv\Modules\Telegram\Emoji;

use Exception;

class TelegramSDKException extends Exception
{
    /**
     * Thrown when token is not provided.
     *
     * @param $tokenEnvName
     * @return static
     */
    public static function tokenNotProvided($tokenEnvName): self
    {
        return new static('Required "token" not supplied in config and could not find fallback environment variable '.$tokenEnvName.'');
    }
}