<?php

namespace Mnv\Modules\Telegram\Controllers;

use Mnv\Modules\Telegram\Helpers\GenerateInlineButtons;
use Mnv\Modules\Telegram\Models\AddingObject;
use Mnv\Modules\Telegram\Models\Categories;
use Mnv\Modules\Telegram\Telegram;

class CategoryAddingController
{
    private int $defaultSectionId = 2;

    private static $instance = null;

    /** @return CategoryAddingController|null */
    public static function init(): ?CategoryAddingController
    {
        if ( self::$instance == null )
            self::$instance = new CategoryAddingController();

        return self::$instance;
    }
    /**
     * @param Telegram $telegram
     * @param int $chatID
     * @return mixed
     */
    public function execute(Telegram $telegram, int $chatID)
    {
        if ($telegram->Callback_Query()) {
            $MessageID = $telegram->MessageID();
            $callbackData = $telegram->Callback_Data();

            $data = array_slice(explode('::', $callbackData), 1);
            $method = array_shift($data);
            $response = $method && method_exists($this, $method) ? $this->$method($telegram, $chatID, $data[0]) : $this->categories($telegram, $this->defaultSectionId);

            if (is_array($response)) {
                $response['chat_id'] = $chatID;
                $response['message_id'] = $MessageID;

                return $telegram->editMessageText($response);
            }

            return $telegram->sendMessage([
                'chat_id' => $chatID,
                'message_id' => $MessageID,
                'text' => 'Какая-то ошибка, увы...',
            ]);
        }

        return $telegram->sendMessage(array_merge([
            'chat_id' => $chatID
        ], $this->categories($telegram, $this->defaultSectionId)));
    }

    /**
     * Категории
     *
     * @param Telegram $telegram
     * @param int $sectionId
     * @return array|null
     */
    private function categories(Telegram $telegram, int $sectionId = 2): ?array
    {
        if (!$rows = Categories::getSections($sectionId, '/AddingObjects', 'subCategories')) {
            return null;
        }

        return [
            'text' => 'Выберите категорию для вашего объекта:',
            'reply_markup' => $telegram->buildInlineKeyBoard(GenerateInlineButtons::prepareKeyboard(...$rows)),
        ];
    }

    /**
     * Под категории
     *
     * @param Telegram $telegram
     * @param int $sectionId
     * @return array|null
     */
    public function subCategories(Telegram $telegram, int $chatID, int $sectionId = 2): ?array
    {
        if (!$rows = Categories::getSections($sectionId, '/AddingObjects', 'selectedCategory')) {
            return null;
        }

        $keyboards = GenerateInlineButtons::prepareKeyboard(...$rows);
        $keyboards[] = [$telegram->buildInlineKeyboardButton("◀ Назад к категориям", null, implode('::', ['/addcategory', 'categories', 2]))];

        return [
            'text' => 'Выберите направление вашего объекта',
            'reply_markup' => $telegram->buildInlineKeyBoard($keyboards),
        ];
    }


    public function selectedCategory(Telegram $telegram, int $chatID, int $sectionId = 2): array
    {
        $object = new AddingObject($chatID);
        if ($object->updateObject($chatID, $object->object_id, array('step_id' => 1, 'category_id' => $sectionId))) {
            return [
                'text' => "Введите описание объекта : $sectionId : $object->object_id",
            ];
        }
    }
}