<?php


namespace Mnv\Modules\Telegram\Commands;

use Mnv\Modules\Telegram\TelegramI18N;

/**
 * Class Commands
 * @package Mnv\Modules\Telegram\Commands
 */
class Commands
{
    public static string $lang;

    private static TelegramI18N $i18n;

    /**
     * @param $lang
     */
    public static function lang($lang)
    {
        self::$lang = $lang ?? 'ru';
        self::$i18n = new TelegramI18N();
        self::$i18n->loadLang(self::$lang);
    }

//    /**
//     * @param $index
//     * @return mixed
//     */
//    public static function getKeyboard($index)
//    {
//        $keyboards = [
//            'welcome' => [self::getMessageText('ru'), self::getMessageText('uz')],
//            'lang' =>  [self::getMessageText('ru'), self::getMessageText('uz')],
//            'contact' => array(
//                [self::getMessageText('send_contact')],
//            ),
//            'main' => array(
//                [self::getMessageText('search')],
//                [self::getMessageText('feedback'), self::getMessageText('leave_review')],
//                [self::getMessageText('add_object')],
//                [self::getMessageText('setting_btn')],
//            ),
//            'location' => array(
//                [self::getMessageText('send_location')],
//                [self::getMessageText('select_district')],
//                [self::getMessageText('interesting')],
//            ),
//            'feedback' => array(
//                [self::getMessageText('feedback_call')],
//                [self::getMessageText('send_contact')],
//                [self::getMessageText('main_btn')]
//            ),
//        ];
//
//        return $keyboards[$index];
//    }


    /**
     * @param $index
     * @return string
     */
    public static function getMessageText($index): string
    {
        return self::$i18n->get($index);
    }

}