<?php

namespace Mnv\Modules\Shop;

use Mnv\Core\DB;
use Mnv\Core\Utilities\Cookie\Session;

/**
 * Class Order
 * @package Mnv\Modules\Shop
 */
class Order extends Repository
{

    private static $table_baskets  = 'shop_baskets';
    private static $shop_orders  = 'shop_orders';

    public $success;

    public $orderId;
    public $order;

    public $token;

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Получение токена для получение заказа по `token`
     */
    public function checkBasket(): bool
    {
        if (Session::has('token')) {
            if (DB::init()->connect()->table(self::$table_baskets)->where('token', Session::get('token'))->get()) return true;
        }

        return false;
    }

    /**
     * Формирование номера телефона
     * @param $phone
     * @return string|null
     */
    public function formatPhoneNumber($phone): ?string
    {
        $phone = preg_replace('/[^0-9]/', '', $phone);
        return preg_replace('/([0-9]{3})([0-9]{2})([0-9]{3})([0-9]{2})([0-9]{2})/', '+$1 ($2) $3-$4-$5', $phone);
    }

    /**
     * Запись в таблицу заказа для продолжение и оплаты
     * @param array $order
     * @return bool
     */
    public function insertOrder(array $order, $basket): bool
    {
        $client = ['fullName' => $order['fullName'], 'contact' => $order['contact'], 'address' => 'г.' . $order['city'] . ', ул.' . $order['street'] . ', дом' . $order['houseNumber']];

        $data = [
            'basketId'      => $basket->basketId,
            'userId'        => $basket->userId,
            'client'        => json_encode($client, JSON_UNESCAPED_UNICODE),
            'message'       => $order['message'],
            'amount'        => $basket->amount,
            'createdBy'     => gmdate('Y-m-d H:i:s'),
            'datePayment'   => gmdate('Y-m-d H:i:s'),
            'payMethod'     => $order['payment_method'],
            'state'         => 1,
            'status'        => 'waiting',
            'click_trans_id'    => 0,
            'click_paydoc_id'   => 0
        ];

//        print_r($data);


        if ($this->orderId = DB::init()->connect()->table(self::$shop_orders)->insert($data)) {

            return true;
        }

        return false;
    }

    /**
     * Запись в таблицу заказа для продолжение и оплаты
     * @param array $order
     * @return bool
     */
    public function insertOneClickOrder(array $order, $basket): bool
    {
        $client = ['fullName' => 'Не указан', 'contact' => $order['contact'], 'address' => 'г. - Не указан , ул. - Не указан, дом - Не указан'];

        $data = [
            'basketId'      => $basket->basketId,
            'userId'        => $basket->userId,
            'client'        => json_encode($client, JSON_UNESCAPED_UNICODE),
            'message'       => $order['message'],
            'amount'        => $basket->amount,
            'createdBy'     => gmdate('Y-m-d H:i:s'),
            'datePayment'   => gmdate('Y-m-d H:i:s'),
            'payMethod'     => $order['payment_method'],
            'state'         => 1,
            'status'        => 'waiting',
            'click_trans_id'    => 0,
            'click_paydoc_id'   => 0
        ];

//        print_r($data);


        if ($this->orderId = DB::init()->connect()->table(self::$shop_orders)->insert($data)) {

            return true;
        }

        return false;
    }

    public function getOrder($orderId)
    {
        $this->order = DB::init()->connect()->table(self::$shop_orders)
            ->select('basketId, id, client, shop_orders.amount, createdBy, message, status, state, payMethod, products, quantity')
            ->usingJoin(self::$table_baskets,'basketId')->where('id', $orderId)->get();
//        print_r(DB::init()->connect()->getQuery());
        if (!empty($this->order->client)) $this->order->client = json_decode($this->order->client);
        if (!empty($this->order->products)) {
            $this->order->products = json_decode($this->order->products);
            foreach ($this->order->products as &$product) {
                $product->title = DB::init()->connect()->table('articles')->select('title')->where('articleId', $product->articleId)->getValue();
            }
        }
    }


}