<?php

namespace Mnv\Modules\Shop;

use Mnv\Core\DB;
use Mnv\Core\Locale\I18N;

use Mnv\Core\Utilities\Cookie\Session;
use Mnv\Core\Utilities\Base64\Throwable\EncodingError;


/**
 * Class Basket
 * @package Mnv\Modules\Shop
 */
class Basket extends Repository
{
    private static $table  = 'shop_baskets';

    public $basketId;


    public $basket;
    public $quantity;

    public function __construct()
    {
        parent::__construct();
    }

    public function checkingProductAddedToCart(): bool
    {
        if (Session::has('token') && Session::has('basket')) {
            if (DB::init()->connect()->table(static::$table)->select('basketId')->where('token', '=', Session::get('token'))->getValue())  return true;
        }

        return false;
    }

    public function getBasket()
    {
        $this->basket = DB::init()->connect()->table(static::$table)->select('*')->where('token', '=', Session::get('token'))->get();
//        print_r(DB::init()->connect()->getQuery());
    }

    /**
     * @return int
     */
    public function getCountProductsBasket(): int
    {
        if ($this->quantity = DB::init()->connect()->table(static::$table)->select('quantity')->where('token', '=', Session::get('token'))->getValue()) {
            return $this->quantity;
        }
        return 0;
    }

    /**
     * Добавление товара в корзину
     *
     * @param array $order
     * @return bool
     */
    public function addCart(array $order)
    {
        if (Session::has('token') && Session::has('basket')) {
            $this->getBasket();
            return $this->updateCart($order);
        } else {
            return $this->newCart($order);
        }
    }

    /**
     * Добавление нового товара в корзину
     *
     * @param array $order
     * @return bool
     */
    private function newCart(array $order): bool
    {
        /** устанавливаем и добавляем в базу session(token) */
        try {
            Session::set('token', self::createRandomString(20));
        } catch (EncodingError $e) {

        }

        /** собираем информацию о товаре в json */
        $newOrder = [
            'variantIds' => json_encode([$order['variantId']], JSON_UNESCAPED_UNICODE),
            'products' => json_encode([[
                'productId'     => $order['productId'],
                'quantity'      => $order['quantity'],
                'price'         => $order['price'],
                'amount'        => $order['amount'],
                'variantId'     => $order['variantId'],
                'variantName'   => $order['variantName'],
                'sku'           => $order['sku'],
            ]], JSON_UNESCAPED_UNICODE),
            'token'    => Session::get('token'),
            'quantity' => $order['quantity'],
            'amount'   => $order['amount']
        ];

//        print_r($newOrder);

        if ($this->basketId = DB::init()->connect()->table(static::$table)->insert($newOrder)) {
            Session::set('basket', $this->basketId);
            return true;
        }

        return false;
    }


    /**
     * Обновление товара в корзине
     *
     * @param $order
     */
    private function updateCart($order)
    {
        $checkProduct = false;
        $variantIds = array();
        $totalAmount = 0;
        $totalQuantity = 0;

        if (!empty($this->basket)) {
            $basketProducts = json_decode($this->basket->products, true);

            /** Ищем одинаковые товары */
            $product = new Product();
            foreach ($basketProducts as $key => $cart) {
                if ($cart['variantId'] == $order['variantId']) {

                    $product = $product->getVariant($order['variantId']);
                    if ($cart['variantId'] == $order['variantId']) {
                        $basketProducts[$key]['quantity'] += $order['quantity'];
                        $basketProducts[$key]['amount'] = number_format($basketProducts[$key]['price'] * $basketProducts[$key]['quantity'], 2, '.', '');
                        $checkProduct = true;
                    }

                    if (!empty($product->stock)) {
                        if ($product->stock <= $basketProducts[$key]['quantity']) {
                            return array('status' => 0, 'message' => I18N::locale("Доступное для покупки количество товара $product->stock шт...", "Sotib olish mumkin bo\'lgan tovarlar miqdori $product->stock ...", "Quantity of goods available for purchase $product->stock ..."));
                        }
                    }
                }
            }

            /** Если одинаковых товаров нет, то мы добавляем его d массив `$products` */
            if (!$checkProduct) {
                /** Далее создаем массив для отправки данных в котором отправляем , id продукта, Количество , id варианта и цвет */
                $basketProducts[] = [
                    'productId'     => $order['productId'],
                    'quantity'      => $order['quantity'],
                    'price'         => $order['price'],
                    'amount'        => number_format($order['amount'], 2, '.', ''),
                    'variantId'     => $order['variantId'],
                    'variantName'   => $order['variantName'],
                    'sku'           => $order['sku'],
                ];
            }

            foreach ($basketProducts as $product) {
                $variantIds[] = $product['variantId'];
                $totalAmount += $product['amount'];
                $totalQuantity += $product['quantity'];
            }

            /** Сюда запихиваем json массива который выше */
            $updateBasket = [
                'variantIds' => json_encode($variantIds, JSON_UNESCAPED_UNICODE),
                'products'  => json_encode($basketProducts, JSON_UNESCAPED_UNICODE),
                'amount'    => $totalAmount,
                'quantity'  => $totalQuantity,
            ];
//            print_r($updateBasket);
            if (DB::init()->connect()->table(self::$table)->where('token', '=', Session::get('token'))->update($updateBasket)) {
                return array('status' => 1, 'message' => I18N::locale('Товар добавлен в корзину...', 'Товар добавлен в корзину...', 'Товар добавлен в корзину...'));
            } else {
                return false;
            }
        } else {
            return $this->newCart($order);
        }
    }

    public function updateCountProductBasket($variantId, $quantity)
    {
        $totalAmount = 0;
        $totalQuantity = 0;

        if (!empty($this->basket)) {
            $products = json_decode($this->basket->products, true);

            /** Ищем одинаковые товары */
            foreach ($products as $key => $value) {
                if ($value['variantId'] == $variantId) {
                    // TODO: 1 проверить кол-во если пришел 0 то удалить элемент из массива
                    // TODO: 2 если больше 0 то обновить кол-во у продукта
                    // TODO: 3 перебрать весь массив
                    // TODO: 4 обновить запись в базе
//                    print_r($value);
                    if ($quantity == 0) {
                        unset($products[$key]);
                    } else {
                        $products[$key]['quantity'] = $quantity;
                        $products[$key]['amount'] = number_format($products[$key]['price'] * $products[$key]['quantity'], 2, '.', '');
                    }
                }
            }

            if (!empty($products)) {
                foreach ($products as $product) {
                    $totalAmount += $product['amount'];
                    $totalQuantity += $product['quantity'];
                }
                /** Сюда запихиваем json массива который выше */
                $updateBasket = [
                    'products' => json_encode($products, JSON_UNESCAPED_UNICODE),
                    'amount' => $totalAmount,
                    'quantity' => $totalQuantity,
                ];
//            print_r($updateBasket);
                if (DB::init()->connect()->table(self::$table)->where('token', '=', Session::get('token'))->update($updateBasket)) {
                    return array('status' => 1, 'message' => I18N::locale('Товар обновлен в корзину...', 'Товар обновлен в корзину...', 'Товар обновлен в корзину...'));
                } else {
                    return false;
                }
            } else {
                DB::init()->connect()->table(self::$table)->where('token', '=', Session::get('token'))->delete();
                Session::delete('basket');
                Session::delete('token');

                return true;
            }
        }
    }


    /**
     * @param $productId
     * @return bool
     */
    public function removeProductBasket($variantId): bool
    {
        $this->getBasket();
        $productsArr = array();
        $totalAmount = 0;
        $totalQuantity = 0;

        if (!empty($this->basket)) {
            $products = json_decode($this->basket->products, true);
            foreach ($products as $product) $productsArr[$product['variantId']] = $product;

            unset($productsArr[$variantId]);

            if (!empty($productsArr)) {
                foreach ($productsArr as $product) {
                    $totalAmount += $product['amount'];
                    $totalQuantity += $product['quantity'];
                }
                $updateBasket = [
                    'products'  => json_encode(array_values($productsArr), JSON_UNESCAPED_UNICODE),
                    'amount'    => $totalAmount,
                    'quantity'  => $totalQuantity,
                ];
//                print_r($updateBasket);
                DB::init()->connect()->table(self::$table)->where('token', '=', Session::get('token'))->update($updateBasket);
            } else {
                DB::init()->connect()->table(self::$table)->where('token', '=', Session::get('token'))->delete();
                Session::delete('basket');
                Session::delete('token');
            }
            return true;
        }

        return false;
    }

    public function removeProductAllBasket(): bool
    {
        if (Session::has('token') && Session::has('basket')) {
            if (DB::init()->connect()->table(self::$table)->where('token', '=', Session::get('token'))->delete()){
                Session::delete('basket');
                Session::delete('token');
            }
            return true;
        }
        return false;
    }

    /**
     * @return int|mixed|string|null
     */
    public function getTotalAmountBasket()
    {
        if (Session::has('token') && Session::has('basket')) {
            return DB::init()->connect()->table(self::$table)->select('amount')->where('token', '=', Session::get('token'))->getValue();
        }
        return 0;
    }


}