<?php

namespace Mnv\Modules\Maps;

use Countable;
use EmptyIterator;
use Mnv\Http\JsonResponse;
use Mnv\Modules\Maps\Exception\Error;
use Mnv\Modules\Maps\Exception\InvalidArgumentException;

use function response;
/**
 * Class YandexMaps
 * @package Mnv\Modules\Maps
 */
class YandexMaps
{

    private string $type = 'FeatureCollection';

    /** @var array|null */
    private array $items = [];

    /** @var YandexItems  */
    private YandexItems $collection;

    /** @var Error */
    private Error $error;

    /** @var bool  */
    private bool $isFilter = false;


    /**
     * YandexMaps constructor.
     * @param array $filter
     */
    public function __construct(array $filter = [])
    {
        $this->error        = new Error();
        $this->collection   = new YandexItems($filter);

        // если не пустой фильтр
        if (!empty($filter['info']) && $filter['info'] == 1) $this->isFilter = true;

        try {
            $this->objects();
        } catch (InvalidArgumentException $e) {
            return $this->error->toString();
        }
    }

    /**
     * Получение объектов из базы
     *
     * @throws InvalidArgumentException
     */
    private function objects(): void
    {
        // если по какой то причине пришел не массив
        if (!is_array($this->collection->items))
            throw InvalidArgumentException::create(2,'argument 0 is not an array');

        foreach ($this->collection->items as $item) {
//            $this->items[] = YandexItemStatic::getInstance()->getItem($item, $this->isFilter);
            $this->items[] = $this->returnItem($item);
        }
    }

    /**
     * Получить свойства/значения объекта
     *
     * @param $item
     * @return YandexItem
     */
    private function returnItem($item)
    {
        return new YandexItem($item, $this->isFilter);
//        return YandexItemStatic::getInstance()->getItem($item, $this->isFilter);
    }


    /**
     * Получить кол-во объектов в массиве
     *
     * @return int|null
     * @throws InvalidArgumentException
     */
    public function count(): ?int
    {
        if (!$this->items instanceof Countable && !is_iterable($this->items)) {
            throw InvalidArgumentException::create(2, 'countable or iterable');
        }

        if ($this->items instanceof Countable || is_array($this->items)) {
            return count($this->items);
        }

        if ($this->items instanceof EmptyIterator) {
            return 0;
        }

        return null;
    }

    /**
     * получить массив объектов
     *
     * @return array|null
     */
    public function get(): ?array
    {
        return $this->items;
    }

    public function result()
    {
        $response['type']       = $this->type;
        try {
            $response['count'] = $this->count();
        } catch (InvalidArgumentException $e) {
            $response['count'] = $this->error->toString();
        }
        $response['features']   = $this->get();

//        return $response;
        return response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
//        return response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE)->send();
//        return json_encode($response, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT);
    }


}
