<?php

namespace Mnv\Modules\Maps;

use Mnv\Core\DB;

/**
 * Class YandexItems
 * @package Mnv\Modules\Maps
 */
class YandexItems
{

    /** @var string */
    private string $_table = 'articles';

    /** @var string */
    private string $_fields = 'articleId AS id, sectionId, title, fileName, content, address, phone, workingHours, lat, lng';

    public ?array $items;

    public function __construct(array $filter = [])
    {
        $this->get($filter);
    }

    /**
     * Получение объектов из базы
     *
     * @param array $filter
     */
    private function get(array $filter): void
    {
        if (!empty($filter['coordinates']) && !empty($filter['distance'])) {

            $lat = $filter['coordinates'][0];
            $lng = $filter['coordinates'][1];
            DB::init()->connect()->select("(((acos(sin((".$lat."*pi()/180)) * sin((`lat`*pi()/180))+cos((".$lat."*pi()/180)) * cos((`lat`*pi()/180)) * cos(((".$lng."-`lng`)*pi()/180))))*180/pi())*60*1.1515*1.609344) as distance ")
                ->having('distance', '<', $filter['distance'])->orderBy('distance ASC');
        }

        $this->items = DB::init()->connect()->table($this->_table)->select($this->_fields)->where('typeContent', 'categorys')
//            ->where('status', 'visible')
//            ->orderBy('articleId DESC')
            ->limit(100000)->getAll();

//        print_r(DB::init()->connect()->getQuery());

//        return $this->items;
    }


}