<?php

namespace Mnv\Modules\Maps;

use Mnv\Modules\Maps\Params\YandexGeometry;
use Mnv\Modules\Maps\Params\YandexOptions;
use Mnv\Modules\Maps\Params\YandexProperties;

/**
 * Class YandexItem
 * @package Mnv\Modules\Maps
 */
class YandexItem
{
    /** @var string */
    public string $type = 'Feature';

    /** @var int */
    public int $id;

    /** @var YandexGeometry */
    public YandexGeometry $geometry;

    /** @var YandexProperties */
    public YandexProperties $properties;

    /** @var YandexOptions */
//    public YandexOptions $options;

    /** @var YandexItemInfo  */
    public YandexItemInfo $data;

    public function __construct($item, bool $isFilter = false)
    {
        $this->id           = $item->id;
        $this->geometry     = new YandexGeometry($item->lat, $item->lng);
        $this->properties   = new YandexProperties($item->title, $item->address, $item->phone, $item->lat, $item->lng);

//        $this->options      = new YandexOptions();
        if ($isFilter) {
            $this->data = new YandexItemInfo($item->id);
            $this->data->title      = $item->title;
            $this->data->content    = $item->content;
            $this->data->address    = $item->address;
            $this->data->phone      = $item->phone;
        }
    }



}