<?php

namespace Mnv\Modules\Maps;

use Mnv\Modules\Maps\Exception\InvalidArgumentException;

/**
 * Class YandexMaps
 * @package Mnv\Modules\Maps
 */
class YandexMaps extends GeoObject
{

    /** @var array|null  */
    private ?array $_items = [];
    /** @var array|null  */
    private ?array $_collection = [];

    /** @var bool  */
    private bool $_isFilter = false;

    /**
     * YandexMaps constructor.
     * @param array $filter
     */
    public function __construct(array $filter = [])
    {
        // если не пустой фильтр
        if (!empty($filter['info']) && $filter['info'] == 1) $this->_isFilter = true;

        $this->_collection = YandexDB::init($filter)->get();
        $this->generateGeoObjectCollection();
    }

    /**
     * Формирование массива
     */
    public function generateGeoObjectCollection()
    {
        foreach ($this->_collection as $item) {
            $this->_items[] = $this->generateObject($item);
        }
    }

    /**
     * Получить свойства/значения объекта
     *
     * @param $item
     * @return GeoObject
     */
    private function generateObject($item): GeoObject
    {
        return $this->setObject($item, $this->_isFilter);
    }

    /**
     * Получить кол-во объектов в массиве
     *
     * @return int|null
     */
    private function count(): ?int
    {
        if ($this->_items instanceof Countable || is_array($this->_items)) {
            return count($this->_items);
        }

        if ($this->_items instanceof EmptyIterator) {
            return 0;
        }

        return null;
    }


    public function get(): array
    {
        $response['type']       = 'FeatureCollection';
        $response['count']      = $this->count();
        $response['features']   = $this->_items;

        return $response;
    }


}
