<?php

namespace Mnv\Modules\Maps;

use Countable;
use EmptyIterator;
use Mnv\Core\DB;
use Mnv\Modules\Maps\Exception\InvalidArgumentException;

/**
 * Class GeoObjectCollection
 * @package Mnv\Modules\Maps
 */
//class GeoObjectCollection extends GeoObject implements Interfaces\GeoObjectCollection
class GeoObjectCollection
{

    /** @var array|null  */
    private ?array $_items = [];
    /** @var array|null  */
    private ?array $_collection = [];

    /** @var bool  */
    private bool $_isFilter = false;

    /**
     * YandexMaps constructor.
     * @param array $filter
     */
    public function __construct(array $filter = [])
    {
        // если не пустой фильтр
        if (!empty($filter['info']) && $filter['info'] == 1) $this->_isFilter = true;

        $this->_collection = YandexDB::init($filter)->get();
        $this->generateGeoObjectCollection();
    }

    /**
     * Формирование массива
     */
    public function generateGeoObjectCollection()
    {
        foreach ($this->_collection as $item)
            $this->_items[] = $this->generateObject($item);
    }

    /**
     * Получить свойства/значения объекта
     *
     * @param $item
     * @return GeoObject
     */
    private function generateObject($item): GeoObject
    {
        $geoObject = new GeoObject();
        return $geoObject->setObject($item, $this->_isFilter);
    }

    /**
     * Получить кол-во объектов в массиве
     *
     * @return int|null
     */
    public function count(): ?int
    {
        if ($this->_items instanceof Countable || is_array($this->_items)) {
            return count($this->_items);
        }

        if ($this->_items instanceof EmptyIterator) {
            return 0;
        }

        return null;
    }


    public function get($begin_time): \Mnv\Http\JsonResponse
    {

        $response['type']       = 'FeatureCollection';
        $response['count']      = $this->count();
        $response['features']   = $this->_items;
        $end_time = time() - 1272000000 + floatval(microtime()) - $begin_time;
        $response['time'] = $end_time;
//        return $response;
        return response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE)->send();
    }

}