<?php

namespace Mnv\Models\Telegram;

use Mnv\Core\DB;
use Mnv\Core\Files\Image\ImageSizes;

class TelegramMyMailings
{
    private static $_table   = 'telegram_mailing';
    private static $_files = 'files';

    public $mailings;
    public $mailing;
    public $mailingId;
    public $total;

    public function getMailingList()
    {
        $mailings = array(0 => "Выберите рассылку");
        $mailings += DB::init()->connect()->table(self::$_table)->select('id, name')->orderBy('id', 'DESC')->indexKey('id')->valueKey('name')->getAllIndexes();

        return $mailings;
    }

    public function getAll(): void
    {
        $this->mailings = DB::init()->connect()->table(self::$_table)->orderBy('id', 'DESC')->getAll();
    }

    public function total()
    {
        $this->total = DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }


    public function edit()
    {

        if (!empty($this->mailingId)) {
            $this->mailing = DB::init()->connect()->table(self::$_table)->where('id', $this->mailingId)->get();
            if (!empty($this->mailing->fileId) && $this->mailing->fileId > 0) $this->mailing->image = $this->get_image($this->mailing->fileId);
            $this->getManagerInfo();
        }
    }

    /**
     * Новый
     *
     * @param $mailing
     * @return bool
     */
    public function add($mailing): bool
    {
//        print_r($mailing);
        if ($this->mailingId = DB::init()->connect()->table(self::$_table)->insert((array)$mailing)) return true;

        return false;
    }

    /**
     * Обновление слайда
     *
     * @param $mailing
     * @return bool
     */
    public function update($mailing): bool
    {
        if (!empty($this->mailingId)) {
            DB::init()->connect()->table(self::$_table)->where('id', $this->mailingId)->update((array)$mailing);
            $this->edit();

            return true;
        }
        return false;
    }

    /**
     * удаление слайда
     *
     * @return bool
     */
    public function remove(): bool
    {
        if (!empty($this->mailingId)) {
            if (DB::init()->connect()->table(self::$_table)->where('id', $this->mailingId)->delete()) return true;
        }
        return false;
    }

    /**
     * Скрыть / показать
     *
     * @return array
     */
    public function status(): array
    {
        if (!empty($this->mailingId)) {
            if ($mailing = DB::init()->connect()->table(self::$_table)->where('id', $this->mailingId)->get()) {
                $mailingUpdate['status'] = ($mailing->status == 'visible') ? 'hidden' : 'visible';
                DB::init()->connect()->table(self::$_table)->where('id', $this->mailingId)->update($mailingUpdate);
                return array('data' => true, 'status' => $mailingUpdate['status']);
            }

            return array('data' => false);
        }

        return array('data' => false);
    }

    public function deleteImage($mailingId)
    {
        if (!empty($this->mailingId)) {
            DB::init()->connect()->table(self::$_table)->where('id', $this->mailingId)->update(['fileId' => 0]);
            return true;
        }
        return false;
    }

    /**
     * Получение картинок к слайду
     *
     * @param int $fileId
     * @return ImageSizes|null
     */
    public function get_image(int $fileId): ?ImageSizes
    {
        $image = null;
        if ($file = DB::init()->connect()->table(self::$_files)->where('fileId', $fileId)->get())
            $image = ImageSizes::init()->get(null, $file);

        return $image;
    }

    /**
     * получать информацию о пользователях, которые создали и изменили статью
     */
    protected function getManagerInfo()
    {
        if (isset($this->mailing->addedBy)) {
            $managers = DB::init()->connect()->table('users')->select('userId, loginName')->where('userId', $this->mailing->addedBy)->indexKey('userId')->getAllIndexes();
            $this->mailing->addedBy = empty($managers[$this->mailing->addedBy]) ? unknownUser() : $managers[$this->mailing->addedBy];
            $this->mailing->addedOn = adjustTime($this->mailing->addedOn, false, 'd.m.Y H:i');

        }
    }




}