<?php

namespace Mnv\Models;

use Mnv\Core\Mnv;
use PHPMailer\PHPMailer\PHPMailer;


/**
 * Class Subscribe
 * @package Mnv\Models
 */
class Subscribe extends Mnv
{

    private $_charset;
    private $_smtp_server;
    private $_smtp_user;
    private $_smtp_pass;
    private $_smtp_secure;
    private $_smtp_port;

    protected $subject;
    protected $htmlBody;
    protected $send;

    public function __construct()
    {
        parent::__construct();

        $this->_charset     = $this->config['charset'];
        $this->_smtp_server = $this->config['smtp_server'];
        $this->_smtp_user   = $this->config['smtp_user'];
        $this->_smtp_pass   = $this->config['smtp_pass'];
        $this->_smtp_secure = $this->config['smtp_secure'];
        $this->_smtp_port   = $this->config['smtp_port'];
    }

    /**
     * sendSMTP
     * @param $subject
     * @param $message
     * @return bool|string
     * @throws \Exception
     */
    public function sendSMTP($to, $subject, $message)
    {
        $this->subject = $this->validate($subject);
        $this->htmlBody = $message;

        $mail = new PHPMailer();
        $mail->isSMTP();
       // $mail->SMTPDebug = 1;
        $mail->CharSet    = $this->_charset;
        $mail->Host       = $this->_smtp_server;
        $mail->SMTPAuth   = true;
        $mail->Username   = $this->_smtp_user;
        $mail->Password   = $this->_smtp_pass;
        $mail->SMTPSecure = $this->_smtp_secure;
        $mail->Port       = $this->_smtp_port;

        $mail->isHTML(true);
        $mail->Subject = $this->subject;
        $mail->Body    = $this->htmlBody;
        $mail->setFrom($this->_smtp_user, $this->config['company_name']);
        $mail->addReplyTo($this->_smtp_user);
        $mail->addAddress($to, $this->config['company_name']);
        $mail->SMTPKeepAlive = true;


        if(!$mail->send()) {
            $this->errors = $mail->ErrorInfo;
            return $this->errors;
        } else {
            $mail->clearAllRecipients();
            $mail->clearAttachments();
            return true;
        }
    }


    /**
     * @param $data
     * @return string
     */
    public function validate($data)
    {
        $data = trim($data);
        $data = stripslashes($data);
        $data = htmlspecialchars(strip_tags($data, ENT_QUOTES));
        return $data;
    }

}