<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class Stats
 * @package Mnv\Models
 */
class Stats extends Mnv
{
    /**
     * Stats constructor.
     */
    public function __construct()
    {
        parent::__construct();

    }

    /**  StatsVisitors  */

    /**
     * StatsVisitors
     * @param string|null $dateStart
     * @param string|null $dateEnd
     * @param int|null $filterTypeId
     * @param string|null $domain
     * @param int $page
     * @return array|false|mixed|string
     */
    public function getStatsVisitors(?string $dateStart, ?string $dateEnd, ?int $filterTypeId, ?string $domain, int $page)
    {
        if (!empty($filterTypeId)) DB::init()->connect()->where('typeId', '=', $filterTypeId);
        if (!empty($domain)) {
            if($domain == 'unknown') $domain = '';
            DB::init()->connect()->where("REPLACE(SUBSTRING_INDEX(referer, '/', 3), 'www.', '')", '=', $domain);
        }

        return DB::init()->connect()->table('stats_visits')->select('visitorId, referer, firstVisitOn, COUNT(*) AS totalVisits')
            ->usingJoin('stats_visitors', 'visitorId')->usingJoin('stats_user_agents', 'userAgentId')
            ->where('visitDate', '>=', $dateStart)->where('visitDate', '<=', $dateEnd)->where('isBot', '=', 0)
            ->pagination($this->limit, $page)->orderBy('firstVisitOn', 'DESC')->groupBy('visitorId')->indexKey('visitorId')->getAllIndexes();

    }

    /**
     * @param string|null $dateStart
     * @param string|null $dateEnd
     * @param int|null $filterTypeId
     * @param string|null $domain
     * @return mixed|string|null
     */
    public function getTotalStatsVisitors(?string $dateStart, ?string $dateEnd, ?int $filterTypeId, ?string $domain)
    {
        if (!empty($filterTypeId)) DB::init()->connect()->where('typeId', '=', $filterTypeId);

        if (!empty($domain)) {
            if ($domain == 'unknown') $domain = '';
            DB::init()->connect()->where("REPLACE(SUBSTRING_INDEX(referer, '/', 3), 'www.', '')", '=', $domain);
        }

        return DB::init()->connect()->table('stats_visits')
            ->usingJoin('stats_visitors', 'visitorId')
            ->usingJoin('stats_user_agents', 'userAgentId')
            ->count('DISTINCT visitorId', 'count')
            ->where('visitDate', '>=', $dateStart)
            ->where('visitDate', '<=', $dateEnd)
            ->where('isBot', '=', 0)
            ->getValue();
    }


    public function getStatsVisitor($visitorId)
    {

//        $visitor =  DB::init()->connect()->table('stats_visitors', true)
//            ->join('stats_visits', 'stats_visitors.visitorId', '=', 'stats_visits.visitorId', 'LEFT ', true)
//            ->join('stats_user_agents', 'stats_visitors.userAgentId', '=', 'stats_user_agents.userAgentId', 'LEFT ', true)
//            ->where('stats_visitors.visitorId', $visitorId)
//            ->where('isFirst', '=', 1)
//            ->select('stats_visitors.visitorId, stats_visitors.firstVisitOn, stats_visitors.referer, stats_visitors.visitorIp, userAgent, isBot, visitId, typeId')
//            ->get();

// TODO: старый метод через join
// SELECT stats_visitors.visitorId, stats_visitors.firstVisitOn, stats_visitors.referer, stats_visitors.visitorIp, userAgent, isBot, visitId, typeId FROM ls_stats_visitors AS stats_visitors LEFT JOIN ls_stats_visits AS stats_visits ON stats_visitors.visitorId = stats_visits.visitorId LEFT JOIN ls_stats_user_agents AS stats_user_agents ON stats_visitors.userAgentId = stats_user_agents.userAgentId WHERE stats_visitors.visitorId = '132' AND isFirst = 1 LIMIT 1
//        (
//        [visitorId] => 132
//        [firstVisitOn] => 2022-05-28 16:51:12
//        [referer] => https://admin.shop.new/news/4.htm
//        [visitorIp] => ::1
//        [userAgent] => Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.5 Safari/605.1.15
//        [isBot] => 0
//        [visitId] => 23487
//        [typeId] => 2
//        )


        return DB::init()->connect()->table('stats_visitors')->select('visitorId, firstVisitOn, referer, visitorIp, userAgent, isBot, visitId, typeId')
            ->usingJoin('stats_visits', 'visitorId')->where('isFirst', '=', 1)
            ->usingJoin('stats_user_agents', 'userAgentId')->where('visitorId', $visitorId)
            ->get();
//        print_r( DB::init()->connect()->getQuery());
//        print_r($visitor);
//        return $visitor;

// TODO: новый метод через join
// SELECT visitorId, firstVisitOn, referer, visitorIp, userAgent, isBot, visitId, typeId FROM ls_stats_visitors JOIN ls_stats_visits USING(visitorId) JOIN ls_stats_user_agents USING(userAgentId) WHERE visitorId = '132' AND isFirst = 1 LIMIT 1
//        (
//        [visitorId] => 132
//        [firstVisitOn] => 2022-05-28 16:51:12
//        [referer] => https://admin.shop.new/news/4.htm
//        [visitorIp] => ::1
//        [userAgent] => Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.5 Safari/605.1.15
//        [isBot] => 0
//        [visitId] => 23487
//        [typeId] => 2
//        )

    }
    /**
     *
     *  'indexKey' => 'visitId'
     *
     * @param string|null $dateStart
     * @param string|null $dateEnd
     * @param int|null $filterTypeId
     * @param int|null $visitorId
     * @param int $page
     * @return array|null
     */
    public function getStatsVisits(?string $dateStart, ?string $dateEnd, ?int $filterTypeId, ?int $visitorId, int $page): ?array
    {

        if (!empty($filterTypeId)) DB::init()->connect()->where('typeId','=', $filterTypeId);

        return DB::init()->connect()->table('stats_visits')
            ->where('visitDate','>=', $dateStart)
            ->where('visitDate','<=', $dateEnd)
            ->where('visitorId','=', $visitorId)
            ->pagination($this->limit, $page)
            ->orderBy('visitDate', 'DESC')->indexKey('visitId')->getAllIndexes();
    }

    public function getTotalStatsVisits(?string $dateStart, ?string $dateEnd, ?int $filterTypeId, ?int $visitorId)
    {

        if (!empty($filterTypeId)) DB::init()->connect()->where('typeId','=', $filterTypeId);

        return DB::init()->connect()->table('stats_visits')->count('*', 'count')
            ->where('visitDate','>=', $dateStart)
            ->where('visitDate','<=', $dateEnd)
            ->where('visitorId','=', $visitorId)
            ->getValue();
    }

    /**
     * @param array|null $visits
     * @return array|null
     */
    public function sectionVisits(?array $visits): ?array
    {
        if ($sectionVisits = DB::init()->connect()->table('stats_section_visits')->select('visitId, sectionId, name, url')
            ->usingJoin('sections', 'sectionId')->in('visitId', array_keys($visits))->indexKey('visitId')->getAllIndexes()) {

            foreach ($sectionVisits as $visitId => $visit) {
                $visits[$visitId]->visitId      = $visit->visitId;
                $visits[$visitId]->sectionId    = $visit->sectionId;
                $visits[$visitId]->name         = $visit->name;
                $visits[$visitId]->url          = $visit->url;
            }

            return $visits;
        }

        return null;
    }

    /**
     * @param array|null $visits
     * @return array|null
     */
    public function articleVisits(?array $visits): ?array
    {
        if ($articleVisits = DB::init()->connect()->table('stats_article_visits')->select('visitId, articleId, title, url')->usingJoin('articles', 'articleId')
            ->in('visitId', array_keys($visits))->indexKey('visitId')->getAllIndexes()) {

            foreach ($articleVisits as $visitId => $visit) {
                $visits[$visitId]->visitId      = $visit->visitId;
                $visits[$visitId]->articleId    = $visit->articleId;
                $visits[$visitId]->title        = $visit->title;
                $visits[$visitId]->url          = $visit->url;
            }

            return $visits;
        }
        return null;
    }

    /**
     * @param array|null $visits
     * @return array|null
     */
    public function searchVisits(?array $visits): ?array
    {
        if ($searchVisits = DB::init()->connect()->table('stats_search_visits')->select('visitId, searchQuery, searchPage')->in('visitId', array_keys($visits))->indexKey('visitId')->getAllIndexes()) {
            foreach ($searchVisits as $visitId => $visit) {
                $visits[$visitId]->visitId      = $visit->visitId;
                $visits[$visitId]->searchQuery  = $visit->searchQuery;
                $visits[$visitId]->searchPage   = $visit->searchPage;
            }

            return $visits;
        }
        return null;
    }

    /**
     * @param array|null $visits
     * @return array|null
     */
    public function errorVisits(?array $visits): ?array
    {
        if ($errorVisits = DB::init()->connect()->table('stats_error_visits')
            ->select('visitId, errorCode, requestUri, referer')->in('visitId', array_keys($visits))->indexKey('visitId')->getAllIndexes()) {

            foreach ($errorVisits as $visitId => $visit) {
                $visits[$visitId]->visitId = $visit->visitId;
                $visits[$visitId]->errorCode = $visit->errorCode;
                $visits[$visitId]->requestUri = $visit->requestUri;
                $visits[$visitId]->referer = $visit->referer;
                $parseReferer = parseReferer($visit->referer);
                if (isset($parseReferer['refererUrl'])) $visits[$visitId]->refererUrl = $parseReferer['refererUrl'];
                if (isset($parseReferer['refererWebsite'])) $visits[$visitId]->refererWebsite = $parseReferer['refererWebsite'];

            }

            return $visits;
        }
        return null;
    }

    /**
     * @param array|null $visits
     * @return array|null
     */
    public function rssVisits(?array $visits): ?array
    {
        global $SECTIONS;

        if ($rssVisits = DB::init()->connect()->table('stats_rss_visits')->select('*')->in('visitId', array_keys($visits))->indexKey('visitId')->getAllIndexes()) {

            foreach ($rssVisits as $visitId => $visit) {
                if (!empty($SECTIONS[$visit->sectionId])) $visit->section = $SECTIONS[$visit->sectionId];
                $visits[$visitId] += $visit;
            }
            return $visits;
        }
        return null;
    }

    /**
     * @param $a
     * @param $b
     * @return int
     */
    public function sortByVisitDate(&$a, &$b)
    {
        if ($a == $b) return 0;
        return (strtotime($a->visitDate) < strtotime($b->visitDate)) ? 1 : -1;
    }

    /**
     * @param $visits
     * @param $visitId
     * @return array|false|mixed|string
     */
    public function getVisitInfo($visits, $visitId)
    {

        if (!empty($visits[$visitId])) return $visits[$visitId];

        $visit = DB::init()->connect()->table('stats_visits')->where('visitId', $visitId)->get();
        $visit->typeName  =  lang('visitTypes:'.$visit->typeId);
        $visit->visitDate =  langDate(adjustTime($visit->visitDate, false, 'd.m, H:i:s'));

        switch($visit->typeId) {
            case 1:
                break;
            case 2:
                if ($section = DB::init()->connect()->table('stats_section_visits')->select('sectionId, name, url')->usingJoin('sections', 'sectionId')->where('visitId', $visitId)->get()) {

                    $visit->sectionId = $section->sectionId;
                    $visit->name = $section->name;
                    $visit->url = $section->url;
                }
                break;
            case 3:
                if ($article = DB::init()->connect()->table('stats_article_visits')->select('articleId, title, url')->usingJoin('articles', 'articleId')->where('visitId', $visitId)->get()) {

                    $visit->articleId = $article->articleId;
                    $visit->title = $article->title;
                    $visit->url = $article->url;
                }
                break;
            case 4:
                $search = DB::init()->connect()->table('stats_search_visits')->select('searchQuery, searchPage')->where('visitId', $visitId)->get();
                $visit->searchQuery = $search->searchQuery;
                $visit->searchPage = $search->searchPage;
                break;
            case 6:
                if ($error = DB::init()->connect()->table('stats_error_visits')->select('visitId, errorCode, requestUri, referer')->where('visitId', $visitId)->get()) {
                    $visit->visitId = $error->visitId;
                    $visit->errorCode = $error->errorCode;
                    $visit->requestUri = $error->requestUri;

                    $visit->referer = (isset($visit->referer) || !empty($visit->referer)) ? parseReferer($visit->referer) : '';
                }
                break;
            case 7:
                $visit += DB::init()->connect()->table('stats_rss_visits')->select('*')->where('visitId', $visitId)->get();
                if(!empty($SECTIONS[$visit->sectionId])) $visit->section = $SECTIONS[$visit->sectionId];
                break;

        }

        return $visit;
    }



    /**  StatsErrors  */

    /**
     * StatsErrors
     * @param string|null $dateStart
     * @param string|null $dateEnd
     * @param int|null $filterErrorCode
     * @param int $page
     * @return array|false|mixed|string
     */
    public function getStatsErrors(?string $dateStart, ?string $dateEnd, ?int $filterErrorCode, int $page)
    {

        if (!empty($filterErrorCode)) DB::init()->connect()->where('errorCode', $filterErrorCode);

        return DB::init()->connect()->table('stats_visits')->select('requestUri, referer, errorCode, COUNT(*) AS totalVisits')
            ->usingJoin('stats_error_visits','visitId')->where('visitDate', '>=', $dateStart)
            ->where('visitDate', '<=', $dateEnd)->where('typeId', '=', 6)
            ->pagination($this->limit, $page)->orderBy('totalVisits', 'DESC')->groupBy('requestUri')->getAll();
    }

    /**
     * @param string|null $dateStart
     * @param string|null $dateEnd
     * @param int|null $filterErrorCode
     * @return mixed|string|null
     */
    public function getTotalStatsErrors(?string $dateStart, ?string $dateEnd, ?int $filterErrorCode)
    {
        if (!empty($filterErrorCode)) DB::init()->connect()->where('errorCode', $filterErrorCode);
        return DB::init()->connect()->table('stats_visits')->count('DISTINCT requestUri', 'totalVisits')
            ->usingJoin('stats_error_visits','visitId')
            ->where('visitDate', '>=', $dateStart)
            ->where('visitDate', '<=', $dateEnd)
            ->where('typeId', '=', 6)
            ->getValue();
    }


    /**
     * StatsError
     * @param string|null $dateStart
     * @param string|null $dateEnd
     * @param string|null $requestUri
     * @param int $page
     * @return array|false|mixed|string
     */
    public function getStatsError(?string $dateStart, ?string $dateEnd, ?string $requestUri, $page)
    {
        return DB::init()->connect()->table('stats_visits')->usingJoin('stats_error_visits', 'visitId')
            ->where('visitDate','>=', $dateStart)->where('visitDate','<=', $dateEnd)->where('requestUri','=', $requestUri)
            ->pagination($this->limit, $page)->orderBy('visitDate', 'DESC')->indexKey('visitId')->getAllIndexes();
    }

    /**
     * @param string|null $dateStart
     * @param string|null $dateEnd
     * @param string|null $requestUri
     * @return mixed|string|null
     */
    public function getTotalStatsError(?string $dateStart, ?string $dateEnd, ?string $requestUri)
    {
        return DB::init()->connect()->table('stats_visits')->count('*', 'count')->usingJoin('stats_error_visits', 'visitId')
            ->where('visitDate','>=', $dateStart)->where('visitDate','<=', $dateEnd)->where('requestUri','=', $requestUri)->getValue();
    }


    /**  StatsBots  */

    /**
     * StatsBots
     * @param string|null $dateStart
     * @param string|null $dateEnd
     * @param int|null $filterTypeId
     * @param int $page
     * @return array|mixed|null
     */
    public function getStatsBots(?string $dateStart, ?string $dateEnd, ?int $filterTypeId, int $page)
    {

        if(!empty($filterTypeId)) DB::init()->connect()->where('typeId','=', $filterTypeId);

        return DB::init()->connect()->table('stats_visits')->select('visitorId, userAgent, COUNT(*) AS totalVisits')
            ->usingJoin('stats_visitors', 'visitorId')->usingJoin('stats_user_agents', 'userAgentId')
            ->where('visitDate','>=', $dateStart)->where('visitDate','<=', $dateEnd)->where('isBot','=', 1)
            ->pagination($this->limit, $page)->orderBy('totalVisits', 'DESC')->groupBy('visitorId')->indexKey('visitorId')->getAllIndexes();
    }

    /**
     * @param string|null $dateStart
     * @param string|null $dateEnd
     * @param int|null $filterTypeId
     * @return mixed|string|null
     */
    public function getTotalStatsBots(?string $dateStart, ?string $dateEnd, ?int $filterTypeId)
    {
        if (!empty($filterTypeId)) DB::init()->connect()->where('typeId','=', $filterTypeId);
        return DB::init()->connect()->table('stats_visits')->count('DISTINCT visitorId', 'totalVisits')
            ->usingJoin('stats_visitors', 'visitorId')->usingJoin('stats_user_agents', 'userAgentId')
            ->where('visitDate','>=', $dateStart)->where('visitDate','<=', $dateEnd)->where('isBot','=', 1)->getValue();
    }


    /**  StatsReferer  */

    /**
     * StatsBots
     * @param string|null $dateStart
     * @param string|null $dateEnd
     * @param int|null $filterTypeId
     * @param int $page
     * @return array|mixed|null
     */
    public function getStatsReferer(?string $dateStart, ?string $dateEnd, ?int $filterTypeId, int $page)
    {

        if (!empty($filterTypeId)) DB::init()->connect()->where('typeId', '=', $filterTypeId);

        return DB::init()->connect()->table('stats_visits')->select("REPLACE(SUBSTRING_INDEX(referer, '/', 3), 'www.', '') AS domain")->count('DISTINCT visitorId', 'totalVisitors')
            ->usingJoin('stats_visitors', 'visitorId')->usingJoin('stats_user_agents', 'userAgentId')
            ->where('visitDate', '>=', $dateStart)->where('visitDate', '<=', $dateEnd)->where('isBot', '=', 0)
            ->pagination($this->limit, $page)->orderBy('totalVisitors', 'DESC')->groupBy('domain')->getAll();
    }

    /**
     * @param string|null $dateStart
     * @param string|null $dateEnd
     * @param int|null $filterTypeId
     * @return mixed|string|null
     */
    public function getTotalStatsReferer(?string $dateStart, ?string $dateEnd, ?int $filterTypeId)
    {
        if (!empty($filterTypeId)) DB::init()->connect()->where('typeId','=', $filterTypeId);
        return DB::init()->connect()->table('stats_visits')->count("DISTINCT REPLACE(SUBSTRING_INDEX(referer, '/', 3), 'www.', '')")
            ->usingJoin('stats_visitors', 'visitorId', 'LEFT ')->usingJoin('stats_user_agents', 'userAgentId', 'LEFT ')
            ->where('visitDate', '>=', $dateStart)->where('visitDate', '<=', $dateEnd)->where('isBot', '=', 0)->getValue();
    }

    /**
     * Обновить статистику если были посещения
     */
    public function updateStatsCacheDaily()
    {
        /** найти самую последнюю дату */
        $firstDate = DB::init()->connect()->table('stats_cache_daily')->max('cacheDate', 'cacheDate')->get();
        $firstDate = $firstDate->cacheDate;

        if (empty($firstDate)) {
            $firstDate =  DB::init()->connect()->table('stats_visits')->min('visitDate', 'visitDate')->get();
            $firstDate = $firstDate->visitDate;
        }

        /* нахождение общего количества дней */
        $totalDays = intval((strtotime(adjustTime(gmNow())) - strtotime($firstDate)) / (60 * 60 * 24));

        /** запрашивать данные за каждый день */
        if(!empty($firstDate)) for($i = 0; $i <= $totalDays; $i++) {
            $cacheDay = array();
            $cacheDay['cacheDate'] = date('Y-m-d', strtotime("$firstDate $i days"));

            $startDate = adjustTime($cacheDay['cacheDate'], true);
            $endDate   = date('Y-m-d H:i:s', strtotime("$startDate +1 day -1 second"));

            /** новые и вернувшиеся посетители */
            $visitors = $this->visitors($startDate, $endDate);
            $cacheDay['newVisitors']    = empty($visitors[0]) ? 0 : $visitors[0];
            $cacheDay['retVisitors']    = empty($visitors[1]) ? 0 : $visitors[1];

            /** посещения по типу */
            $visits = $this->visits($startDate, $endDate);
            $cacheDay['sectionVisits']  = empty($visits[2]) ? 0 : $visits[2];
            $cacheDay['articleVisits']  = empty($visits[3]) ? 0 : $visits[3];
            $cacheDay['searchVisits']   = empty($visits[4]) ? 0 : $visits[4];
            $cacheDay['errorVisits']    = empty($visits[6]) ? 0 : $visits[6];
            $cacheDay['rssVisits']      = empty($visits[7]) ? 0 : $visits[7];


            /** посещения по времени создания страницы */
            $genTimes = $this->genTimes($startDate, $endDate);
            $cacheDay['pageGenTime100'] = empty($genTimes[0]) ? 0 : $genTimes[0];
            $cacheDay['pageGenTime250'] = empty($genTimes[1]) ? 0 : $genTimes[1];
            $cacheDay['pageGenTime500'] = empty($genTimes[2]) ? 0 : $genTimes[2];
            $cacheDay['pageGenTime1000'] = empty($genTimes[3]) ? 0 : $genTimes[3];
            $cacheDay['pageGenTime2000'] = empty($genTimes[4]) ? 0 : $genTimes[4];
            $cacheDay['pageGenTimeMore'] = empty($genTimes[5]) ? 0 : $genTimes[5];

            DB::init()->connect()->table('stats_cache_daily')->replace($cacheDay);
        }
    }


    /**
     * новые и вернувшиеся посетители
     *
     * 'indexKey'=>'isReturning', 'valueKey'=>'totalVisitors'
     *
     * @param $startDate
     * @param $endDate
     * @return array
     */
    private function visitors($startDate, $endDate)
    {
        $visitors = null;
        DB::init()->connect()->where('visitDate','>=', $startDate);
        DB::init()->connect()->where('visitDate','<=', $endDate);
        DB::init()->connect()->where('isBot','=', 0);

//        DB::init()->connect()->usingJoin('stats_visitors AS svs', 'visitorId','LEFT ');
//        DB::init()->connect()->usingJoin('stats_user_agents', 'userAgentId', 'LEFT ');
//        DB::init()->connect()->count('DISTINCT svs.visitorId', 'totalVisitors');
//        DB::init()->connect()->select("TO_DAYS('$startDate') - TO_DAYS(firstVisitOn) >= 1 AS isReturning");


        $visitorsArr = DB::init()->connect()->table('stats_visits')
            ->usingJoin('stats_visitors', 'visitorId', 'LEFT ')
            ->usingJoin('stats_user_agents', 'userAgentId', 'LEFT ')
            ->select("TO_DAYS('$startDate') - TO_DAYS(firstVisitOn) >= 1 AS isReturning")
            ->count('DISTINCT visitorId', 'totalVisitors')
            ->groupBy('isReturning')
            ->getAll();

        foreach ($visitorsArr as $item) $visitors[$item->isReturning] = $item->totalVisitors;

        return $visitors;
    }

    /**
     * посещения по типу
     *
     * 'indexKey'=>'typeId', 'valueKey'=>'totalVisits'
     *
     * @param $startDate
     * @param $endDate
     * @return array|null
     */
    private function visits($startDate, $endDate)
    {
        $visits = null;

        DB::init()->connect()->where('visitDate','>=', $startDate);
        DB::init()->connect()->where('visitDate','<=', $endDate);
        DB::init()->connect()->where('isBot','=', 0);

        DB::init()->connect()->usingJoin('stats_visitors', 'visitorId','LEFT ');
        DB::init()->connect()->usingJoin('stats_user_agents', 'userAgentId', 'LEFT ');
        if ($visitsArr = DB::init()->connect()->table('stats_visits')->select('typeId')->count('*','totalVisits')->groupBy('typeId')->getAll()) {
            foreach ($visitsArr as $item) $visits[$item->typeId] = $item->totalVisits;
        }

        return $visits;
    }


    /**
     * посещения по времени создания страницы
     *
     * 'indexKey'=>'pgtGroup', 'valueKey'=>'totalVisits'
     *
     * @param $startDate
     * @param $endDate
     * @return array
     */
    private function genTimes($startDate, $endDate)
    {
        $genTimes = null;

        DB::init()->connect()->where('visitDate','>=',$startDate);
        DB::init()->connect()->where('visitDate','<=',$endDate);
        DB::init()->connect()->groupBy('pgtGroup');
        DB::init()->connect()->select('INTERVAL(loadTime * 1000, 100, 250, 500, 1000, 2000) AS pgtGroup');

        if ($genTimesArr = DB::init()->connect()->table('stats_visits')->count( '*', 'totalVisits')->groupBy('pgtGroup')->getAll()) {
            foreach ($genTimesArr as $item) $genTimes[$item->pgtGroup] = $item->totalVisits;

            //  print_r(DB::init()->connect()->getQuery());

            return $genTimes;
        }
        return null;
    }

    /** СТАТИСТИКА СКАЧИВАНИИЙ */
    public function getModels(): array
    {
        $newModels = array('' => 'Выберите модель');
        $models = DB::init()->connect()->table('sections')->select('sectionId, name')->where('parentId', 2)->orderBy('sectionId')->indexKey('sectionId')->getAllIndexes();
        foreach ($models as $modelId => $model) $newModels[$modelId] = $model->name;

        return $newModels;
    }

    public function getStartDate()
    {
        $dateStart = '2020-01-01';
        $minDownloadDate = DB::init()->connect()->table('stats_download')->min('downloadDate', 'downloadDate')->get();
        if ($minDownloadDate->downloadDate) $dateStart = $minDownloadDate->downloadDate;

        return $dateStart;
    }

    public function getStatsDays(): array
    {
        $newDays = [];
        $days = DB::init()->connect()->table('stats_download')->select('downloadDate')->orderBy('downloadDate DESC')->groupBy('downloadDate')->indexKey('downloadDate')->getAllIndexes();
        foreach ($days as $key => $day) $newDays[$key] = $day->downloadDate;

        return $newDays;
    }

    // SELECT downloadDate, modelId, downloadType, COUNT(*) AS totalDownloads
    // FROM ls_stats_download
    // WHERE (downloadDate BETWEEN '2022-08-13' AND '2022-08-14 17:46:48') AND downloadType = 'prices'
    // GROUP BY downloadDate, modelId
    // ORDER BY downloadDate DESC
    public function getStatsDownloads($dateStart, $dateEnd, $modelId, $downloadType)
    {
        /* показать таблицу */
//        DB::init()->connect()->where('downloadDate', '>=', $dateStart);
//        DB::init()->connect()->where('downloadDate', '<=', $dateEnd);

        if (!empty($modelId) && $modelId > 0) DB::init()->connect()->where('modelId', $modelId);

        DB::init()->connect()->between('downloadDate', $dateStart, $dateEnd);
        $downloads = DB::init()->connect()->table('stats_download')->select('downloadDate, modelId, downloadType')->count('*', 'totalDownloads')
            ->where('downloadType', $downloadType)->orderBy('downloadDate', 'DESC')->groupBy('modelId')->getAll();
//        print_r(DB::init()->connect()->getQuery());

        foreach ($downloads as &$download) {
            $download->modelName = DB::init()->connect()->table('sections')->select('name')->where('sectionId', $download->modelId)->getValue();
        }
        
        return $downloads;
    }

//    public function getStatsDownloads($dateStart, $dateEnd)
//    {
//        /* показать таблицу */
////        DB::init()->connect()->where('downloadDate', '>=', $dateStart);
////        DB::init()->connect()->where('downloadDate', '<=', $dateEnd);
//        DB::init()->connect()->between('downloadDate', $dateStart, $dateEnd);
//        $downloads = DB::init()->connect()->table('stats_download')->select('downloadDate, modelId, downloadType')->orderBy('downloadDate', 'DESC')->getAll();
//
//        return $downloads;
//    }
}