<?php

namespace Mnv\Models\Socials;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

class Socials extends Mnv
{
    private static $_table = 'socials';

    public $socials;
    public $social;
    public $socialId;

    public $total;

    /**
     * SocialsAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Получение всех социальных сетей
     */
    public function getAll()
    {
        $this->socials = DB::init()->connect()->table(self::$_table)->select('*')->orderBy('orderBy', 'asc')->limit($this->limit)->getAll();
        foreach($this->socials as $socialId => $social) $this->socials[$socialId]->status = lang('general:statuses:'.$this->socials[$socialId]->status);

    }

    /**
     * Редактирование социальной сети
     */
    public function edit(): void
    {

        if (!empty($this->socialId))
            $this->social = DB::init()->connect()->table(self::$_table)->where('socialId', $this->socialId)->get();
    }

    /**
     * Добавление социальной сети
     *
     * @param $social
     * @return bool
     */
    public function add($social): bool
    {
        if (!empty($social)) {
            $this->socialId = DB::init()->connect()->table(self::$_table)->insert((array)$social);

            $this->edit();

            return true;
        }

        return false;
    }

    /**
     * Обновление социальной сети
     *
     * @param $social
     * @return bool
     */
    public function update($social): bool
    {
        if (!empty($this->socialId)) {
            if (DB::init()->connect()->table(self::$_table)->where('socialId', $this->socialId)->update((array)$social)) {
                $this->edit();

                return true;
            }
        }

        return false;
    }


    /**
     * Удаление
     *
     * @return bool
     */
    public function remove(): bool
    {
        if (!empty($this->socialId)) {
            if (DB::init()->connect()->table(self::$_table)->where('socialId', $this->socialId)->delete()) return true;
        }

        return false;
    }

    public function status(): array
    {
        if (!empty($this->socialId)) {
            if ($social = DB::init()->connect()->table(self::$_table)->where('socialId', $this->socialId)->get()) {
                $socialUpdate['status'] = ($social->status == 'visible') ? 'hidden' : 'visible';
                DB::init()->connect()->table(self::$_table)->where('socialId', $this->socialId)->update($socialUpdate);
                return array('data' => true, 'status' => $socialUpdate['status']);
            }

            return array('data' => false);
        }

        return array('data' => false);
    }
    /**
     * Сортировка
     *
     * @param $socialIds
     */
    public function reorder($socialIds)
    {
        $i = 0;
        foreach ($socialIds as $socialId) {
            $i++;
            DB::init()->connect()->table(self::$_table)->where('socialId', $socialId)->update(['orderBy' => $i]);
        }
//
//        foreach ($socialIds as $i => $socialId) {
//            DB::init()->connect()->table(self::$_table)->where('socialId', $ids[$i])->update(['orderBy' => $socialId]);
//        }

    }

    /**
     * Проверка на существование во избежание дублирования
     * isFileName
     *
     * @param $fileName
     * @return bool
     */
    public function isFileName($fileName): bool
    {
        if (!empty($this->socialId)) {
            DB::init()->connect()->where('socialId', '<>', $this->socialId);
        }
        if (!empty($fileName)) $fileName = strtolower($fileName);
        if (DB::init()->connect()->table(self::$_table)->select('socialId')->where('LOWER(fileName)', $fileName)->get()) return false;

        return true;
    }

}