<?php

namespace Mnv\Models\Sections;


use Mnv\Core\DB;

/**
 * Class Sections
 * @package System
 */
class Sections extends SectionAbstract implements SectionInterface
{
    private static $_table          = 'sections';
    private static $_table_images   = 'section_images';
    private static $_files          = 'files';
    private static $_table_articles = 'articles';
    private static $_table_comments = 'comments';

    private $fields = array('sectionId, parentId, sortOrder, name, alias, topMenu, fileName, url, status, typeContent, type');

    /**
     * Sections constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }
    /**
     * Получение всех разделов
     *
     * @param int $parentId
     */
    public function getSections(int $parentId = 0): void
    {
        global $SECTIONS;

        $this->getAll($parentId);

        for ($i = 0; $i < count($this->sections); $i++) {
            $this->sections[$i]->statusName      = lang('sections:statuses:'.$this->sections[$i]->status);
            $this->sections[$i]->typeName        = lang('sections:types:'.$this->sections[$i]->type);
            $this->sections[$i]->typeContentName = lang('sections:typeContents:'.$this->sections[$i]->typeContent);

            if (($this->page > 1 && $i == 0) || (($i - $this->limit >= 0) && ($i == count($this->sections) - 1))) $this->sections[$i]->isHidden = true;
            if (!empty($SECTIONS[$this->sections[$i]->sectionId]->children)) $this->sections[$i]->hasSubsections = true;
        }
    }

    /**
     * Получение кол-во разделов
     *
     * @param int $parentId
     */
    public function total(int $parentId = 0): void
    {
        $this->getCountSections($parentId);
    }

    /**
     * Редактирование и добавление раздела
     * @param int $sectionId
     */
    public function edit(int $sectionId)
    {
        if (!empty($sectionId)){
            /** получение раздела */
            $this->getSection($sectionId);
            /** получать информацию о пользователе, который создал или редактировал раздела */
            $this->getManagerInfo();
            /** получение картинок раздела */
            $this->getFiles();
        }
    }

    /**
     * Проверка fileName на совпадение главной страницы
     *
     * @param string $fileName
     * @param $sectionId
     *
     *
     */
    public function isFileNamePage(string $fileName, $sectionId = null): ?string
    {
        $fileName = strtolower($fileName);
        if (empty($sectionId)) {
            if ($fileName = DB::init()->connect()->table(self::$_table)->select('fileName')->where('LOWER(fileName)', $fileName)->getValue()) return $fileName;
        } else {
            if ($fileName = DB::init()->connect()->table(self::$_table)->select('fileName')->where('sectionId','<>', $sectionId)->where('LOWER(fileName)', $fileName)->getValue()) return $fileName;
        }

        return null;
    }
    /**
     * Проверка на совпадение `fileName` и получение `fileName`
     *
     * @param string $fileName
     * @param null $sectionId
     * @param int $parentId
     *
     * @return string|null
     */
    public function isFileNameSection(string $fileName, $sectionId = null, $parentId = 0): ?string
    {
        $fileName = strtolower($fileName);
        if (empty($sectionId)) {
            if ($fileName = DB::init()->connect()->table(self::$_table)->select('fileName')->where('parentId', $parentId)->where('LOWER(fileName)', $fileName)->getValue()) return $fileName;
        } else {
            if ($fileName = DB::init()->connect()->table(self::$_table)->select('fileName')->where('sectionId','<>', $sectionId)->where('parentId', $parentId)->where('LOWER(fileName)', $fileName)->getValue()) return $fileName;
        }

        return null;
    }
    /**
     * Проверка, существует ли у раздела подразделы или статьи
     * @param $sectionId
     * @param $type
     * @return bool
     */
    public function isSectionType($sectionId, $type)
    {
        if ($type == 'plain') {
            if (DB::init()->connect()->table(self::$_table)->select('sectionId')->where('parentId','=', $sectionId)->getValue()) return false;
            if (DB::init()->connect()->table(self::$_table_articles)->select('sectionId')->where('sectionId','=', $sectionId)->getValue()) return false;
        }
        return true;
    }
    /**
     * TODO работает / но проверить еще раз
     * Проверка тип подраздела у основного раздела
     * @param $parentId
     * @return int|null
     */
    public function parentTypeContent($parentId)
    {
        if ($parentTypeContent = DB::init()->connect()->table(self::$_table)->select('typeContent, type')->where('sectionId','=', $parentId)->get())
            return $parentTypeContent;

        return null;
    }
    /**
     * Добавить новый раздел
     *
     * @param $section
     * @param $images
     * @param $manager
     * @return false|mixed
     * @throws \SmartyException
     */
    public function add($section, $images, $manager)
    {

        $section->url = '';
        $section->addedBy    = $manager->userId;
        $section->addedOn    = gmdate('Y-m-d H:i:s');
        $section->modifiedBy = $manager->userId;
        $section->modifiedOn = gmdate('Y-m-d H:i:s');
        $section->sortOrder  = DB::init()->connect()->table(self::$_table)->max('sortOrder')->where('parentId', $section->parentId)->getValue() + 1;

        if ($this->sectionId = DB::init()->connect()->table(self::$_table)->insert((array)$section)) {

            if (!empty($images['fileId'])) $this->general($this->sectionId, $images);
            if (!empty($images['gallery'])) $this->picture($this->sectionId, $images);
            if (!empty($images['docs'])) $this->docs($this->sectionId, $images);

            $this->edit($this->sectionId);

            return true;
        }
        return false;
    }
    /**
     * Обновление информации раздела
     * @param $sectionId
     * @param $section
     * @param $oldSection
     * @param $images
     * @param $manager
     * @return false|mixed
     * @throws \SmartyException
     */
    public function update($sectionId, $section, $oldSection, $images, $manager)
    {

        unset($section->addedBy);
        unset($section->addedOn);
        unset($section->sortOrder);

        if ($section->parentId != $oldSection->parentId) {
            /* изменить порядок сортировки, если был изменен родитель */
            $section->sortOrder  = DB::init()->connect()->table(self::$_table)->max('sortOrder')->where('parentId', $section->parentId)->getValue() + 1;
        }
        $section->modifiedBy = $manager->userId;
        $section->modifiedOn = gmdate('Y-m-d H:i:s');

        if (!empty($images['fileId'])) $this->general($sectionId, $images);
        if (!empty($images['gallery'])) $this->picture($sectionId, $images);
        if (!empty($images['docs'])) $this->docs($sectionId, $images);

        if (DB::init()->connect()->table(self::$_table)->where('sectionId', '=', $sectionId)->update((array)$section)) {

            $this->edit($sectionId);

            return true;

        }
        return false;
    }


    /**
     * Подтвердите удаление и
     * @param int $sectionId
     */
    /**
     * @param int $sectionId
     * @return null
     */
    public function confirmDelete(int $sectionId)
    {
        if (!empty($sectionId)) {
            $this->getSection($sectionId);
            if ($this->section) {
                /* проверки, если раздел имеет подразделы */
                $this->section->hasSubsections = DB::init()->connect()->table(self::$_table)->count('*', 'count')->where('parentId', '=', $this->section->sectionId)->getValue();
                /* проверки, если раздел имеет статьи */
                $this->section->hasArticles = DB::init()->connect()->table(self::$_table_articles)->count('*', 'count')->where('sectionId', '=', $this->section->sectionId)->getValue();

//                return $this->section;
            }
        }

//        return null;
    }
    /**
     * Удаление, удаление или перемещение подразделов и контента
     * deleteConfirmed
     * @param $section
     * @param $param
     * @return bool
     * @throws \SmartyException
     */
    public function deleteConfirmed($section, $param): bool
    {
        $this->getSection($section['sectionId']);
        if ($this->section) {
            /* обработка статей */
            if (isset($param['moveArticlesTo'])) {
                if ($param['moveArticlesTo'] == 'delete') {
                    /* удаление контент, удаляемого раздела */
                    $this->delete_contents($this->section->sectionId);
                } else {
                    /* перемещение контент, удаляемого раздела */
                    $this->move_content($this->section, $param);
                }
            }

            /* обработка подразделов */
            if (isset($param['moveSubsectionsTo'])) {
                if ($param['moveSubsectionsTo'] == 'delete') {
                    /* удаление раздела и его контент */
                    $this->delete_sections($this->section);
                } else {
                    /* переместить подразделы  */
                    $this->reorder_section($this->section, $param);
                }
            }

            /* Работает удаление изображения вместе с удалением раздела удаляет из базы данных */
            DB::init()->connect()->table(self::$_table_images)->where('sectionId', $this->section->sectionId)->delete();

            /* удаление раздела */
            DB::init()->connect()->table(self::$_table)->where('sectionId', $this->section->sectionId)->delete();
            $this->writeSortOrders($this->section->parentId);

            return true;
        }
        return false;
    }

    /**
     * Перемещение подраздела(ов) в существующий раздел
     * @param $section
     * @param $param
     * @return bool
     */
    public function reorder_section($section, $param): bool
    {
        if ($destSection = DB::init()->connect()->table(self::$_table)->where('sectionId', $param['moveSubsectionsTo'])->get()) {

            $maxSortOrder = DB::init()->connect()->table(self::$_table)->max('sortOrder')->where('parentId', $destSection->sectionId)->getValue();

            DB::init()->connect()->table(self::$_table)->where('parentId',  $section->sectionId)->update(['sortOrder' => intval($maxSortOrder + 1), 'parentId' => $destSection->sectionId]);

            $this->writeSortOrders($destSection->sectionId);

            return true;

        } else {

           if ($hasSubsections =  DB::init()->connect()->table(self::$_table)->where('parentId', '=', $section->sectionId)->getAll()) {
               foreach ($hasSubsections as $hasSubsection) {
                   DB::init()->connect()->table(self::$_table)->where('parentId', $hasSubsection->parentId)->update(['sortOrder' => $hasSubsection->sectionId, 'parentId' => 0]);
               }

               return true;
           }
        }
        return false;
    }

    /**
     * Удаление разлела и его контент
     * @param $section
     * @return bool
     */
    public function delete_sections($section): bool
    {
        global $SECTIONS;

        if (!empty($SECTIONS[$section->sectionId]->allChildren)) {
            DB::init()->connect()->table(self::$_table)->in('sectionId', $SECTIONS[$section->sectionId]->allChildren)->delete();
            DB::init()->connect()->table(self::$_table_images)->in('sectionId', $SECTIONS[$section->sectionId]->allChildren)->delete();

            $this->delete_contents($SECTIONS[$section->sectionId]->allChildren);

            return true;
        }
        return false;
    }

    /**
     * Сортировка разделов
     *
     * @param $ids
     * @param $sectionIds
     * @return bool
     */
    public function reorderSections($ids, $sectionIds): bool
    {
        foreach ($sectionIds as $i => $sectionId) {
            DB::init()->connect()->table(self::$_table)->where('sectionId','=',$ids[$i])->update(['sortOrder' => $sectionId]);
        }
        return true;
    }
    /**
     * Сортировка при изменение раздела
     *
     * @param int $parentId
     */
    public function writeSortOrders(int $parentId = 0)
    {
        $sections = DB::init()->connect()->table(self::$_table)->select('sectionId, sortOrder')->where('parentId', $parentId)->orderBy('sortOrder')->getAll();
        $sortOrder = 0;
        foreach ($sections as $section) {
            $sortOrder++;
            if ($section->sortOrder != $sortOrder) {
                DB::init()->connect()->table(self::$_table)->where('sectionId','=', $section->sectionId)->update(['sortOrder'=> $sortOrder]);
            }
        }
    }
    /**
     * Удаление контента и комментарии контента
     *
     * @param $sectionIds
     */
    private function delete_contents($sectionIds)
    {
        if (is_array($sectionIds)) {
            DB::init()->connect()->in('sectionId', $sectionIds);
        } else {
            DB::init()->connect()->where('sectionId', $sectionIds);
        }
        $articles = DB::init()->connect()->table(self::$_table_articles)->select('articleId')->getAll();

        foreach ($articles as $article) {
            DB::init()->connect()->table(self::$_table_articles)->where('articleId','=', $article->articleId)->delete();
            DB::init()->connect()->table(self::$_table_comments)->where('articleId','=', $article->articleId)->delete();
        }
    }

    /**
     * Перемещение контента
     *
     * @param $section
     * @param $param
     */
    private function move_content($section, $param)
    {
        global $SECTIONS, $databaseConfig;

        DB::init()->connect()->query("UPDATE `" . $databaseConfig['prefix'].self::$_table_articles . "` 
            SET `url` = CONCAT('". $SECTIONS[$param['moveArticlesTo']]->path."', '/', `fileName`, '.". $this->config['file_extension']."'), `sectionId` = $param[moveArticlesTo] 
            WHERE `sectionId` = '$section->sectionId'")->exec();
    }

    /**
     * Удаление основной картинки
     * @param $imageId
     * @return bool
     */
    public function deleteImage($imageId): bool
    {
        if (DB::init()->connect()->table(self::$_table_images)->where('imageId', $imageId)->delete()) return true;

        return false;
    }

    /**
     * Добавление или замена информации у картинки в галереи
     * @param $imageId
     * @param $picture
     * @return bool|int
     */
    public function editPictureInfo($imageId, $picture)
    {
        if (DB::init()->connect()->table(self::$_table_images)->where('imageId', $imageId)->update(['title' => $picture['title'], 'alias' => $picture['alias'], 'description' => $picture['description'], 'link' => $picture['link'], 'position' => $picture['position']])) {
            return DB::init()->connect()->table(self::$_table_images)->where('imageId', $imageId)->get();
        }

        return false;
    }


    /**
     * Сортировка картинок в галереи
     * @param $imageIds
     * @return bool
     */
    public function sortPictures($imageIds): bool
    {
        $order = 1;
        foreach ($imageIds as  $imageId) {
            DB::init()->connect()->table(self::$_table_images)->where('imageId','=', $imageId)->update(['orderBy'=> $order]);
            $order++;
        }
        return true;
    }


    /**
     * Удаление картинки из галереи
     * @param $imageId
     * @return bool
     */
    public function deletePicture($imageId): bool
    {
        if (DB::init()->connect()->table(self::$_table_images)->where('imageId', '=', $imageId)->delete()) return true;

        return false;
    }



    /**
     * Удаление картинки из галереи
     * @param $imageId
     * @return bool
     */
    public function deleteDocs($imageId): bool
    {
        if (DB::init()->connect()->table(self::$_table_images)->where('imageId', '=', $imageId)->delete()) return true;

        return false;
    }


    /**
     * Добавить / удалить с главного меню
     *
     * @param $sectionId
     * @param $val
     * @return array
     */
    public function menuSection($sectionId, $val): ?array
    {
        if ($val == 1) {
            if (DB::init()->connect()->table(self::$_table)->where('sectionId', '=', $sectionId)->update(['topMenu'=> $val])) {
                return array('check' => 0);
            }
        } elseif ($val == 0) {
            if (DB::init()->connect()->table(self::$_table)->where('sectionId', '=', $sectionId)->update(['topMenu'=> $val])) {
                return array('check' => 1);
            }
        }
        return null;
    }

    /**
     * Скрыть / показать раздел
     *
     * @param $sectionId
     * @return array
     */
    public function statusSection($sectionId): array
    {
        if ($section = DB::init()->connect()->table(self::$_table)->where('sectionId', '=', $sectionId)->get()) {
            $sectionUpdate['status'] = ($section->status == 'visible') ? 'hidden' : 'visible';

            DB::init()->connect()->table(self::$_table)->where('sectionId', '=', $section->sectionId)->update($sectionUpdate);
            return array('data' => true, 'status' => $sectionUpdate['status']);
        }
        return array('data' => false);
    }



    public function convertColors($arrays): array
    {
        $colors = array();
        foreach ($arrays as $n => $va) {
            foreach($va as $i => $v) {
                if (empty($colors[$i]))
                    $colors[$i] = new \stdClass;
                $colors[$i]->$n = $v;
            }
        }

        return $colors;
    }

}