<?php

namespace Mnv\Models\Sections;

use Mnv\Core\DB;
use Mnv\Core\Files\Image\ImageSizes;
use Mnv\Core\Mnv;

/**
 * Class SectionAbstract
 * @package Mnv\Models\Sections
 */
abstract class SectionAbstract extends Mnv
{

    private static $_table          = 'sections';
    private static $_table_images   = 'section_images';
    private static $_files         = 'files';
    private static $_table_articles = 'articles';
    private static $_table_comments = 'comments';

    private $fields = array('sectionId, parentId, sortOrder, name, alias, topMenu, fileName, url, status, typeContent, type');

    public $section;
    public $sections;
    public $sectionId;
    public $parentId;
    public $total;
    public $images;


    /**
     * Получение всех разделов
     *
     * @param int $parentId
     */
    public function getAll(int $parentId) : void
    {
        $this->sections = DB::init()->connect()->table(self::$_table)->select($this->fields)->orderBy('sortOrder', 'asc')->pagination($this->limit, $this->page)->where('parentId', $parentId)->getAll();
    }

    /**
     * Вывод кол-во разделов
     * @param int $parentId
     */
    public function getCountSections(int $parentId = 0)
    {
        $this->total = DB::init()->connect()->table(self::$_table)->count('*', 'count')->where('parentId', $parentId)->getValue();
    }

    /**
     * Получить раздел
     *
     * @param $sectionId
     */
    protected function getSection($sectionId): void
    {
        $this->section = DB::init()->connect()->table(self::$_table)->where('sectionId', $sectionId)->get();
    }


    /**
     * получать файлы
     */
    public function getFiles()
    {
        if (isset($this->sectionId) && $this->sectionId > 0) {
            $images = DB::init()->connect()->table('section_images')->select('*')->where('sectionId', $this->sectionId)->orderBy('orderBy')->getAll();

            if (isset($images)) {
                foreach ($images as $imageId => $image) {
                    if ($file = DB::init()->connect()->table(self::$_files)->where('fileId', $image->fileId)->get()) {
                        if ($image->type === 'general') {
                            $this->section->image = ImageSizes::init()->get($image, $file);
                        } elseif ($image->type === 'gallery') {
                            $this->section->gallery[$imageId] = ImageSizes::init()->get($image, $file);
                        } else {
                            $this->section->docs[$imageId]    = ImageSizes::init()->get($image, $file);
                        }
                    }
                }
            }
        }
    }

    /**
     * получать основной картинки
     *
     */
    public function getModeBColors()
    {
        if (isset($this->sectionId) && $this->sectionId > 0) {
            $images = DB::init()->connect()->table('section_colors')->select('*')->where('type', 'bcolors')->where('sectionId', $this->sectionId)->orderBy('orderBy')->getAll();

            if (isset($images)) {
                foreach ($images as $imageId => $image) {
                    if ($file = DB::init()->connect()->table(self::$_files)->where('fileId', $image->fileId)->get()) {
                        $this->section->bcolors[$imageId] = $image;
                        if (isset($info->sizes->original->path)) $this->section->bcolors[$imageId]->original  = $file->path . $file->fileName;
                        $this->section->bcolors[$imageId]->large    = $file->path . 'large/' . $file->fileName;
                        $this->section->bcolors[$imageId]->medium   = $file->path . 'medium/' . $file->fileName;
                        $this->section->bcolors[$imageId]->small    = $file->path . 'small/' . $file->fileName;

                    }
                }
            }
        }
    }

    /**
     * получать основной картинки
     *
     */
    public function getModeIColors()
    {
        if (isset($this->sectionId) && $this->sectionId > 0) {
            $images = DB::init()->connect()->table('section_colors')->select('*')->where('type', 'icolors')->where('sectionId', $this->sectionId)->orderBy('orderBy')->getAll();

            if (isset($images)) {
                foreach ($images as $imageId => $image) {
                    if ($file = DB::init()->connect()->table(self::$_files)->where('fileId', $image->fileId)->get()) {
                        $this->section->icolors[$imageId] = $image;
                        if (isset($info->sizes->original->path)) $this->section->icolors[$imageId]->original  = $file->path . $file->fileName;
                        $this->section->icolors[$imageId]->large    = $file->path . 'large/' . $file->fileName;
                        $this->section->icolors[$imageId]->medium   = $file->path . 'medium/' . $file->fileName;
                        $this->section->icolors[$imageId]->small    = $file->path . 'small/' . $file->fileName;

                    }
                }
            }
        }
    }


    /**
     * получать информацию о пользователях
     */
    protected function getManagerInfo()
    {
        if (isset($this->section->addedBy) && isset($this->section->modifiedBy)) {
            $managers = DB::init()->connect()->table('users')->select('userId, loginName')->in('userId', [$this->section->addedBy, $this->section->modifiedBy])->indexKey('userId')->getAllIndexes();
            $this->section->addedBy = empty($managers[$this->section->addedBy]) ? unknownUser() : $managers[$this->section->addedBy];
            $this->section->modifiedBy = empty($managers[$this->section->modifiedBy]) ? unknownUser() : $managers[$this->section->modifiedBy];
            $this->section->addedOn = adjustTime($this->section->addedOn, false, 'd.m.Y H:i');
            $this->section->modifiedOn = adjustTime($this->section->modifiedOn, false, 'd.m.Y H:i');
        }
    }

    /**
     * Добавление картинки к контенту
     * @param $id
     * @param $images
     * @return bool|int
     */
    protected function general($id, $images)
    {

        if (!empty($images['fileId'])) {
            if ($file = DB::init()->connect()->table(self::$_files)->where('fileId', $images['fileId'])->get()) {

                if ($imageId = DB::init()->connect()->table('section_images')->where('type', 'general')->where('sectionId', $id)->select('imageId')->getValue()) {
                    $imageUpload['imageId'] = $imageId;
                }

                $imageUpload['sectionId'] = $id;
                $imageUpload['fileId'] = $file->fileId;
                $imageUpload['type'] = 'general';
                $imageUpload['orderBy'] = 0;

                if (DB::init()->connect()->table('section_images')->replace($imageUpload)) return true;
            }
            return false;
        }
        return false;
    }

    /**
     * Загрузка картинок в галерею
     * @param $id
     * @param $images
     * @return bool|int
     */
    protected function picture($id, $images)
    {
        if (!empty($images['gallery'])) {
            if ($order = DB::init()->connect()->table('section_images')->where('sectionId', $id)->max('orderBy')->getValue()) {
                $idx = $order;
            } else {
                $idx = 0;
            }
            foreach ($images['gallery'] as $gallery) {
                $idx++;
                $file = DB::init()->connect()->table(self::$_files)->where('fileId', '=', $gallery['fileId'])->get();
                $imageUpload['sectionId'] = $id;
                $imageUpload['fileId']    = $file->fileId;
                $imageUpload['type']      = 'gallery';
                $imageUpload['orderBy']   = $idx;

                DB::init()->connect()->table('section_images')->replace($imageUpload);
            }
            return true;
        }

        return false;
    }

    /**
     * Загрузка картинок в галерею
     * @param $id
     * @param $images
     * @return bool|int
     */
    protected function docs($id, $images)
    {
        if (!empty($images['docs'])) {
            if ($order = DB::init()->connect()->table('section_images')->where('sectionId', $id)->max('orderBy')->getValue()) {
                $idx = $order;
            } else {
                $idx = 0;
            }
            foreach ($images['docs'] as $gallery) {
                $idx++;
                $file = DB::init()->connect()->table(self::$_files)->where('fileId', '=', $gallery['fileId'])->get();

                $imageUpload['sectionId'] = $id;
                $imageUpload['fileId']    = $file->fileId;
                $imageUpload['type']      = 'docs';
                $imageUpload['orderBy']   = $idx;

                DB::init()->connect()->table('section_images')->replace($imageUpload);
            }
            return true;
        }

        return false;
    }

}