<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class Orders
 * @package Mnv\Models
 */
class Orders extends Mnv
{
    private static $_table = 'shop_orders';

    /**
     * OrdersAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    public $orders;
    public $order;
    public $orderId;
    public $total;

    /**
     *
     * @param $start
     * @param $length
     * @param string $searchValue
     * @param $columnSortOrder
     * @param $columnName
     * @return array|false|mixed|object|string
     */
    public function getTableOrders($start, $length, $searchValue = '', $columnSortOrder, $columnName)
    {

        $query = $searchValue['value'];
        if (!empty($query))   DB::init()->connect()->like('name', "%".$query . "%")->orLike('description', "%".$query . "%")->orLike('content', "%".$query . "%");

        $columnIndex = $columnSortOrder[0]['column'];
        if ($columnSortOrder) {
            DB::init()->connect()->orderBy($columnName[$columnIndex]['data'], $columnSortOrder[0]['dir']);
        } else {
            DB::init()->connect()->orderBy('id', 'ASC');
        }

        $this->orders = DB::init()->connect()->table(static::$_table)->select('id, basketId, client, amount, createdBy, status, payMethod')->limit($start, $length)->getAll();
        foreach ($this->orders as $orderId => $order) {
            $this->orders[$orderId]->client       = json_decode($order->client);
            $this->orders[$orderId]->statusName   = lang('orders:statuses:'.$order->status);
            $this->orders[$orderId]->createdBy    = langDate(adjustTime($order->createdBy, false, 'd.m.Y H:i '));
            $this->orders[$orderId]->monthBy      = langDate(adjustTime($order->createdBy, false, 'F Y'));
            $this->orders[$orderId]->amount       = number_format($order->amount, 0, '.', ' ');
        }

//        print_r($this->orders);
        return $this->orders;
    }

    /**
     * @return mixed|string
     */
    public function countTableOrders()
    {
        return DB::init()->connect()->table(static::$_table)->count('*', 'count')->getValue();
    }

    /**
     * @param string $searchValue
     * @return mixed|string
     */
    public function countTableFilteredOrders($searchValue = '')
    {
        $query = $searchValue['value'];
        if (!empty($query))
            DB::init()->connect()->like('name', "%".$query . "%")
                ->orLike('description', "%".$query . "%")
                ->orLike('content', "%".$query . "%");

        return DB::init()->connect()->table(static::$_table)->count('*', 'count')->getValue();
    }

    /**
     * @param $page
     * @param $limit
     * @return array|false|mixed|object|string
     */
    public function getAll($page, $limit)
    {
        $this->orders = DB::init()->connect()->table(static::$_table)
            ->select('orderId, userName, userPhone, userEmail, totalAmount, createdBy, datePayment, status')
            ->limit(($page-1)*$limit, $limit)->orderBy('id', 'DESC')
            ->getAll();
        foreach ($this->orders as $orderId => $order) {
            $this->orders[$order->orderId]->status     = lang('orders:statuses:'.$order->status);
            $this->orders[$order->orderId]->createdBy  = langDate(adjustTime($order->createdBy, false, 'd.m.Y H:i '));
            $this->orders[$order->orderId]->monthBy    = langDate(adjustTime($order->createdBy, false, 'F Y'));
        }

        return $this->orders;
    }


    public function total(): void
    {
        $this->total = DB::init()->connect()->table(static::$_table)->count('*', 'count')->getValue();
    }


    public function edit(): void
    {
        if (!empty($this->orderId)) {
            $this->order = DB::init()->connect()->table(static::$_table)
                ->select('id, basketId, client, ls_shop_orders.amount, createdBy, message, payMethod, status, state, variantIds, products, quantity')
                ->usingJoin('shop_baskets', 'basketId')->where('id', $this->orderId)->get();
//            print_r(DB::init()->connect()->getQuery());
//            print_r($this->order);
            $this->order->createdBy   = langDate(adjustTime($this->order->createdBy, false, 'd.m.Y H:i'));
            $this->order->client      = json_decode($this->order->client);
            $this->order->products    = json_decode($this->order->products);
            foreach ($this->order->products as $productId => $product) {
                $variant = $this->getVariant($product->variantId);
                $this->order->products[$productId]->title = $variant->title;
                $this->order->products[$productId]->variantName = $variant->variantName;
                $this->order->products[$productId]->price = $variant->price;
                if (!empty($variant->info)) {
                    $variant->info = json_decode($variant->info);
                    $this->order->products[$productId]->image = $variant->info->sizes->md->path;
                }
            }
        }
    }

    public function getVariant(?int $variantId)
    {
        // TODO: join запрос
        return DB::init()->connect()->table('product_variants')
            ->select('title, id AS variantId, productId, name AS variantName, sku, price, oldPrice, fileId, info')
            ->join('articles', 'articleId', '=', 'productId')
            ->usingJoin('article_images', 'articleId')
            ->usingJoin('files', 'fileId')
            ->where('type', 'general')
            ->where('id', $variantId)
            ->get();
    }

    /**
     * @param $order
     * @return bool
     */
    public function update($order): bool
    {
        if (!empty($this->orderId)) {
            if (DB::init()->connect()->table(static::$_table)->where('id', $this->orderId)->update($order)) return true;
        }

        return false;
    }

    /**
     * @return bool
     */
    public function remove(): bool
    {
        if (!empty($this->orderId)) {
            if (DB::init()->connect()->table(static::$_table)->where('id', $this->orderId)->delete()) return true;
        }
        return false;
    }


}