<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;
use Mnv\Core\Locale\Charset;
use Mnv\Core\Locale\LanguageSelection;

/**
 * Class Languages
 * @package Mnv\Models
 */
class Languages extends Mnv
{
    private static $_table = 'languages';

    protected $lang;
    protected $language;
    protected $languageId;

    /**
     * Таблицы которые не нужно копировать
     * @var array
     */
    private static $tableArray = [
        'languages',
        'subscribe',
        'feedback',
        'users',
        'users_confirmations',
        'users_remembered',
        'users_resets',
        'users_throttling',
        'users_banned_ips',
        'files',
        'socials',
        'maps',
        'log',
        'shop_baskets',
        'shop_orders',
        'shop_favorites',
        'shop_compares',
        'shop_currency',
        'shop_payments',
        'shop_transactions',
        'telegram_users',
        'notice'
    ];

    private static $tableNotUrl = [
        'settings',
        'logo',
        'section_images',
        'section_colors',
        'article_images',
        'brands',
        'banners',
        'article_visits',
        'comments',
        'currency',
        'stats_visits',
        'stats_visitors',
        'stats_user_agents',
        'stats_section_visits',
        'stats_article_visits',
        'stats_search_visits',
        'stats_ad_clicks',
        'stats_error_visits',
        'stats_cache_daily',
        'stats_rss_visits',
        'stats_download',
        'product_variants',
        'product_features',
        'product_options',
        'banners_group',
        'blocks',
        'coupons',
        'faq',

    ];

    /**
     * LanguagesAdmin constructor.
     */
    public function __construct()
    {
        global $DEFAULT_LANG;

        parent::__construct();

        $this->lang  = $DEFAULT_LANG;


        $this->action     = getRequestVar('action','');
        $this->language   = arrAddSlashes(getRequestVar('language', '', true));
        $this->languageId = getRequestVar('id','');

        $this->smarty->assign('statuses', lang('languages:statuses'));
        $this->smarty->assign('languageOptions', LanguageSelection::$languageOptions);
        $this->smarty->assign('languageCharsets', Charset::$languageCharsets);
        $this->smarty->assign('languageOptions', Charset::$charsetOptions);

        if ((int)DB::init()->connect()->table(static::$_table)->count('*', 'count')->getValue() == 0) {
            $action = array();
            $action['toMultilangMode'] = true;
            $this->smarty->assign('action', $action);
        }
    }

    public function getAllLanguages()
    {
        return DB::init()->connect()->table(static::$_table)->select('languageId, languageName, codename, url, status, isDefault, sortOrder')->orderBy('sortOrder')->getAll();

    }
    /**
     * @param $languageId
     * @return string
     */
    public function edit($languageId)
    {
        if (!empty($languageId)) {
            $language = DB::init()->connect()->table(static::$_table)->where('languageId', '=', $languageId)->get();
            /** получать информацию о пользователе, который создал или редактировал */
            $language = $this->getUserInfo($language);

            return $language;
        }
        return null;
    }

    /**
     * Проверка на совпадение и получение codename
     *
     * @param $languageId
     * @param $codename
     * @return int|null
     */
    public function isCodeName($languageId, $codename)
    {
        if (empty($languageId)) {
            if ($codeName = DB::init()->connect()->table(static::$_table)->select('codename')->where('codename','=', $codename)->getValue()) return $codeName;
        } else {
            if ($codeName = DB::init()->connect()->table(static::$_table)->select('codename')->where('languageId', '<>', $languageId)->where('codename','=', $codename)->getValue()) return $codeName;
        }

        return null;
    }

    /**
     * Добавление языковой версии сайта
     *
     * @param $language
     * @return bool|int
     */
    public function add($language, $manager)
    {
        if (empty($language['languageId'])) {
            if (isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] == 'on' || $_SERVER['HTTPS'] == 1) || isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https') {
                $protocol = 'https://';
            }
            else {
                $protocol = 'http://';
            }

            $language['url'] = !empty($language['isDefault']) ? $protocol . $_SERVER['HTTP_HOST'] : $protocol . $_SERVER['HTTP_HOST'] . '/' . $language['codename'];

            if (!empty($language['isDefault']) || $this->addLanguage($language)) {
                $language['addedBy']       = $manager->userId;
                $language['addedOn']       = gmdate('Y-m-d H:i:s');
                $language['modifiedBy']    = $manager->userId;
                $language['modifiedOn']    = gmdate('Y-m-d H:i:s');
                $language['sortOrder']     = DB::init()->connect()->table(static::$_table)->max('sortOrder')->getValue() + 1;

                unset($language['languageId']);
                unset($language['admin_language']);
                unset($language['charset']);
                if ($language['languageId'] = DB::init()->connect()->table(static::$_table)->insert($language)) {
                    buildLanguagesArray();

                    return $language['languageId'];
                }
            }
        }

        return false;
    }

    /**
     * @param $language
     * @return bool
     */
    public function update($language, $manager)
    {
        if (!empty($language['languageId'])) {
            unset($language['url']);
            unset($language['codename']);
            unset($language['isDefault']);
            unset($language['addedBy']);
            unset($language['addedOn']);
            $language['modifiedBy'] = $manager->userId;
            $language['modifiedOn'] = gmdate('Y-m-d H:i:s');

            if (DB::init()->connect()->table(static::$_table)->where('languageId', '=', $language['languageId'])){
                buildLanguagesArray();
                return true;
            }
        }
        return false;
    }

    /**
     * @param $languageId
     * @return bool
     */
    public function confirmDelete($languageId)
    {
        if ($language = DB::init()->connect()->table(static::$_table)->where('languageId','=', $languageId)->get()) return $language;

        return false;
    }

    /**
     * @param $languageId
     * @return bool
     */
    public function remove($languageId)
    {
        if ($language = DB::init()->connect()->table(static::$_table)->where('languageId','=', $languageId)->get()) {
            if (empty($language->isDefault)) $this->removeLanguage($language);
            DB::init()->connect()->table(static::$_table)->where('languageId','=', $language->languageId)->delete();
            buildLanguagesArray();
            return true;
        }
        return false;

    }

    public function status($languageId)
    {
        if ($language = DB::init()->connect()->table(static::$_table)->where('languageId','=', $languageId)->get()) {
            $languageUpdate['status'] = ($language->status == 'visible') ? 'hidden' : 'visible';
            DB::init()->connect()->table(static::$_table)->where('languageId','=', $language->languageId)->update($languageUpdate);
            buildLanguagesArray();
            return array('data' => true);
        }
        return array('data' => false);

    }

    /**
     * Сортировка версии языка
     * @param $ids
     * @param $languageIds
     */
    public function reorder($ids, $languageIds)
    {
        foreach ($languageIds as $i => $languageId) {
             //print_r( $ids[$i] . '-' . $languageId . ' : ');
            DB::init()->connect()->table(static::$_table)->where('languageId', $ids[$i])->update(['sortOrder' => $languageId]);
            buildLanguagesArray();
        }

    }

    /**
     * @param $languageId
     */
    public function moveUp($languageId)
    {
        if ($language = DB::init()->connect()->table(static::$_table)->select('languageId, sortOrder')->where('languageId', $languageId)->get()) {
            if ($upperLanguage = DB::init()->connect()->table(static::$_table)->select('languageId')->where('sortOrder',$language->sortOrder - 1)->get()) {
                /** updating languages, moving up */
                DB::init()->connect()->table(static::$_table)->where('languageId', $language->languageId)->update(['sortOrder' => 'sortOrder-1']);
                DB::init()->connect()->table(static::$_table)->where('languageId', $upperLanguage->languageId)->update(['sortOrder' => 'sortOrder+1']);
                if (buildLanguagesArray()) {
                    echo "moveUpMessage();";
                } else {
                    echo "moveError();";
                }
                echo "swapElements('language-$language->languageId', 'language-$upperLanguage->languageId', 'language');\r\n";
            }
        }
        exit;
    }

    /**
     * @param $languageId
     */
    public function moveDown($languageId)
    {
        if ($language = DB::init()->connect()->table(static::$_table)->select('languageId, sortOrder')->where('languageId', $languageId)->get()) {
            if ($downLanguage = DB::init()->connect()->table(static::$_table)->select('languageId')->where('sortOrder', $language->sortOrder + 1)->get()) {
                /** updating languages, moving down */
                DB::init()->connect()->table(static::$_table)->where('languageId', $language->languageId)->update(['sortOrder' => 'sortOrder+1']);
                DB::init()->connect()->table(static::$_table)->where('languageId', $downLanguage->languageId)->update(['sortOrder' => 'sortOrder-1']);
                if (buildLanguagesArray()) {
                    echo "moveDownMessage();";
                } else {
                    echo "moveError();";
                }
                echo "swapElements('language-$downLanguage->languageId', 'language-$language->languageId', 'language')";
            }
        }
        exit;
    }

    /**
     * @param $language
     */
    public function removeLanguage($language)
    {
        global $tbl, $databaseConfig;
        /** удаляем файлы */
        deleteDir(GLOBAL_ROOT.'/'.$language->codename);
        @unlinkFile(GLOBAL_ROOT . '/includes/languages/' . $language->codename . '.json');
        /** удаляем таблицы */
        foreach ($tbl as $tableKey => $void) {
            if (!in_array($tableKey, static::$tableArray)) {
                /** delete table */
                $tableName = $databaseConfig['prefix'].$language->codename.'_'.$tableKey;
                DB::init()->connect()->query("DROP TABLE `$tableName`")->exec();
            }
        }
    }

    /**
     * @param $language
     * @return bool
     * @throws \SmartyException
     */
    public function changeDefaultLanguage($language): bool
    {
        if ($language = DB::init()->connect()->table(static::$_table)->where('languageId', $language['languageId'])->where('isDefault',0)->get()){
            $defaultLanguage = DB::init()->connect()->table(static::$_table)->where('isDefault',1)->get();
            $this->swapLanguages($language, $defaultLanguage);
            return true;
        }
        return false;
    }

    /**
     * @param $language1
     * @param $language2
     * @return bool
     * @throws \SmartyException
     */
    public function swapLanguages($language1, $language2)
    {
        global $tbl, $databaseConfig;

        if ($language1->isDefault) {
            $dLanguage = $language1;
            $nLanguage = $language2;
        }
        if ($language2->isDefault) {
            $dLanguage = $language2;
            $nLanguage = $language1;
        }

        /* renaming SQL tables */
        $dLanguage->oldPrefix = $databaseConfig['prefix'];
        $dLanguage->newPrefix = $databaseConfig['prefix'].$dLanguage->codename.'_';
        $nLanguage->oldPrefix = $databaseConfig['prefix'].$nLanguage->codename.'_';
        $nLanguage->newPrefix = $databaseConfig['prefix'];
        $tmpPrefix              = $databaseConfig['prefix'].'tmp_';
        $nLanguage->oldURL = GLOBAL_URL.'/'.$nLanguage->codename;
        $nLanguage->newURL = GLOBAL_URL;
        $dLanguage->oldURL = GLOBAL_URL;
        $dLanguage->newURL = GLOBAL_URL.'/'.$dLanguage->codename;

        foreach ($tbl as $tableKey => $void) {
            if (!in_array($tableKey, static::$tableArray)) {
                DB::init()->connect()->query('DROP TABLE IF EXISTS `'.$tmpPrefix.$tableKey.'`')->exec();
                DB::init()->connect()->query('RENAME TABLE `'.$dLanguage->oldPrefix.$tableKey.'` TO `'.$tmpPrefix.$tableKey.'`')->exec();
                DB::init()->connect()->query('RENAME TABLE `'.$nLanguage->oldPrefix.$tableKey.'` TO `'.$nLanguage->newPrefix.$tableKey.'`')->exec();
                DB::init()->connect()->query('RENAME TABLE `'.$tmpPrefix.$tableKey.'` TO `'.$dLanguage->newPrefix.$tableKey.'`')->exec();
            }
        }

        /* updating sections */
        DB::init()->connect()->query("UPDATE `".$nLanguage->newPrefix."sections` SET url=REPLACE(url, '".$nLanguage->oldURL."', '".$nLanguage->newURL."')")->exec();
        DB::init()->connect()->query("UPDATE `".$dLanguage->newPrefix."sections` SET url=REPLACE(url, '".$dLanguage->oldURL."', '".$dLanguage->newURL."')")->exec();
        /* updating articles */
        DB::init()->connect()->query("UPDATE `".$nLanguage->newPrefix."articles` SET url=REPLACE(url, '".$nLanguage->oldURL."', '".$nLanguage->newURL."')")->exec();
        DB::init()->connect()->query("UPDATE `".$dLanguage->newPrefix."articles` SET url=REPLACE(url, '".$dLanguage->oldURL."', '".$dLanguage->newURL."')")->exec();
        /* updating sliders */
        DB::init()->connect()->query("UPDATE `".$nLanguage->newPrefix."sliders` SET url=REPLACE(url, '".$nLanguage->oldURL."', '".$nLanguage->newURL."')")->exec();
        DB::init()->connect()->query("UPDATE `".$dLanguage->newPrefix."sliders` SET url=REPLACE(url, '".$dLanguage->oldURL."', '".$dLanguage->newURL."')")->exec();
        /* updating languages */
        DB::init()->connect()->table(static::$_table)->where('languageId','=', $dLanguage->languageId)->update(['isDefault'=>0, 'url'=>$dLanguage->newURL]);
        DB::init()->connect()->table(static::$_table)->where('languageId','=', $nLanguage->languageId)->update(['isDefault'=>1, 'url'=>$nLanguage->newURL]);

        /* moving out dLanguage */
        makeDir(GLOBAL_ROOT.'/'.$dLanguage->codename);
//        moveDir(GLOBAL_ROOT.'/uploads', GLOBAL_ROOT.'/'.$dLanguage->codename.'/uploads');
        makeDir(GLOBAL_ROOT.'/'.$dLanguage->codename.'/includes');
        moveFile(GLOBAL_ROOT.'/includes/serializations.inc.php', GLOBAL_ROOT.'/'.$dLanguage->codename.'/includes/serializations.inc.php');
        moveFile(GLOBAL_ROOT.'/includes/.htaccess', GLOBAL_ROOT.'/'.$dLanguage->codename.'/includes/.htaccess');

        /* moving nLanguage */
        moveDir(GLOBAL_ROOT.'/'.$nLanguage->codename, GLOBAL_ROOT);
        /* leaving redirect in the language directory */
        makeDir(GLOBAL_ROOT.'/'.$nLanguage->codename);
        $htaccess  = "Options -Indexes\r\n";
        $htaccess .= "RewriteEngine On\r\n";
        $htaccess .= "RewriteRule ^(.*)$ ".GLOBAL_URL."/\$1 [L,R=301]\r\n";
        saveFile(GLOBAL_ROOT.'/'.$nLanguage->codename.'/.htaccess', $htaccess);

        /* getting languages */
        $dLanguage = DB::init()->connect()->table(static::$_table)->where('languageId','=', $dLanguage->languageId)->get();
        $nLanguage = DB::init()->connect()->table(static::$_table)->where('languageId','=', $nLanguage->languageId)->get();

        /* building serializations and .htaccess */
        foreach ($tbl as $tableKey => $void) {
            if (!in_array($tableKey, static::$tableArray)) {
                $tbl[$tableKey] = $databaseConfig['prefix'].$dLanguage->codename.'_'.$tableKey;
            }
        }

        saveSerializations($dLanguage);
        writeHtaccess($dLanguage);


        foreach ($tbl as $tableKey=>$void) {
            if (!in_array($tableKey, static::$tableArray)) {
                $tbl[$tableKey] = $databaseConfig['prefix'].$tableKey;
            }
        }
        saveSerializations($nLanguage);
        writeHtaccess($nLanguage);
        buildLanguagesArray();

        return true;
    }


    /**
     * Работа с базой данных и папками
     *
     * @param $language
     * @return bool
     */
    private function addLanguage($language)
    {
        global $tbl, $databaseConfig;

        if (!empty($language['isDefault']) || $this->lang == $language['codename']) return false;

        /** SQL copy table */

        foreach ($tbl as $tableKey => $void) {
            if (!in_array($tableKey, static::$tableArray)) {
                $tableName = $databaseConfig['prefix'].$tableKey;
                $newTableName = $databaseConfig['prefix'].$language['codename'].'_'.$tableKey;
                /* copy table */
                DB::init()->connect()->query("CREATE TABLE `$newTableName` LIKE `$tableName` ")->exec();
            }
        }

        /** SQL update table */
        foreach ($tbl as $tableKey => $void) {
            if (!in_array($tableKey, static::$tableArray)) {
                $tableName = $databaseConfig['prefix'].$tableKey;
                $newTableName = $databaseConfig['prefix'].$language['codename'].'_'.$tableKey;

                /** копировать данные таблиц */
                if ($tableKey != 'settings') DB::init()->connect()->query("INSERT INTO `$newTableName` SELECT * FROM ".$tableName)->exec();

                /** заменить url на новый url с добавлением кода языка */
                if (!in_array($tableKey, static::$tableNotUrl)) {
                    DB::init()->connect()->query("UPDATE `$newTableName` SET url = REPLACE(url, '".GLOBAL_URL."', '".GLOBAL_URL."/" .$language['codename']."')")->exec();
                }
            }
        }

        /** SQL settings table insert new data */
        $langSettingsArr = DB::init()->connect()->table('settings')->getAll();
        foreach ($langSettingsArr as $item) $langSettings[$item->codename] = $item->value;

        if (!empty($language['charset'])) $langSettings['charset'] = $language['charset'];
        if (!empty($language['admin_language'])) $langSettings['admin_language'] = $language['admin_language'];
        $langSettings['website_language'] = $language['codename'];
        $langSettings['website_down'] = 0;

        $newPrefix =  $databaseConfig['prefix'] . $language['codename'];
        foreach ($langSettings as $codename => $value) {
            DB::init()->connect()->query("INSERT INTO `{$newPrefix}_settings` VALUES('". $codename."','".$value."')")->exec();
//            DB::init()->connect()->table($language['codename'].'_settings')->insert(['codename' => $codename, 'value' => $value]);
        }
        /** end settings table insert new data */

        /** file system */
        $newLangRoot = GLOBAL_ROOT.'/'.$language['codename'];
        if (!is_dir($newLangRoot)) mkdir($newLangRoot);

        /** main htaccess */
        $htaccess  = "Options -Indexes\r\n";
        saveFile($newLangRoot.'/.htaccess', $htaccess);

        /** includes */
        if (!is_dir($newLangRoot.'/includes'))
            mkdir($newLangRoot.'/includes');

        $htaccess  = "Deny from all";
        saveFile($newLangRoot.'/includes/.htaccess', $htaccess);

//        $serializations  = "<?php\r\n";
//        $serializations .= "\$SECTIONS = array();\r\n";
//        $serializations .= "\$TREE = array();\r\n";
/*        $serializations .= "?>";*/
//        saveFile($newLangRoot.'/includes/serializations.inc.php', $serializations);
        xcopy(GLOBAL_ROOT.'/includes/serializations.inc.php',$newLangRoot.'/includes/serializations.inc.php');

        /** копирование содержимого папки uploads */
        makeDir($newLangRoot.'/uploads');
//        xcopy(GLOBAL_ROOT.'/uploads/logo',$newLangRoot.'/uploads/logo');

        /** копирование языковой версии сайта */
        $this->copyTranslations($this->config['website_language'], $language['codename']);

        $this->copyTheme($this->config['website_language'], $language['codename']);

        return true;
    }

    /**
     * Дублирование темы (c шаблонами)
     *
     * @param $labelSrc
     * @param $labelDest
     */
    private function copyTheme($labelSrc, $labelDest)
    {
        if (empty($labelSrc) || empty($labelDest) || $labelSrc == $labelDest) return;

        $themeFolder = GLOBAL_ROOT.'/themes/';
        $lang_dir = $themeFolder.$this->config['theme'];
        if (is_dir($lang_dir)) {
            $oldTheme = explode( "-", $this->config['theme']);

            $from = $lang_dir;
            $to = $themeFolder.$oldTheme[0]. '-' . $labelDest;
            if (file_exists($from) && !file_exists($to)) copyFolder($from, $to);
        }
    }

    /**
     * Дублирование переводов
     * @param $label_src
     * @param $label_dest
     */
    private function copyTranslations($label_src, $label_dest) {
        if (empty($label_src) || empty($label_dest) || $label_src == $label_dest) {
            return;
        }
        $lang_dir = GLOBAL_ROOT.'/includes/languages/';
        if (is_dir($lang_dir)) {
            $src = $lang_dir . $label_src . '.json';
            $dest = $lang_dir . $label_dest . '.json';
            if (file_exists($src) && !file_exists($dest)) copyFolder($src, $dest);
        }
    }

    /**
     * получать информацию о пользователях, которые создали и изменили
     * @param $language
     * @return mixed
     */
    private function getUserInfo($language)
    {
        /* getting info about users who created and modified the language */
        $users = DB::init()->connect()->table('users')->select('userId, loginName')->in('userId', [$language->addedBy, $language->modifiedBy])->indexKey('userId')->getAllIndexes();
        $language->addedBy    = empty($users[$language->addedBy]) ? unknownUser() : $users[$language->addedBy];
        $language->modifiedBy = empty($users[$language->modifiedBy]) ? unknownUser() : $users[$language->modifiedBy];
        $language->addedOn    = langDate(adjustTime($language->addedOn, false, 'd.m.Y H:i'));
        $language->modifiedOn = langDate(adjustTime($language->modifiedOn, false, 'd.m.Y H:i'));

        return $language;
    }
}