<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class Features
 * @package Mnv\Models
 */
class Features extends Mnv
{

    private static $_table   = 'product_features';

    public $feature;
    public $features;
    public $featureId;
    public $featureIds;
    public $total;

    public $sectionIds;

    /**
     * Brands constructor.
     */
    public function __construct()
    {
        parent::__construct();

    }

    /**
     * @param string|null $query
     * @param string|null $status
     * @param int $page
     * @param int $limit
     * @param $columnSortOrder
     * @param $columnName
     * @return array|false|mixed|string
     */
    public function getTableFeatures(?string $query, ?string $status, int $page, int $limit, $columnSortOrder = '', $columnName = '')
    {

        if (!empty($query))  DB::init()->connect()->like('name', "%". $query . "%");
        if (!empty($status)) DB::init()->connect()->where('status', $status);

        $columnIndex = $columnSortOrder[0]['column'];
        if ($columnSortOrder) {
            $orderBy = $columnName[$columnIndex]['data'] . " " . strtoupper($columnSortOrder[0]['dir']);
        } else {
            $orderBy = 'orderBy ASC';
        }


        $this->features = DB::init()->connect()->table(self::$_table)->select('id, name, status, orderBy')->orderBy($orderBy)->limit($page, $limit)->getAll();
        foreach ($this->features as $featureId => $feature) $this->features[$featureId]->statusName = lang('general:statuses:'.$this->features[$featureId]->status);
//print_r( DB::init()->connect()->getQuery());
//        print_r($this->features);
        return $this->features;
    }

    public function countTableFeatures(?string $query, ?string $status)
    {
        if (!empty($query)) DB::init()->connect()->like('name', "%". $query . "%");
        if (!empty($status)) DB::init()->connect()->where('status', $status);
        return DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }

    public function countTableFilteredFeatures(?string $query)
    {
        if (!empty($query)) DB::init()->connect()->like('name', "%". $query . "%");
        return DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }


    public function getAllProductFeatures(?int $sectionId)
    {
        if (!empty($sectionId)) DB::init()->connect()->like('sectionIds', "%$sectionId%");
        $features = DB::init()->connect()->table(self::$_table)->select('id, name')->where('status', 'visible')->orderBy('orderBy ')->getAll();
//        print_r(DB::init()->connect()->getQuery());
//        print_r($features);
        return $features;
    }


//    public function getAll(?int $page, ?int $perPage, ?string $query)
//    {
//        $this->features = DB::init()->connect()->table(self::$_table)->select('*')->pagination($perPage, $page)->getAll();
//    }

//    public function total(?string $query)
//    {
//        $this->total = DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
//    }

    public function existsFeature(string $name)
    {
        if ($feature = DB::init()->connect()->table(self::$_table)->select('id')->where('name', $name)->get()) return $feature->id;

        return null;
    }

    /**
     * TODO Сделано
     * Редактирование/добавление
     * @param $featureId
     * @return string
     */
    public function edit($featureId)
    {
        if (!empty($featureId)) {
            if ($this->feature = DB::init()->connect()->table(self::$_table)->select('*')->where('id', $featureId)->get()) {
                if (!empty($this->feature->sectionIds)) $this->feature->sectionIds = json_decode($this->feature->sectionIds);
                return $this->feature;
            }
        }
        return null;
    }

    /**
     * @param $feature
     * @return bool
     */
    public function add($feature): bool
    {
        $feature['orderBy'] = DB::init()->connect()->table(self::$_table)->max('orderBy')->getValue() + 1;
        if ($this->featureId = DB::init()->connect()->table(self::$_table)->insert($feature)) return true;

        return false;
    }

    /**
     * @param $featureId
     * @param $feature
     * @return bool
     */
    public function update($featureId, $feature): bool
    {
        if ($this->featureId = DB::init()->connect()->table(self::$_table)->where('id', $featureId)->update((array)$feature)) return true;

        return false;
    }

    /**
     * Удаление
     *
     * @param $featureId
     * @return bool
     */
    public function remove($featureId): bool
    {
        if (DB::init()->connect()->table(self::$_table)->where('id', $featureId)->delete()) return true;

        return false;
    }

    public function status()
    {

    }

    /**
     * Сортировка
     *
     * @param $ids
     * @param $featureIds
     */
    public function reorder($ids, $featureIds)
    {
        foreach ($featureIds as $i => $brandId) {
//           print_r( $ids[$i] . '-' . $brandId . ' : ');
            DB::init()->connect()->table(self::$_table)->where('id', '=', $ids[$i])->update(['orderBy' => $brandId]);
        }
    }




    /** OPTIONS */

    public function convertOption($options)
    {
        $productOption = array();
        if (is_array($options)) {
            foreach($options as $featureId => $value) {
                $productOption[$featureId] = new \stdClass;
                $productOption[$featureId]->featureId = $featureId;
                $productOption[$featureId]->value = $value;
            }
            return $productOption;
        }
    }

    public function getOptions($productId)
    {
        return DB::init()->connect()->table('product_options')
            ->select('productId, featureId, value')
            ->where('productId', $productId)->indexKey('featureId')->getAllIndexes();

    }

    /**
     * Обновление/вставка свойства
     *
     * @param int|null $productId
     * @param int|null $featureId
     * @param string|null $value
     */
    public function updateOption(?int $productId, ?int $featureId, ?string $value)
    {
        if ($value != '') {
            DB::init()->connect()->table('product_options')->select('*')->replace(['productId' => $productId, 'featureId' => $featureId, 'value' => $value]);
        } else {
            DB::init()->connect()->table('product_options')->where('productId', $productId)->where('featureId', $featureId)->delete();
        }
    }

    /**
     * Удаление свойства
     *
     * @param int|null $productId
     * @param int|null $featureId
     */
    public function deleteOption(?int $productId, ?int $featureId)
    {
        DB::init()->connect()->table('product_options')->where('productId', $productId)->where('featureId', $featureId)->delete();
    }

    /**
     * Получить все свойства
     *
     * @param $productId
     * @return array|mixed|null
     */
    public function getProductOptions($productId)
    {
        return DB::init()->connect()->table('product_options')
            ->join('product_features', 'id', '=', 'featureId')
            ->select('productId, featureId, name, value, orderBy')
            ->where('productId', $productId)
            ->where('status', 'visible')
            ->orderBy('orderBy')
            ->indexKey('featureId')->getAllIndexes();
    }

    /**
     * Получить `value` свойства
     *
     * @param $featureId
     * @return mixed|string|null
     */
    public function getProductFeatureValue($featureId)
    {
        return DB::init()->connect()->table('product_options')->select('value')->where('featureId', $featureId)->getValue();
    }

}