<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class Coupons
 * @package Mnv\Models
 */
class Coupons extends Mnv
{

    private static $_table  = 'coupons';

    public $coupon;
    public $couponId;
    public $coupons;
    public $total;

    /**
     * SlidersAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }


    public function getAll(): void
    {
        $this->coupons = DB::init()->connect()->table(static::$_table)->orderBy('couponId', 'DESC')->getAll();
        foreach ($this->coupons as &$coupon) {
           if (!is_null($coupon->expire))
               $coupon->expire = langDate(adjustTime($coupon->expire, false, 'd.m.Y'));
        }

//        var_dump($this->coupons);

    }


    public function total()
    {
        $this->total = DB::init()->connect()->table(static::$_table)->count('*', 'count')->getValue();
    }


    public function edit()
    {
        if (!empty($this->couponId)) {
           $this->coupon = DB::init()->connect()->table(static::$_table)->where('couponId', $this->couponId)->get();
        }
    }

    /**
     * Новый
     *
     * @param $coupon
     * @return bool
     */
    public function add($coupon): bool
    {
//        print_r($coupon);
        if ($this->couponId = DB::init()->connect()->table(static::$_table)->insert((array)$coupon)) return true;

        return false;
    }

    /**
     * Обновление слайда
     *
     * @param $coupon
     * @return bool
     */
    public function update($coupon): bool
    {
        if (!empty($this->couponId)) {
            DB::init()->connect()->table(static::$_table)->where('couponId', $this->couponId)->update((array)$coupon);
            $this->edit();

            return true;
        }
        return false;
    }

    /**
     * Сортировка слайдов
     *
     * @param $couponIds
     */
    public function reorder($couponIds)
    {
        $i = 0;
        foreach ($couponIds as $couponId) {
            $i++;
            DB::init()->connect()->table(self::$_table)->where('couponId', $couponId)->update(['orderBy' => $i]);
        }
    }
    /**
     * Скрыть / показать
     *
     * @return array
     */
    public function status(): array
    {
        if (!empty($this->couponId)) {
            if ($slider = DB::init()->connect()->table(static::$_table)->where('couponId', $this->couponId)->get()) {
                $sliderUpdate['status'] = ($slider->status == 'visible') ? 'hidden' : 'visible';
                DB::init()->connect()->table(static::$_table)->where('couponId', $this->couponId)->update($sliderUpdate);
                return array('data' => true, 'status' => $sliderUpdate['status']);
            }

            return array('data' => false);
        }

        return array('data' => false);
    }


    /**
     * удаление слайда
     *
     * @return bool
     */
    public function remove(): bool
    {
        if (!empty($this->couponId)) {
            if (DB::init()->connect()->table(static::$_table)->where('couponId', $this->couponId)->delete()) return true;
        }
        return false;
    }

}