<?php

namespace Mnv\Models\Contents;

/**
 * Interface ContentInterface
 * @package Mnv\Models\Contents
 */
interface ContentInterface
{
    /**
     * Получить весь контент
     *
     * @param string|null $query
     * @param string|null $status
     * @param string|null $typeContent
     * @param null $sectionIds
     * @param $manager
     */
    public function listContent(?string $query, ?string $status, ?string $typeContent, $sectionIds = null, $orderBy, $manager);

    /**
     * Получить кол-во контента
     *
     * @param string|null $query
     * @param string|null $status
     * @param string|null $typeContent
     * @param null $sectionIds
     * @param $manager
     */
    public function total(?string $query, ?string $status, ?string $typeContent, $sectionIds = null, $manager);

    /**
     * Удаление контента
     *
     * @param $manager
     * @return mixed
     */
    public function remove($manager);

    /**
     * Обновление статуса контента
     *
     * @param $manager
     * @return mixed
     */
    public function approve($manager);

    /**
     * Редактирование контента
     *
     * @return mixed
     */
    public function edit();

    /**
     * Добавление нового контента
     *
     * @param $content
     * @param $images
     * @param $manager
     * @return mixed
     */
    public function add($content, $images, $manager);

    /**
     * Обновление контента
     *
     * @param $content
     * @param $images
     * @param $manager
     * @return mixed
     */
    public function update($content, $images, $manager);
}