<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class Comments
 * @package Mnv\Models
 */
class Comments extends Mnv
{
    private static $_table = 'comments';
    private static $_table_articles = 'articles';

    public $total;
    public $comments;
    public $comment;
    public $commentId;
//    protected $bulk;



    /**
     * CommentsAdmin constructor.
     * @throws \SmartyException
     */
    public function __construct()
    {
        parent::__construct();

    }

    /**
     * @param string|null $query
     * @param string|null $status
     */
    public function getAllComments(?string $query, ?string $status)
    {
        /* показывать комментарии только из разрешенных разделов */
        $fields = '*';

        /* processing search fields */
        if (!empty($query)) {
            if (empty($join)) {
                DB::init()->connect()->like('content', "%$query%")->orLike('authorName',"%$query%")->orLike('authorEmail',"%$query%")->orLike('authorIp',"%$query%");
            } else {
                DB::init()->connect()->like('comments.content', "%$query%")->orLike('comments.authorName',"%$query%")->orLike('comments.authorEmail',"%$query%")->orLike('comments.authorIp',"%$query%");
            }
        }
        if (!empty($status)) {
            $statusKey = empty($join) ? 'status' : 'comments.status';
            DB::init()->connect()->where($statusKey, '=', $status);
            if ($status == 'pending') {
                $orderKey = empty($join) ? 'addedOn' : 'comments.addedOn';
                DB::init()->connect()->orderBy($orderKey, 'ASC');
            } else {
                $orderKey = empty($join) ? 'addedOn' : 'comments.addedOn';
                DB::init()->connect()->orderBy($orderKey, 'DESC');
            }
        } else {
            $statusInKeys = empty($join) ? 'status' : 'comments.status';
            DB::init()->connect()->in($statusInKeys, ['pending', 'approved']);
            $orderKey = empty($join) ? 'addedOn' : 'comments.addedOn';
            DB::init()->connect()->orderBy($orderKey, 'DESC');
        }

        $this->comments = DB::init()->connect()->table(self::$_table)->select($fields)->pagination($this->limit, $this->page)->indexKey('commentId')->getAllIndexes();

        if (!empty($this->comments)) {
            foreach ($this->comments as $commentId => $comment) {
                $this->comments[$commentId]->addedOn = adjustTime($comment->addedOn, false, 'd.m.Y');
                $articleIds[$comment->articleId] = $comment->articleId;
                $this->comments[$commentId]->statusName = lang('comments:statuses:' . $comment->status);
            }

            if (!empty($articleIds)) {
                if ($articles = DB::init()->connect()->table(static::$_table_articles)->select('articleId, title, url')->in('articleId', array_keys($articleIds))->getAll()) {
                    foreach ($articles as $item) $articles[$item->articleId] = $item;
                    foreach ($this->comments as $commentId => $comment)
                        $this->comments[$commentId]->article = $articles[$comment->articleId];
                }
            }
        }

    }

    /**
     * @param string|null $query
     * @param string|null $status
     */
    public function countComments(?string $query, ?string $status)
    {
        if (!empty($query)) {
            if (empty($join)) {
                DB::init()->connect()->like('content', "%$query%")->orLike('authorName',"%$query%")->orLike('authorEmail',"%$query%")->orLike('authorIp',"%$query%");
            } else {
                DB::init()->connect()->like('comments.content', "%$query%")->orLike('comments.authorName',"%$query%")->orLike('comments.authorEmail',"%$query%")->orLike('comments.authorIp',"%$query%");
            }
        }
        if (!empty($status)) {
            $statusKey = empty($join) ? 'status' : 'comments.status';
            DB::init()->connect()->where($statusKey, '=', $status);
            $orderKey = empty($join) ? 'addedOn' : 'comments.addedOn';
            if ($status == 'pending') {
                DB::init()->connect()->orderBy($orderKey, 'ASC');
            } else {
                DB::init()->connect()->orderBy($orderKey, 'DESC');
            }
        } else {
            $statusInKeys = empty($join) ? 'status' : 'comments.status';
            DB::init()->connect()->in($statusInKeys, ['pending', 'approved']);
            $orderKey = empty($join) ? 'addedOn' : 'comments.addedOn';
            DB::init()->connect()->orderBy($orderKey, 'DESC');
        }

        $this->total = DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }

    /**
     * @param $commentId
     * @return string
     */
    public function edit($commentId)
    {
        if (!empty($commentId)) {
            if ($comment = DB::init()->connect()->table(static::$_table)->where('commentId','=', $commentId)->get()) {
                /* getting info about users who created and modified the comment */
                $usersArr = DB::init()->connect()->table('users')->where('userId','=', $comment->modifiedBy)->getAll();
                foreach ($usersArr as $item) $users[$item->userId] = $item;
                $comment->modifiedBy = empty($users[$comment->modifiedBy]) ? unknownUser() : $users[$comment->modifiedBy];
                $comment->addedOn    = langDate(adjustTime($comment->addedOn, false, 'F j, Y H:i'));
                $comment->modifiedOn = langDate(adjustTime($comment->modifiedOn, false, 'F j, Y H:i'));

                return $comment;
            }
        }
        return null;
    }

    public function getComment($comment)
    {
        if (!(DB::init()->connect()->table(static::$_table)->where('commentId','=', $comment['commentId'])->get())) return false;
        return true;
    }

    public function update($comment, $manager)
    {
        if (!empty($comment['commentId'])) {
            unset($comment['addedOn']);
            $comment['modifiedBy'] = $manager->userId;
            $comment['modifiedOn'] = gmdate('Y-m-d H:i:s');

            if (DB::init()->connect()->table(static::$_table)->where('commentId','=', $comment['commentId'])->update($comment)) {
//                $article = DB::init()->connect()->table(static::$_table)->select('articleId')->where('commentId','=', $comment['commentId'])->get();
               /**  получение articleId @var  $articleId */
                $articleId = $this->getArticleId($comment['commentId']);
                /** Получение кол-ва комментариев @var $totalComments */
                $totalComments = $this->totalComments($articleId);
                /** обновление кол-ва комментариев у контента по его articleId */
                $this->updateArticleTotalComments($articleId, $totalComments->count);
                /** votes $article->votes */
                if ($comment['status'] == 'approved' && $comment['checkRating'] == 0) {
                    $this->setRating($articleId, $comment['rating'], $comment['commentId']);
                }

                return true;
            }

        }
        return false;
    }

    /**
     * Обновление рейтинга у контента
     *
     * TODO: продумать что при сохранение не дублировать данные
     * @param $articleId
     * @param $rating
     * @param $commentId
     */
    private function setRating($articleId, $rating, $commentId)
    {
        $article = DB::init()->connect()->table(static::$_table_articles)->select('articleId, rating, votes')->where('articleId','=', $articleId)->get();
        if ($article) {
            $article->rating = number_format(($article->rating * $article->votes + $rating) / ($article->votes + 1), 1, '.', ',');
            $article->votes = $article->votes + 1;
            DB::init()->connect()->table(static::$_table_articles)->where('articleId','=', $article->articleId)->update(['rating' => $article->rating, 'votes' => $article->votes]);
            DB::init()->connect()->table(static::$_table)->where('commentId','=', $commentId)->update(['checkRating' => 1]);
        }
    }

    /**
     * получение articleId
     * @param $commentId
     * @return mixed
     */
    private function getArticleId($commentId)
    {
        $article = DB::init()->connect()->table(static::$_table)->select('articleId')->where('commentId','=', $commentId)->get();

        return $article->articleId;
    }

    /**
     * Получение кол-ва комментариев
     * @param $articleId
     * @return array|false|mixed|string
     */
    private function totalComments($articleId) {
        return DB::init()->connect()->table(static::$_table)->count('*', 'count')->where('articleId','=', $articleId)->where('status', '=', 'approved')->get();
    }


    /**
     * обновление кол-ва комментариев у статьи
     * @param $articleId
     * @param $totalComments
     */
    private function updateArticleTotalComments($articleId, $totalComments)
    {
        DB::init()->connect()->table(static::$_table_articles)->where('articleId','=', $articleId)->update(['totalComments' => $totalComments]);
    }

    /**
     * @param $bulk
     * @return bool
     */
    public function bulk($bulk)
    {
        if (!empty($bulk)) {
            // 'valueKey' => 'articleId'
            $articleIds = DB::init()->connect()->table(static::$_table)->select('DISTINCT articleId')->in('commentId', array_keys($bulk))->indexKey('articleId')->getAllIndexes();

            foreach ($bulk as $commentId => $commentStatus) {
                if ($commentStatus == 1) {
                    DB::init()->connect()->table(static::$_table)->where('commentId','=', $commentId)->update(['status' => 'approved']);
                } elseif ($commentStatus == 2) {
                    DB::init()->connect()->table(static::$_table)->where('commentId','=', $commentId)->update(['status' => 'spam']);
                } elseif ($commentStatus == 3) {
                    DB::init()->connect()->table(static::$_table)->where('commentId','=', $commentId)->delete();
                } elseif ($commentStatus == 0) {
                    DB::init()->connect()->table(static::$_table)->where('commentId','=', $commentId)->update(['status' => 'pending']);
                }
            }

            /* update totalComments */
            // 'indexKey'=>'articleId', 'valueKey'=>'totalComments'
            $commentTotals = DB::init()->connect()->table(static::$_table)->select('articleId')
                ->in('articleId', array_keys($articleIds))
                ->where('status','=','approved')
                ->count('*', 'totalComments')
                ->groupBy('articleId')
                ->getAll();

//            print_r($commentTotals);
            /** TODO: Выдает ошибку по $articleId так как его нет  */
            foreach($commentTotals as $comments) {
                DB::init()->connect()->table(static::$_table_articles)->where('articleId','=', $comments->articleId)->update(
                    ['totalComments' => $comments->totalComments]
                );
            }
            return true;
        }
        return false;
    }


    /**
     * получение кол-во комментариев ожидающих подтверждение
     *
     * @return mixed|string|null
     */
    public function totalPendingComments()
    {
        return DB::init()->connect()->table('comments')->where('status', '=','pending')->count('*', 'count')->getValue();
    }

    /**
     * получение комментариев ожидающих подтверждение
     *
     * @return array|false|mixed|string
     */
    public function getPendingComments()
    {
        return DB::init()->connect()->table('comments')->where('status', '=','pending')->getAll();
    }

}