<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;
use Mnv\Core\Files\Image\ImageSizes;

/**
 * Class Brands
 * @package Mnv\Models
 */
class Brands extends Mnv
{
    private static $_table   = 'brands';
    private static $_files   = 'files';
    private $_fields = array('brandId', 'name', 'url', 'publishedOn', 'orderBy', 'status', 'fileId');

    public $brand;
    public $brands;
    public $brandId;
    protected $section;

    /**
     * Brands constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @return array
     */
    public function getBrands(): array
    {
        $brandList = array();
        if ($brands = DB::init()->connect()->table('brands')->orderBy('name')->getAll()) {
            foreach ($brands as $key => $brand) {
                $letter = mb_substr(mb_strtolower($brand->name), 0, 1);
                $brandList[$letter][] = $brand;

            }
            ksort($brandList);
            //print_r($brandList);
        }
        return $brandList;
    }

    /**
     * @param $start
     * @param $length
     * @param string $searchValue
     * @param $columnSortOrder
     * @param $columnName
     * @return array|false|mixed|string
     */
    public function getTableBrands($start, $length, $searchValue = '', $columnSortOrder, $columnName)
    {
        $query = $searchValue['value'];
        if (!empty($query)) DB::init()->connect()->like('name', "%".$query . "%")->orLike('description', "%".$query . "%")->orLike('content', "%".$query . "%");

        $columnIndex = $columnSortOrder[0]['column'];
        if ($columnSortOrder) {
            DB::init()->connect()->orderBy($columnName[$columnIndex]['data'], $columnSortOrder[0]['dir']);
        } else {
            DB::init()->connect()->orderBy('orderBy', 'ASC');
        }

        $this->brands = DB::init()->connect()->table(self::$_table)->select('brandId, fileId, name, status, url')->limit($start, $length)->getAll();
        foreach ($this->brands as $brandId => $brand) {
            $this->brands[$brandId]->statusName = lang('brands:statuses:'.$brand->status);
            if ($brand->fileId > 0) $this->brands[$brandId]->image = $this->get_image_table($brand);

            unset($this->brands[$brandId]->fileId);
        }

        return $this->brands;
    }

    public function countTableBrands()
    {
        return DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }

    public function countTableFilteredBrands($searchValue = '')
    {
        $query = $searchValue['value'];
        if (!empty($query)) DB::init()->connect()->like('name', "%".$query . "%")->orLike('description', "%". $query . "%")->orLike('content', "%".$query . "%");

        return DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }

    /**
     * вывод без ajax
     * Получение всех статей
     * @param $where
     * @return int
     */
    public function getAllBrands($where)
    {
        $this->brands = DB::init()->connect()->table(self::$_table)->select($this->_fields)->pagination($this->limit, $this->page)->orderBy('orderBy','ASC')->where($where)->getAll();
        foreach ($this->brands as $brandId => $brand) {
            if ($brand->fileId > 0) {
                $this->brands[$brandId]->image = $this->get_image($brand);
            }
        }

        return $this->brands;
    }

    /**
     * вывод без ajax
     * Получение кол-во статей
     * @param $where
     * @return int
     */
    public function countBrands($where)
    {
        return DB::init()->connect()->table(self::$_table)->count('*', 'count')->where($where)->getValue();
    }

    /**
     * получать изображения в статье
     * @param $brand
     */
    private function get_image_table($brand)
    {
        $image = '';
        $file = DB::init()->connect()->table(self::$_files)->select('path, fileName')->where('fileId', $brand->fileId)->get();
        if ($file) $image = $file->path . $file->fileName;

        return $image;
    }


    /**
     * Редактирование
     */
    public function editBrand()
    {
        if (!empty($this->brandId)) {
            if ($this->brand = DB::init()->connect()->table(self::$_table)->select('*')->where('brandId', $this->brandId)->get()) {
                /* получать информацию о пользователе, который создал или редактировал статью */
                $this->brand = $this->get_manager_info($this->brand);
                /* получение основной картинки статьи */
                $this->brand->image = $this->get_image($this->brand);
            }
        }
    }

    /**
     * Проверка на совпадение и получение fileName
     * @param $fileName
     * @return int
     */
    public function isFileName($fileName)
    {
        $fileName = strtolower($fileName);
        if (empty($fileName)) {
            $maxId = DB::init()->connect()->table(self::$_table)->max('brandId')->getValue();
            return $maxId ? $maxId + 1 : 1;
        } elseif (empty($this->brandId)) {
            if ($fileName = DB::init()->connect()->table(self::$_table)->select('fileName')->where('LOWER(fileName)', $fileName)->getValue()) return $fileName;
        } else {
            if ($fileName = DB::init()->connect()->table(self::$_table)->select('fileName')->where('brandId','<>', $this->brandId)->where('LOWER(fileName)', $fileName)->getValue()) return $fileName;
        }
        return null;
    }

    /**
     * TODO Сделано
     * Добавление нового контента
     * @param $brand
     * @return bool
     */
    public function add($brand, $manager)
    {

        $maxId = DB::init()->connect()->table(self::$_table)->max('orderBy')->getValue();
        $brand->orderBy = $maxId ? $maxId + 1 : 1;

        $brand->addedBy      = $manager->userId;
        $brand->addedOn      = gmdate('Y-m-d H:i:s');
        $brand->modifiedBy   = $manager->userId;
        $brand->modifiedOn   = gmdate('Y-m-d H:i:s');
        if ($manager->accessLevel == 1024) $brand->status = 'hidden';

        /* вставляем новую запись и возвращаем ID */
        unset($brand->brandId);

        if ($brandId = DB::init()->connect()->table(self::$_table)->insert((array)$brand)) {
            return $brandId;
        }

        return false;
    }

    /**
     * Обновление контента
     *
     * @param object $brand
     * @param $manager
     * @return bool
     */
    public function update($brand, $manager)
    {
        /* проверка уровня доступа */
        if ($manager->accessLevel == 32) DB::init()->connect()->where('addedBy', $manager->userId);

        if (!empty($brand->brandId)) {
            unset($brand->addedBy);
            unset($brand->addedOn);

            $brand->modifiedBy   = $manager->userId;
            $brand->modifiedOn   = gmdate('Y-m-d H:i:s');
            if ($manager->accessLevel == 32) $brand->status = 'hidden';

            DB::init()->connect()->table(self::$_table)->where('brandId',  $this->brandId)->update((array)$brand);

            $this->get_brand($this->brandId);

        }
        return false;
    }

    /**
     * @param $brandId
     * @return mixed
     */
    private function get_brand($brandId)
    {
        $this->brand =  DB::init()->connect()->table(self::$_table)->where('brandId',  $brandId)->get();
        /* получать информацию о пользователе, который создал или редактировал раздела */
        $this->brand = $this->get_manager_info($this->brand);
        /* получение картинок раздела */
        $this->brand->image = $this->get_image($this->brand);
    }

    /**
     * Удаление
     *
     * @return bool
     */
    public function removeBrand(): bool
    {
        if (DB::init()->connect()->table(self::$_table)->where('brandId', $this->brandId)->delete()) return true;

        return false;
    }

    /**
     * Статус
     *
     * @return array
     */
    public function statusBrand(): array
    {
        if ($brand = DB::init()->connect()->table(self::$_table)->where('brandId',  $this->brandId)->get()) {
            $brandUpdate['status'] = ($brand->status == 'visible') ? 'hidden' : 'visible';
            DB::init()->connect()->table(self::$_table)->where('brandId', $this->brandId)->update($brandUpdate);
            return  array('data' => true, 'status' => $brandUpdate['status']);
        }
        return array('data' => false);

    }
    /**
     * Утверждение
     * @return bool
     */
    public function approveBrand(): bool
    {
        if (DB::init()->connect()->table(self::$_table)->where('brandId', $this->brandId)->update(['status' => 'visible'])) return true;

       return false;

    }

    /**
     * Сортировка товара
     * @param $ids
     * @param $brandIds
     */
    public function reorderBrand($ids, $brandIds)
    {
        foreach ($brandIds as $i => $brandId) {
//           print_r( $ids[$i] . '-' . $brandId . ' : ');
            DB::init()->connect()->table(self::$_table)->where('brandId', '=', $ids[$i])->update(['orderBy' => $brandId]);
        }

    }

    /**
     * TODO Сделано
     * получать основной картинки
     * @param $brand
     * @return ImageSizes
     */
    private function get_image($brand): ?ImageSizes
    {
        $image = null;
        if ($file = DB::init()->connect()->table(self::$_files)->where('fileId', $brand->fileId)->get()) {
            $image = ImageSizes::init()->get(null, $file);
        }

        return $image;
    }

    /**
     * Удаление основной картинки
     * @param $brandId
     * @return bool
     */
    public function deleteImage($brandId)
    {
        if (!empty($brandId)) {
            DB::init()->connect()->table(self::$_table)->where('brandId', $brandId)->update(['fileId' => 0]);
            return true;
        }

        return false;
    }

    /**
     * получать информацию о пользователях, которые создали и изменили статью
     * @param $brand
     * @return mixed
     */
    private function get_manager_info($brand)
    {

        $managers = DB::init()->connect()->table('users')->select('userId, loginName')->in('userId', [$brand->addedBy, $brand->modifiedBy])->indexKey('userId')->getAllIndexes();
        $brand->addedBy    = empty($managers[$brand->addedBy]) ? unknownUser() : $managers[$brand->addedBy];
        $brand->modifiedBy = empty($managers[$brand->modifiedBy]) ? unknownUser() : $managers[$brand->modifiedBy];
        $brand->addedOn    = adjustTime($brand->addedOn, false, 'd.m.Y H:i');
        $brand->modifiedOn = adjustTime($brand->modifiedOn, false, 'd.m.Y H:i');
        $brand->publishedOn = adjustTime($brand->publishedOn);

        return $brand;
    }


}