<?php

namespace Mnv\Models\Blocks;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class Products
 * @package Mnv\Models\Contents
 */
class Blocks extends Mnv
{

    private static $_table = 'blocks';

    public $blockId;
    public $block;
    public $blocks;
    public $total;
    public $result;


    /**
     * фильтрация / сортировка контента
     *
     * @param null $query
     * @param null $status
     */
    private function sorting($query = null, $status = null)
    {

        if (!empty($query))   DB::init()->connect()->like('title', "%$query%")->orLike('content', "%$query%");
        if (!empty($status))  DB::init()->connect()->where('status',  $status);
    }

    /**
     * Получение всех статей
     *
     * @param string|null $query
     * @param string|null $status
     */
    public function getAll(?string $query, ?string $status)
    {
        $this->sorting($query, $status);

        $this->blocks = DB::init()->connect()->table(self::$_table)->select('*')->orderBy('blockId', 'DESC')->indexKey('blockId')->pagination($this->limit, $this->page)->getAllIndexes();
//         print_r(DB::init()->connect()->getQuery());
    }

    /**
     * Получение кол-во контента
     *
     * @param string|null $query
     * @param string|null $status
     */
    public function total(?string $query, ?string $status)
    {
        /** фильтрация / сортировка */
        $this->sorting($query, $status);

        $this->total = DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }

    /**
     * Редактирование и добавление контента
     */
    public function edit()
    {
        $this->block = DB::init()->connect()->table(self::$_table)->where('blockId',  $this->blockId)->get();

    }

    /**
     * Добавление нового контента
     *
     * @param $block
     * @return mixed|void
     */
    public function add($block)
    {

        /* insert новую запись и возвращаем ID */
        if ($this->blockId = DB::init()->connect()->table(self::$_table)->insert((array)$block)) {
            return true;
        } else {
            return false;
        }

    }

    /**
     * Обновление контента
     *
     * @param $block
     */
    public function update($block)
    {
        if (!empty($this->blockId)) {

          if (DB::init()->connect()->table(self::$_table)->where('blockId', $this->blockId)->update((array)$block)) return true;

        }
        return false;
    }


    /**
     * Удаление контента
     *
     * @return mixed|void
     */
    public function remove()
    {
        if ( $this->blockId !== null ) {
            if (DB::init()->connect()->table(self::$_table)->where('blockId', $this->blockId)->delete()) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    /**
     * Изменение статуса
     */
    public function status()
    {
        if ($this->blockId !== null) {
            $this->edit();
            if ($this->block !== null) {
                $blockUpdate['status'] = ($this->block->status == 'visible') ? 'hidden' : 'visible';
                if (DB::init()->connect()->table(self::$_table)->where('blockId', $this->blockId)->update($blockUpdate)) {
                    $this->result = array('data' => true, 'status' => $blockUpdate['status']);
                    return true;
                } else {
                    return false;
                }

            }else {
                return false;
            }
        } else {
            return false;
        }
    }




}