<?php


namespace Mnv\Http\Handler;

use Mnv\Http\JsonResponse;
use Mnv\Http\Response;

/**
 * Class ResponseFactory
 * @package Mnv\Http
 */
class ResponseFactory
{
    /**
     * Return a new response from the application.
     *
     * @param string|null $content
     * @param int $status
     * @param  array  $headers (optional)
     * @return Response
     */
    public function make(string $content = null, int $status = 200, array $headers = []): Response
    {
        return new Response($content, $status, $headers);
    }

    /**
     * Return a new JSON response from the application.
     *
     * @param array $data
     * @param int $status
     * @param array $headers (optional)
     * @param array $options (optional)
     * @return JsonResponse
     */
    public function json(array $data = [], int $status = 200, array $headers = [], $options = 0): JsonResponse
    {
        return new JsonResponse($data, $status, $headers, $options);
    }
}