<?php

namespace Mnv\Core\Test;

use Mnv\Core\DB;

/**
 * Class Logger
 * @package Mnv\App\Test
 */
class Logger
{
	private $log = [];

    /** @var null $db */
    private static $instance = null;

    /** @return DB|null */
    public static function getInstance(): ?Logger
    {
        if ( self::$instance == null )
            self::$instance = new Logger();

        return self::$instance;
    }

    public function __clone() { }
    public function __wakeup() { }

    public function __construct()
	{
	    register_shutdown_function(array($this, 'save'));
	}

	/**
	 * Log error
	 * @param string|null $message
	 * @param bool $save
	 */
	public function error(?string $message, $manager, bool $save = true)
	{
		if ($save) {
			$this->log($message, $manager, "error");
		}
	}

	/**
	 * Log info
	 * @param string|null $message
	 * @param $manager
	 * @param bool $save - on/off write notice in db
	 */
	public function info(?string $message, $manager, bool $save = true)
	{
		if ($save) {
			$this->log($message, $manager, "info");
		}
	}

	/**
	 * Add msg to log
     * @param string|null $message
     * @param $manager
     * @param string $type
     */
	public function log(?string $message, $manager, string $type = "log")
	{
		if ($type != "info" && $type != "error") {
			$type = "log";
		}
		$this->log[] = array("message" => $message, "type" => $type, 'manager' => $manager);
	}

    /**
     * Сохранить (log) в базу данных
     */
	public function save()
	{
	    if (!empty($this->log)) {
			$dump = [];

			foreach ($this->log AS $value) {
                $dump['userId']   = $value["manager"]->userId;
                $dump['message']  = $value["message"];
                $dump['type_log'] = $value["type"];
                $dump['date_log'] = gmdate('Y-m-d H:i:s');
                $dump['user_ip']  = '';
			}
            DB::init()->connect()->table('log')->insert($dump);
		}

	}
}
