<?php

namespace Mnv\Core;

use Smarty;

/**
 * Class Mnv
 * @package Mnv\Models
 */
class Mnv
{
    /** @var Design  */
    public $smarty;

    /** @var array  */
    public $config = array();

    /** @var string $action */
    protected $action;

    /** @var string $module */
    protected $module;

    /** @var string $status */
    protected $status;

    /** @var int $page */
    protected $page = 1;

    /** @var int $limit */
    protected $limit = 20;

    /** @var array $errors */
    public $errors = array();

    /** @var array $messages */
    public $messages = array();

    /** @var array $response */
    public $response = array();

    /** Mnv constructor. */
    public function __construct()
    {
        $this->config       = Config::init()->config();
        $this->smarty       = Design::init()->design();

        /** модуль */
        $this->module = getRequestVar('mod','');

        /** постраничная навигация / по умолчанию страница 1 */
        $this->page          = (int) getRequestVar('page', 1);
        $this->limit         = (int) getRequestVar('limit', 20);

        /** action */
        $this->action        = getRequestVar('action', '');

        /** dates */
        $this->smarty->assign('adjustedNow', adjustTime(gmdate('Y-m-d H:i:s')));


    }


}