<?php


namespace Mnv\Core;

/**
 * Class Maps
 * @package Mnv\Core
 */
class Maps
{

    /**
     * The instance itself
     * @var Maps
     */
    private static $instance;

    private $_maps;

    /** @return Maps */
    public static function init(): Maps
    {
        if (!self::$instance) {
            self::$instance = new Maps();
        }
        return self::$instance;
    }

    public function __construct()
    {
       $this->_maps = DB::init()->connect()->table('maps')->select('codename, value')->indexKey('codename')->valueKey('value')->getAllIndexes();
    }

    /**
     * @return array|mixed|null
     */
    public function get()
    {
        return $this->_maps;
    }

    public function __clone()
    {
        throw new \LogicException('The Maps helper cannot be cloned');
    }

    public function __wakeup()
    {
        throw new \LogicException('The Maps helper cannot be serialised');
    }
}