<?php

namespace Mnv\Core\JSONParser\Writer;

/**
 * SimpleExcel class for writing table as JSON
 *
 * @package JSONParser
 */
class JSONWriter extends BaseWriter implements IWriter
{
    /**
     * Определяет тип содержимого для HTTP-заголовка
     *
     * @access  protected
     * @var     string
     */
    protected $content_type = 'application/json';

    /**
     * Определяет расширение файла, которое будет использоваться при сохранении файла
     *
     * @access  protected
     * @var     string
     */
    protected $file_extension = 'json';

    /**
     * Получить содержимое документа в виде строки
     *
     * @return  string  Content of document
     */
    public function saveString()
    {
        $json = array();
        foreach ($this->table_arr as $row) {
            if (!empty($row))
                array_push($json, $row);
        }

        return json_encode($json, JSON_UNESCAPED_UNICODE|JSON_NUMERIC_CHECK|JSON_PRETTY_PRINT);
    }
}