<?php


namespace Mnv\Core;


class Helpers
{

    /**
     * The instance itself
     * @var Config
     */
    private static $instance;

    /** @return Helpers */
    public static function init(): Helpers
    {
        if (!self::$instance) {
            self::$instance = new Helpers();
        }
        return self::$instance;
    }

    /**
     * @return array
     */
    public function getThemes(): array
    {
        $dh = opendir(GLOBAL_ROOT.'/themes');
        while ($item = readdir($dh)) if ($item != '.' && $item != '..' && $item != 'assets' && is_dir(GLOBAL_ROOT."/themes/$item")) $themes[] = $item;
        sort($themes);
        closedir($dh);

        return $themes;
    }

    /**
     * Блокировка не желательных пользователей (или взломщиков)
     *
     * @param $visitorIp
     * @return string|null
     */
    public function dieIfBanned($visitorIp): ?string
    {
        $result = null;
        if ($ban = DB::init()->connect()->table('users_banned_ips')->where('visitorIp', $visitorIp)->get()) {
            if (strtotime($ban->expiresOn) <= time()) {
                DB::init()->connect()->table('users_banned_ips')->where('visitorIp', $ban->visitorIp)->delete();
            } else {
                $result = "Your IP has been banned until $ban->expiresOn.";
            }
        }

        return $result;
    }

    /**
     * @param int $skipId
     * @param int $maxDepth
     * @param string $prefix
     * @param string $separator
     * @return array
     */
    public function getAllSectionOptions(int $skipId = 0, int $maxDepth = 99, $prefix = '', $separator = ' - '): array
    {
        global $SECTIONS;

        if (empty($SECTIONS)) return array();

        $skipChildren = array();
        $options = array(0 => lang('general:selectedSection'));
        foreach ($SECTIONS as $section) {
            if ($section->sectionId == $skipId) {
                if (!empty($section->allChildren)) $skipChildren = $section->allChildren;
                continue;
            }
            if (in_array($section->sectionId, $skipChildren)) continue;
            if ($section->level > $maxDepth) continue;

            $option = '';
            if (!empty($section->parents)) {
                foreach ($section->parents as $parentId) {
                    if (!empty($SECTIONS[$parentId])) $option .= $separator; // $option .= /*$SECTIONS[$parentId]->name.*/ $separator;
                }
            }
            $option .= $section->name;
            $options[$section->sectionId] = $option;
        }

        if (count($options) == 1) return array();

        return $options;
    }

    /**
     * @param int $skipId
     * @param int $maxDepth
     * @param string $prefix
     * @param string $separator
     * @return array
     */
    public function getSectionOptions(int $skipId = 0, int $maxDepth = 99, $prefix = '', $separator = ' - '): array
    {
        global $SECTIONS;

        if (empty($SECTIONS)) return array();

        $skipChildren = array();
        $options = array(0 => lang('general:selectedSection'));
        foreach ($SECTIONS as $section) {
            if ($section->type == 'plain') continue;
            if ($section->sectionId == $skipId) {
                if (!empty($section->allChildren)) $skipChildren = $section->allChildren;
                continue;
            }
            if (in_array($section->sectionId, $skipChildren)) continue;
            if ($section->level > $maxDepth) continue;

            $option = '';
            if (!empty($section->parents)) {
                foreach ($section->parents as $parentId) {
                    if (!empty($SECTIONS[$parentId])) $option .= $separator; // $option .= /*$SECTIONS[$parentId]->name.*/ $separator;
                }
            }
            $option .= $section->name;
            $options[$section->sectionId] = $option;
        }

        if (count($options) == 1) return array();

        return $options;
    }

    /**
     * @param int $skipId
     * @param int $maxDepth
     * @param string $separator
     * @return array
     */
    public function getSectionContentNotTypeContent($skipId = 0, $maxDepth = 99, $separator = ' - ')
    {
        global $SECTIONS;

        if (empty($SECTIONS)) return array();

        $skipChildren = array();
        $options = array(0 => lang('general:selectedSection'));
        foreach ($SECTIONS as $section) {
//            if($section->type == 'plain') continue;
            if ($section->sectionId == $skipId) {
                if (!empty($section->allChildren)) $skipChildren = $section->allChildren;
                continue;
            }
            if (in_array($section->sectionId, $skipChildren)) continue;
            if ($section->level > $maxDepth) continue;

            $option = '';
            if (!empty($section->parents)) foreach($section->parents as $parentId) {
//                if (!empty($SECTIONS[$parentId])) $option .= $separator; // $option .= $SECTIONS[$parentId]->name . $separator
                if (!empty($SECTIONS[$parentId])) $option .= $SECTIONS[$parentId]->name . $separator;
            }
            $option .= $section->name;
            $options[$section->sectionId] = $option;
        }

        if (count($options) == 1) return array();

        return $options;
    }

    /**
     * @param int $skipId
     * @param string $typeContent
     * @param int $maxDepth
     * @param string $separator
     * @return array
     */
    public function getSectionContent($skipId = 0, $typeContent, $maxDepth = 99, $separator = ' - ')
    {
        global $SECTIONS;

        if (empty($SECTIONS)) return array();

        $skipChildren = array();
        $options = array(0 => lang('general:selectedSection'));
        foreach ($SECTIONS as $section) {
            if($section->type == 'plain') continue;
            if ($section->sectionId == $skipId || $section->typeContent != $typeContent) {
                if (!empty($section->allChildren)) $skipChildren = $section->allChildren;
                continue;
            }
            if (in_array($section->sectionId, $skipChildren)) continue;
            if ($section->level > $maxDepth) continue;

            $option = '';
            if (!empty($section->parents)) foreach($section->parents as $parentId) {
                if (!empty($SECTIONS[$parentId])) $option .= $separator; // $option .= $SECTIONS[$parentId]->name . $separator
            }
            $option .= $section->name;
            $options[$section->sectionId] = $option;
        }

        if (count($options) == 1) return array();

        return $options;
    }


    /**
     * @param $skipIds
     * @param string $typeContent
     * @param int $maxDepth
     * @param string $separator
     * @return array
     */
    public function getSectionContentNew($skipIds = 0, $typeContent, $maxDepth = 99, $separator = ' - ')
    {
        global $SECTIONS;

        if (empty($SECTIONS)) return array();

        $skipChildren = array();
        $options = array(0 => lang('general:selectedSection'));
        foreach ($SECTIONS as $section) {
            if($section->type == 'plain') continue;
            if (in_array($section->sectionId, $skipIds)) {
                if (!empty($section->allChildren)) $skipChildren = $section->allChildren;
                continue;
            }
            if (in_array($section->sectionId, $skipChildren)) continue;
            if ($section->level > $maxDepth) continue;

            $option = '';
            if (!empty($section->parents)) foreach($section->parents as $parentId) {
                if (!empty($SECTIONS[$parentId])) $option .= $separator;
            }
            $option .= $section->name;
            $options[$section->sectionId] = $option;
        }

        if (count($options) == 1) return array();

        return $options;
    }

    /**
     * @param $date
     * @return false|string
     */
    public function dateFormation($date)
    {
        $date['publishedOn'] = $date['Year'] . '-' . $date['Month'] . '-' . $date['Day'] . ' ' . $date['Hour'] . ':' . $date['Minute'] .':00';
        if (!empty($date['Meridian'])) $date['publishedOn'] .= " $date[Meridian]";
        return date('Y-m-d H:i:s', strtotime($date['publishedOn']));
    }

}